/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib.Threads;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.documentfile.provider.DocumentFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import org.tcshare.fileselectorlib.Objects.BasicParams;
import org.tcshare.fileselectorlib.Objects.FileInfo;
import org.tcshare.fileselectorlib.Utils.FileUtil;
import org.tcshare.fileselectorlib.Utils.TimeUtil;

public class ListFileThread
extends Thread {
    public static final int PROCESS_DONE = 1001;
    private Handler handler;
    private Message message;
    private CountDownLatch countDownLatch;
    private ArrayList<FileInfo> fileInfoList;
    private File[] fileList;
    private DocumentFile[] protectedFileList;
    private FileInfo.AccessType accessType;

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void callback(int event, Object object) {
        if (this.handler != null) {
            this.message = this.handler.obtainMessage();
        }
        if (this.message != null) {
            this.message.what = event;
            if (object != null) {
                this.message.obj = object;
            }
            this.handler.sendMessage(this.message);
        }
    }

    public ListFileThread(File[] fileList) {
        this.fileList = fileList;
        this.accessType = FileInfo.AccessType.Open;
    }

    public ListFileThread(DocumentFile[] protectedFileList) {
        this.protectedFileList = protectedFileList;
        this.accessType = FileInfo.AccessType.Protected;
    }

    private void getOpenFileList() {
        this.fileInfoList = new ArrayList();
        for (File f : this.fileList) {
            FileInfo fileInfo;
            if (f.getName().indexOf(".") == 0) continue;
            if (f.isDirectory()) {
                fileInfo = new FileInfo();
                fileInfo.setFileName(f.getName());
                fileInfo.setFileLastUpdateTime(TimeUtil.getDateInString(new Date(f.lastModified())));
                fileInfo.setFileType(FileInfo.FileType.Folder);
                fileInfo.setFilePath(f.getPath());
                fileInfo.setFileCount(FileUtil.getSubfolderNum(f.getPath()));
                fileInfo.setAccessType(FileInfo.judgeAccess(f.getPath()));
                this.fileInfoList.add(fileInfo);
                continue;
            }
            if (BasicParams.getInstance().isUseFilter() && !FileUtil.fileFilter(f.getPath(), BasicParams.getInstance().getFileTypeFilter())) continue;
            fileInfo = new FileInfo();
            if (FileUtil.isAudioFileType(f.getPath())) {
                fileInfo.setFileType(FileInfo.FileType.Audio);
            } else if (FileUtil.isImageFileType(f.getPath())) {
                fileInfo.setFileType(FileInfo.FileType.Image);
            } else if (FileUtil.isVideoFileType(f.getPath())) {
                fileInfo.setFileType(FileInfo.FileType.Video);
            } else if (FileUtil.isTextFileType(f.getPath())) {
                fileInfo.setFileType(FileInfo.FileType.Text);
            } else {
                fileInfo.setFileType(FileInfo.FileType.Unknown);
            }
            fileInfo.setFileName(f.getName());
            fileInfo.setFileLastUpdateTime(TimeUtil.getDateInString(new Date(f.lastModified())));
            fileInfo.setFilePath(f.getPath());
            fileInfo.setFileCount(f.length());
            fileInfo.setAccessType(FileInfo.judgeAccess(f.getPath()));
            this.fileInfoList.add(fileInfo);
        }
    }

    private void getProtectedFileList() {
        this.fileInfoList = new ArrayList();
        for (DocumentFile file : this.protectedFileList) {
            if (file.getName() == null || file.getName().indexOf(".") == 0) continue;
            Log.d((String)"Android\u4fdd\u62a4\u6587\u4ef6", (String)file.getName());
            if (file.isDirectory()) {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(file.getName());
                fileInfo.setFileLastUpdateTime(TimeUtil.getDateInString(new Date(file.lastModified())));
                fileInfo.setFileType(FileInfo.FileType.Folder);
                fileInfo.setAccessType(FileInfo.AccessType.Protected);
                String path = FileUtil.changeToPath(file.getUri().toString());
                fileInfo.setFilePath(path);
                fileInfo.setFileCount(FileUtil.getSubFolderNum(file));
                this.fileInfoList.add(fileInfo);
                continue;
            }
            String path = FileUtil.changeToPath(file.getUri().toString());
            if (BasicParams.getInstance().isUseFilter() && !FileUtil.fileFilter(path, BasicParams.getInstance().getFileTypeFilter())) continue;
            FileInfo fileInfo = new FileInfo();
            if (FileUtil.isAudioFileType(path)) {
                fileInfo.setFileType(FileInfo.FileType.Audio);
            } else if (FileUtil.isImageFileType(path)) {
                fileInfo.setFileType(FileInfo.FileType.Image);
            } else if (FileUtil.isVideoFileType(path)) {
                fileInfo.setFileType(FileInfo.FileType.Video);
            } else if (FileUtil.isTextFileType(path)) {
                fileInfo.setFileType(FileInfo.FileType.Text);
            } else {
                fileInfo.setFileType(FileInfo.FileType.Unknown);
            }
            fileInfo.setFileName(file.getName());
            fileInfo.setFileLastUpdateTime(TimeUtil.getDateInString(new Date(file.lastModified())));
            fileInfo.setFilePath(path);
            fileInfo.setFileCount(file.length());
            fileInfo.setAccessType(FileInfo.AccessType.Protected);
            this.fileInfoList.add(fileInfo);
        }
    }

    @Override
    public void run() {
        super.run();
        switch (this.accessType) {
            case Open: {
                this.getOpenFileList();
                break;
            }
            case Protected: {
                this.getProtectedFileList();
                break;
            }
        }
        this.callback(1001, this.fileInfoList);
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public static interface FileListListener {
        public void onFileListGenerated(ArrayList<FileInfo> var1);
    }

    public static class FileListHandler
    extends Handler {
        private FileListListener listener;

        public FileListHandler(FileListListener listener) {
            this.listener = listener;
        }

        public void handleMessage(@NonNull Message msg) {
            if (msg.what == 1001) {
                this.listener.onFileListGenerated((ArrayList)msg.obj);
            }
        }
    }
}

