/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib.Objects;

import org.tcshare.fileselectorlib.Utils.FileUtil;

public class FileInfo {
    private String FileName;
    private long FileCount;
    private String FileLastUpdateTime;
    private String FilePath;
    private FileType fileType;
    private AccessType accessType;

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String fileName) {
        this.FileName = fileName;
    }

    public String getFileCount() {
        if (this.fileType == FileType.Parent) {
            return "";
        }
        if (this.FileCount == -1L && this.fileType == FileType.Folder) {
            return "\u53d7\u4fdd\u62a4\u7684\u6587\u4ef6\u5939";
        }
        if (this.fileType == FileType.Folder) {
            return "\u5171" + this.FileCount + "\u9879";
        }
        return FileUtil.getFileSize(this.FileCount);
    }

    public void setFileCount(long fileCount) {
        this.FileCount = fileCount;
    }

    public String getFileLastUpdateTime() {
        return this.FileLastUpdateTime;
    }

    public void setFileLastUpdateTime(String fileLastUpdateTime) {
        this.FileLastUpdateTime = fileLastUpdateTime;
    }

    public String getFilePath() {
        return this.FilePath;
    }

    public void setFilePath(String filePath) {
        this.FilePath = filePath;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isDirectory() {
        return this.fileType == FileType.Folder;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public static AccessType judgeAccess(String path) {
        boolean isProtectedDir = false;
        if (path.contains("Android/data")) {
            isProtectedDir = true;
        }
        if (path.contains("Android/obb")) {
            isProtectedDir = true;
        }
        return isProtectedDir ? AccessType.Protected : AccessType.Open;
    }

    public AccessType getAccessType() {
        if (this.accessType == null) {
            this.accessType = FileInfo.judgeAccess(this.FilePath);
        }
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public boolean FileFilter(FileType[] types) {
        for (FileType type : types) {
            if (this.fileType == type) {
                return true;
            }
            if (type != FileType.File || this.fileType == FileType.Folder) continue;
            return true;
        }
        return false;
    }

    public static enum FileType {
        Folder,
        Video,
        Audio,
        Image,
        Text,
        Unknown,
        File,
        Parent;

    }

    public static enum AccessType {
        Open,
        Protected;

    }
}

