/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Arrays;
import org.tcshare.activity.TCFileSelectorActivity;
import org.tcshare.fileselectorlib.FileSelectorTheme;
import org.tcshare.fileselectorlib.Objects.BasicParams;
import org.tcshare.fileselectorlib.Objects.FileInfo;
import org.tcshare.permission.PermissionHelper;
import org.tcshare.utils.ToastUtil;

public class FileSelectorSettings {
    private BasicParams basicParams = BasicParams.getInitInstance();
    public static String FILE_PATH_LIST_REQUEST = "file_path_list";
    public static int BACK_WITHOUT_SELECT = 510;
    public static int BACK_WITH_SELECTIONS = 511;
    public static int FILE_LIST_REQUEST_CODE = 512;

    public FileSelectorSettings setRootPath(String path) {
        this.basicParams.setRootPath(path);
        return this;
    }

    public FileSelectorSettings setMaxFileSelect(int num) {
        this.basicParams.setMaxSelectNum(num);
        return this;
    }

    public FileSelectorSettings setTitle(String title) {
        this.basicParams.setTips(title);
        return this;
    }

    public FileSelectorSettings setTheme(FileSelectorTheme theme) {
        this.basicParams.setTheme(theme);
        return this;
    }

    public FileSelectorSettings setFileTypesToSelect(FileInfo.FileType ... fileTypes) {
        if (Arrays.asList(fileTypes).contains((Object)FileInfo.FileType.Parent)) {
            throw new IllegalArgumentException("\u7c7b\u578b\u4e0d\u80fd\u5305\u542bparent");
        }
        this.basicParams.setSelectableFileTypes(fileTypes);
        return this;
    }

    public FileSelectorSettings setFileTypesToShow(String ... extensions) {
        this.basicParams.setFileTypeFilter(extensions);
        this.basicParams.setUseFilter(true);
        return this;
    }

    public FileSelectorSettings setCustomizedIcons(String[] extensions, Bitmap ... icons) {
        if (extensions.length != icons.length) {
            throw new IllegalArgumentException("\u6587\u4ef6\u6269\u5c55\u540d\u5fc5\u987b\u4e0e\u81ea\u5b9a\u4e49\u56fe\u6807\u4e00\u4e00\u5bf9\u5e94");
        }
        for (int i = 0; i < extensions.length; ++i) {
            this.basicParams.addCustomIcon(extensions[i], icons[i]);
        }
        return this;
    }

    public FileSelectorSettings setCustomizedIcons(String[] extensions, Context context, int ... icon_ids) {
        if (extensions.length != icon_ids.length) {
            throw new IllegalArgumentException("\u6587\u4ef6\u6269\u5c55\u540d\u5fc5\u987b\u4e0e\u81ea\u5b9a\u4e49\u56fe\u6807\u4e00\u4e00\u5bf9\u5e94");
        }
        for (int i = 0; i < extensions.length; ++i) {
            Bitmap icon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon_ids[i]);
            this.basicParams.addCustomIcon(extensions[i], icon);
        }
        return this;
    }

    public FileSelectorSettings setMoreOptions(String[] optionsName, BasicParams.OnOptionClick ... onOptionClicks) {
        if (optionsName.length != onOptionClicks.length) {
            throw new IllegalArgumentException("\u9009\u9879\u540d\u548c\u70b9\u51fb\u54cd\u5e94\u5fc5\u987b\u4e00\u4e00\u5bf9\u5e94");
        }
        this.basicParams.setNeedMoreOptions(true);
        this.basicParams.setOptionsName(optionsName);
        this.basicParams.setOnOptionClicks(onOptionClicks);
        return this;
    }

    public static String getSystemRootPath() {
        return BasicParams.BasicPath;
    }

    public FileSelectorSettings setFileListRequestCode(int fileListRequestCode) {
        FILE_LIST_REQUEST_CODE = fileListRequestCode;
        return this;
    }

    public static boolean checkPermision(Context ctx) {
        if (Build.VERSION.SDK_INT >= 30) {
            if (Environment.isExternalStorageManager()) {
                return true;
            }
            Toast.makeText((Context)ctx, (CharSequence)"Android \u7248\u672c11\u4e4b\u540e\uff0c\u9700\u8981\u9009\u62e9\u6587\u4ef6\u6743\u9650!", (int)1).show();
            Intent intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
            intent.setData(Uri.parse((String)("package:" + ctx.getPackageName())));
            ctx.startActivity(intent);
            return false;
        }
        return true;
    }

    public void show(final Context ctx, final CallBack callBack) {
        if (!FileSelectorSettings.checkPermision(ctx)) {
            return;
        }
        PermissionHelper.request(ctx, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, FILE_LIST_REQUEST_CODE, new PermissionHelper.Callback(){

            @Override
            public void onResult(int requestCode, String[] permissions, int[] grantResult) {
                boolean granted = true;
                for (int grant : grantResult) {
                    if (0 == grant) continue;
                    granted = false;
                    break;
                }
                if (!granted) {
                    ToastUtil.showToastShort(ctx, "\u8bf7\u6388\u4e88\u8bfb\u5199\u6587\u4ef6\u7684\u6743\u9650\uff01");
                } else {
                    Intent intent = new Intent();
                    intent.putExtra("file_result_receiver", (Parcelable)new ResultReceiver(new Handler()){

                        protected void onReceiveResult(int resultCode, Bundle resultData) {
                            ArrayList files;
                            super.onReceiveResult(resultCode, resultData);
                            ArrayList<String> filePathSelected = new ArrayList<String>();
                            if (resultCode == BACK_WITH_SELECTIONS && (files = resultData.getStringArrayList(FILE_PATH_LIST_REQUEST)) != null) {
                                filePathSelected.addAll(files);
                            }
                            callBack.onResult(resultCode, filePathSelected);
                        }
                    });
                    intent.setFlags(65536);
                    intent.setClass(ctx, TCFileSelectorActivity.class);
                    ctx.startActivity(intent);
                }
            }
        });
    }

    public static interface CallBack {
        public void onResult(int var1, ArrayList<String> var2);
    }
}

