/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.adapter;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import androidx.appcompat.app.AlertDialog;
import com.bumptech.glide.Glide;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tcshare.androidutils.R;
import org.tcshare.utils.SelectOnePicture;
import org.tcshare.utils.ToastUtil;

public class ChoosePhotoListAdapter
extends BaseAdapter {
    public int maxSize = 9;
    private LayoutInflater mInflater;
    private Context context;
    private List<Pair<String, Object>> list = new ArrayList<Pair<String, Object>>();
    private BeforeAddListener beforeAddListener;
    private BeforeDelListener beforeDelListener;

    public ChoosePhotoListAdapter(Context context) {
        this.context = context;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public void setListener(BeforeAddListener beforeAddListener, BeforeDelListener beforeDelListener) {
        this.beforeAddListener = beforeAddListener;
        this.beforeDelListener = beforeDelListener;
    }

    public int getCount() {
        if (this.list.size() < this.maxSize) {
            return this.list.size() + 1;
        }
        return this.list.size();
    }

    public Pair<String, Object> getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void setData(List<String> lt) {
        this.list.clear();
        for (String s : lt) {
            this.list.add((Pair<String, Object>)Pair.create((Object)s, null));
        }
        this.notifyDataSetChanged();
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = this.mInflater.inflate(R.layout.item_selectpic_showphoto, parent, false);
            holder.item_show_photo = (ImageView)convertView.findViewById(R.id.item_show_photo);
            holder.item_add_photo = (ImageView)convertView.findViewById(R.id.item_add_photo);
            holder.item_del_photo = (ImageView)convertView.findViewById(R.id.item_del_photo);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        if (this.list.size() < this.maxSize) {
            if (this.list.size() == 0 || position >= this.list.size()) {
                holder.item_add_photo.setVisibility(0);
                holder.item_show_photo.setVisibility(8);
                holder.item_del_photo.setVisibility(8);
            } else {
                holder.item_add_photo.setVisibility(8);
                holder.item_show_photo.setVisibility(0);
                holder.item_del_photo.setVisibility(0);
                String path = (String)this.list.get((int)position).first;
                if (path.startsWith("http")) {
                    Glide.with((Context)this.context).load(path).into(holder.item_show_photo);
                } else {
                    Glide.with((Context)this.context).load(new File(path)).into(holder.item_show_photo);
                }
            }
        } else {
            holder.item_del_photo.setVisibility(0);
            holder.item_show_photo.setVisibility(0);
            holder.item_add_photo.setVisibility(8);
            String path = (String)this.list.get((int)position).first;
            if (path.startsWith("http")) {
                Glide.with((Context)this.context).load(path).into(holder.item_show_photo);
            } else {
                Glide.with((Context)this.context).load(new File(path)).into(holder.item_show_photo);
            }
        }
        holder.item_add_photo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectOnePicture.doSelect(ChoosePhotoListAdapter.this.context, new SelectOnePicture.CallBack(){

                    @Override
                    public void onResult(int resultCode, final String path) {
                        if (resultCode != -1) {
                            return;
                        }
                        if (ChoosePhotoListAdapter.this.beforeAddListener != null) {
                            if ("".equals(path) || null == path) {
                                ToastUtil.showToastShort(ChoosePhotoListAdapter.this.context, "\u65e0\u6cd5\u8bfb\u53d6\u8be5\u4f4d\u7f6e\u6587\u4ef6\uff01");
                                return;
                            }
                            int pos = ChoosePhotoListAdapter.this.list.size();
                            ChoosePhotoListAdapter.this.beforeAddListener.onBeforeAdd(pos, path, new Callback(){

                                @Override
                                public void onTaskFinish(boolean success, Object userObj) {
                                    if (!success) {
                                        return;
                                    }
                                    ChoosePhotoListAdapter.this.list.add(Pair.create((Object)path, (Object)userObj));
                                    ChoosePhotoListAdapter.this.notifyDataSetChanged();
                                }
                            });
                        } else {
                            if ("".equals(path) || null == path) {
                                ToastUtil.showToastShort(ChoosePhotoListAdapter.this.context, "\u65e0\u6cd5\u8bfb\u53d6\u8be5\u4f4d\u7f6e\u6587\u4ef6\uff01");
                                return;
                            }
                            ChoosePhotoListAdapter.this.list.add(Pair.create((Object)path, null));
                            ChoosePhotoListAdapter.this.notifyDataSetChanged();
                        }
                    }
                });
            }
        });
        holder.item_del_photo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new AlertDialog.Builder(ChoosePhotoListAdapter.this.context).setTitle((CharSequence)ChoosePhotoListAdapter.this.context.getString(R.string.title_del_pic)).setMessage((CharSequence)ChoosePhotoListAdapter.this.context.getString(R.string.title_del_pic_msg)).setPositiveButton((CharSequence)ChoosePhotoListAdapter.this.context.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (ChoosePhotoListAdapter.this.beforeDelListener != null) {
                            Pair item = (Pair)ChoosePhotoListAdapter.this.list.get(position);
                            ChoosePhotoListAdapter.this.beforeDelListener.onBeforeDel(position, (String)item.first, item.second, new Callback(){

                                @Override
                                public void onTaskFinish(boolean success, Object userObj) {
                                    if (!success) {
                                        return;
                                    }
                                    ChoosePhotoListAdapter.this.list.remove(position);
                                    ChoosePhotoListAdapter.this.notifyDataSetChanged();
                                }
                            });
                        } else {
                            ChoosePhotoListAdapter.this.list.remove(position);
                            ChoosePhotoListAdapter.this.notifyDataSetChanged();
                        }
                    }
                }).setNegativeButton((CharSequence)ChoosePhotoListAdapter.this.context.getString(R.string.cancel), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                }).show();
            }
        });
        return convertView;
    }

    public List<String> getPicList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Pair<String, Object> p : this.list) {
            result.add((String)p.first);
        }
        return result;
    }

    public void clear() {
        this.list.clear();
        this.notifyDataSetChanged();
    }

    public static interface BeforeDelListener {
        public void onBeforeDel(int var1, String var2, Object var3, Callback var4);
    }

    public static interface BeforeAddListener {
        public void onBeforeAdd(int var1, String var2, Callback var3);
    }

    public static class ViewHolder {
        ImageView item_show_photo;
        ImageView item_add_photo;
        ImageView item_del_photo;
    }

    public static interface Callback {
        public void onTaskFinish(boolean var1, Object var2);
    }
}

