/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import org.tcshare.permission.PermissionHelper;

public class TCRequestPermissionActivity
extends Activity {
    public static final String RESULT_RECEIVER = "result_receiver";
    public static final String PERMISSIONS_ARRAY = "permission_array";
    public static final String REQUEST_CODE = "req_code";
    public static final int DEFAULT_CODE = 2330;
    public static final String GRANT_RESULT = "grunt_result";
    private ResultReceiver resultReceiver;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.overridePendingTransition(0, 0);
        if (this.getIntent() != null) {
            this.resultReceiver = (ResultReceiver)this.getIntent().getParcelableExtra(RESULT_RECEIVER);
            String[] permissionsArray = this.getIntent().getStringArrayExtra(PERMISSIONS_ARRAY);
            int requestCode = this.getIntent().getIntExtra(REQUEST_CODE, 2330);
            if (!PermissionHelper.hasPermissions((Context)this, permissionsArray)) {
                ActivityCompat.requestPermissions((Activity)this, (String[])permissionsArray, (int)requestCode);
            } else {
                this.onComplete(requestCode, permissionsArray, new int[]{0});
            }
        } else {
            this.finish();
        }
    }

    private void onPix() {
        Window window = this.getWindow();
        window.setGravity(51);
        WindowManager.LayoutParams params = window.getAttributes();
        params.x = 0;
        params.y = 0;
        params.height = 1;
        params.width = 1;
        window.setAttributes(params);
    }

    private void onComplete(int requestCode, String[] permissions, int[] grantResults) {
        Bundle bundle = new Bundle();
        bundle.putStringArray(PERMISSIONS_ARRAY, permissions);
        bundle.putIntArray(GRANT_RESULT, grantResults);
        this.resultReceiver.send(requestCode, bundle);
        this.finish();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.onComplete(requestCode, permissions, grantResults);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }
}

