/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.impl.ThreadUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduledExecutorServiceWrapper
implements ScheduledExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledExecutorServiceWrapper.class);
    private final ScheduledExecutorService delegate;
    private final Set<Task> tasks = ConcurrentHashMap.newKeySet();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(ThreadUtils.threadFactory("rabbitmq-stream-scheduled-executor-service-wrapper-"));

    ScheduledExecutorServiceWrapper(ScheduledExecutorService delegate) {
        this.delegate = delegate;
        Duration period = Duration.ofSeconds(10L);
        this.scheduler.scheduleAtFixedRate(() -> {
            LOGGER.debug("Background scheduled task check, {} task(s) submitted", (Object)this.tasks.size());
            try {
                long now = System.nanoTime();
                Duration warningTimeout = Duration.ofSeconds(60L);
                int cleanedCount = 0;
                Iterator<Task> iterator = this.tasks.iterator();
                while (iterator.hasNext()) {
                    Task task = iterator.next();
                    if (task.isCompleted()) {
                        iterator.remove();
                        ++cleanedCount;
                        continue;
                    }
                    Duration elapsed = task.elapsedTime(now);
                    if (elapsed.compareTo(warningTimeout) <= 0) continue;
                    LOGGER.debug("Warning: task {} has been running for {} second(s)", (Object)task.description, (Object)elapsed.getSeconds());
                }
                LOGGER.debug("{} completed task(s) cleaned", (Object)cleanedCount);
            }
            catch (Exception e) {
                LOGGER.debug("Error during background scheduled task check", (Object)e.getMessage());
            }
        }, period.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void task(Runnable command, Future<?> future) {
        this.task(command.toString(), future);
    }

    private void task(Callable<?> callable, Future<?> future) {
        this.task(callable.toString(), future);
    }

    private void task(String description, Future<?> future) {
        this.tasks.add(new Task(description, future));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.delegate.schedule(command, delay, unit);
        this.task(command, future);
        return future;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledFuture<V> future = this.delegate.schedule(callable, delay, unit);
        this.task(callable, future);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        LOGGER.debug("Registering scheduled at fixed rate task '{}'", (Object)command.toString());
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        LOGGER.debug("Registering scheduled with fixed delay task '%s'", (Object)command.toString());
        return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.scheduler.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.scheduler.shutdownNow();
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Future<T> future = this.delegate.submit(task);
        this.task(task, future);
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Future<T> future = this.delegate.submit(task, result);
        this.task(task, future);
        return future;
    }

    @Override
    public Future<?> submit(Runnable task) {
        Future<?> future = this.delegate.submit(task);
        this.task(task, future);
        return future;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable<T>> taskList = new ArrayList<Callable<T>>(tasks);
        List futures = this.delegate.invokeAll(taskList);
        for (int i = 0; i < taskList.size(); ++i) {
            this.task((Callable)taskList.get(i), futures.get(i));
        }
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable<T>> taskList = new ArrayList<Callable<T>>(tasks);
        List futures = this.delegate.invokeAll(taskList, timeout, unit);
        for (int i = 0; i < taskList.size(); ++i) {
            this.task((Callable)taskList.get(i), futures.get(i));
        }
        return futures;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable command) {
        Callable<Void> callable = () -> {
            command.run();
            return null;
        };
        Future<Void> future = this.delegate.submit(callable);
        this.task(command, future);
    }

    static class Task {
        private final Future<?> future;
        private final String description;
        private final long start;

        Task(String description, Future<?> future) {
            this.description = description;
            this.future = future;
            this.start = System.nanoTime();
        }

        boolean isCompleted() {
            return this.future.isDone();
        }

        Duration elapsedTime(long now) {
            if (now - this.start < 0L) {
                return Duration.ZERO;
            }
            return Duration.ofNanos(now - this.start);
        }
    }
}

