/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import com.rabbitmq.stream.Environment;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MonitoringContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringContext.class);
    private final int monitoringPort;
    private final CompositeMeterRegistry meterRegistry;
    private final Environment environment;
    private final Collection<Endpoint> endpoints = Collections.synchronizedList(new ArrayList());
    private volatile HttpServer server;

    MonitoringContext(int monitoringPort, CompositeMeterRegistry meterRegistry, Environment environment) {
        this.monitoringPort = monitoringPort;
        this.meterRegistry = meterRegistry;
        this.environment = environment;
    }

    void addHttpEndpoint(String path, String description, HttpHandler handler) {
        this.endpoints.add(new Endpoint(path, description, handler));
    }

    void start() throws Exception {
        if (!this.endpoints.isEmpty()) {
            this.server = HttpServer.create(new InetSocketAddress(this.monitoringPort), 0);
            for (Endpoint handler : this.endpoints) {
                this.server.createContext(handler.path, handler.handler);
            }
            String hostname = MonitoringContext.hostname();
            StringBuilder builder = new StringBuilder("{ \"name\" : \"StreamPerfTest Monitoring Endpoints\", \"endpoints\" : [");
            String endpointJson = this.endpoints.stream().map(endpoint -> "{\"name\" : \"" + ((Endpoint)endpoint).description + "\", \"href\" : \"" + this.url(hostname, ((Endpoint)endpoint).path) + "\"}").collect(Collectors.joining(","));
            builder.append(endpointJson);
            builder.append("]}");
            this.server.createContext("/", exchange -> {
                exchange.getResponseHeaders().set("Content-Type", "application/json");
                byte[] content = builder.toString().getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(200, content.length);
                try (OutputStream out = exchange.getResponseBody();){
                    out.write(content);
                }
            });
            this.server.start();
            System.out.println("Monitoring endpoints started on http://localhost:" + this.monitoringPort);
        }
    }

    private String url(String hostname, String endpoint) {
        return String.format("http://%s:%d%s", hostname, this.monitoringPort, endpoint);
    }

    private static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    void close() {
        if (this.server != null) {
            LOGGER.debug("Closing HTTP server");
            long start = System.currentTimeMillis();
            this.server.stop(0);
            LOGGER.debug("Closed HTTP server in {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    CompositeMeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    Environment environment() {
        return this.environment;
    }

    private static class Endpoint {
        private final String path;
        private final String description;
        private final HttpHandler handler;

        private Endpoint(String path, String description, HttpHandler handler) {
            this.path = path.startsWith("/") ? path : "/" + path;
            this.description = description;
            this.handler = handler;
        }
    }
}

