/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.AddressResolver;
import com.rabbitmq.stream.BackOffDelayPolicy;
import com.rabbitmq.stream.ChannelCustomizer;
import com.rabbitmq.stream.ChunkChecksum;
import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Environment;
import com.rabbitmq.stream.EnvironmentBuilder;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.compression.CompressionCodecFactory;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.CompressionCodecs;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.Utils;
import com.rabbitmq.stream.metrics.MetricsCollector;
import com.rabbitmq.stream.sasl.CredentialsProvider;
import com.rabbitmq.stream.sasl.SaslConfiguration;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEnvironmentBuilder
implements EnvironmentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamEnvironmentBuilder.class);
    private String id = "rabbitmq-stream";
    private final Client.ClientParameters clientParameters = new Client.ClientParameters();
    private final DefaultTlsConfiguration tls = new DefaultTlsConfiguration(this);
    private ScheduledExecutorService scheduledExecutorService;
    private List<URI> uris = Collections.emptyList();
    private BackOffDelayPolicy recoveryBackOffDelayPolicy = BackOffDelayPolicy.fixed(Duration.ofSeconds(5L));
    private BackOffDelayPolicy topologyBackOffDelayPolicy = BackOffDelayPolicy.fixedWithInitialDelay(Duration.ofSeconds(5L), Duration.ofSeconds(1L));
    private AddressResolver addressResolver = address -> address;
    private int maxProducersByConnection = 256;
    private int maxTrackingConsumersByConnection = 50;
    private int maxConsumersByConnection = 256;
    private CompressionCodecFactory compressionCodecFactory;
    private ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
    private boolean lazyInit = false;
    private Function<Utils.ClientConnectionType, String> connectionNamingStrategy;

    private static URI toUri(String uriString) {
        try {
            URI uri = new URI(uriString);
            if (!"rabbitmq-stream".equalsIgnoreCase(uri.getScheme()) && !"rabbitmq-stream+tls".equalsIgnoreCase(uri.getScheme())) {
                throw new IllegalArgumentException("Wrong scheme in rabbitmq-stream URI: " + uri.getScheme() + ". Should be rabbitmq-stream or rabbitmq-stream+tls");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + uriString, e);
        }
    }

    @Override
    public StreamEnvironmentBuilder uri(String uriString) {
        URI uri = StreamEnvironmentBuilder.toUri(uriString);
        this.uris = Collections.singletonList(uri);
        if (uri.getScheme().toLowerCase().endsWith("+tls")) {
            this.tls.enable();
        }
        return this;
    }

    @Override
    public StreamEnvironmentBuilder uris(List<String> uris) {
        if (uris == null) {
            throw new IllegalArgumentException("URIs parameter cannot be null");
        }
        this.uris = uris.stream().map(StreamEnvironmentBuilder::toUri).collect(Collectors.toList());
        boolean tls = this.uris.stream().anyMatch(uri -> uri.getScheme().toLowerCase().endsWith("+tls"));
        if (tls) {
            this.tls.enable();
        }
        return this;
    }

    @Override
    public StreamEnvironmentBuilder host(String host) {
        this.clientParameters.host(host);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder port(int port) {
        this.clientParameters.port(port);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder codec(Codec codec) {
        this.clientParameters.codec(codec);
        return this;
    }

    @Override
    public EnvironmentBuilder compressionCodecFactory(CompressionCodecFactory compressionCodecFactory) {
        this.compressionCodecFactory = compressionCodecFactory;
        return this;
    }

    @Override
    public EnvironmentBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.clientParameters.eventLoopGroup(eventLoopGroup);
        return this;
    }

    @Override
    public EnvironmentBuilder id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public EnvironmentBuilder byteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
        this.clientParameters.byteBufAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public EnvironmentBuilder rpcTimeout(Duration timeout) {
        this.clientParameters.rpcTimeout(timeout);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder saslConfiguration(SaslConfiguration saslConfiguration) {
        this.clientParameters.saslConfiguration(saslConfiguration);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.clientParameters.credentialsProvider(credentialsProvider);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder username(String username) {
        this.clientParameters.username(username);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder password(String password) {
        this.clientParameters.password(password);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder virtualHost(String virtualHost) {
        this.clientParameters.virtualHost(virtualHost);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder requestedHeartbeat(Duration requestedHeartbeat) {
        this.clientParameters.requestedHeartbeat(requestedHeartbeat);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder requestedMaxFrameSize(int requestedMaxFrameSize) {
        this.clientParameters.requestedMaxFrameSize(requestedMaxFrameSize);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder channelCustomizer(ChannelCustomizer channelCustomizer) {
        this.clientParameters.channelCustomizer(channelCustomizer);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder chunkChecksum(ChunkChecksum chunkChecksum) {
        this.clientParameters.chunkChecksum(chunkChecksum);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder clientProperties(Map<String, String> clientProperties) {
        this.clientParameters.clientProperties(clientProperties);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder clientProperty(String key, String value) {
        this.clientParameters.clientProperty(key, value);
        return this;
    }

    @Override
    public StreamEnvironmentBuilder metricsCollector(MetricsCollector metricsCollector) {
        this.clientParameters.metricsCollector(metricsCollector);
        return this;
    }

    @Override
    public EnvironmentBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    @Override
    public EnvironmentBuilder recoveryBackOffDelayPolicy(BackOffDelayPolicy recoveryBackOffDelayPolicy) {
        this.recoveryBackOffDelayPolicy = recoveryBackOffDelayPolicy;
        return this;
    }

    @Override
    public EnvironmentBuilder topologyUpdateBackOffDelayPolicy(BackOffDelayPolicy topologyUpdateBackOffDelayPolicy) {
        this.topologyBackOffDelayPolicy = topologyUpdateBackOffDelayPolicy;
        return this;
    }

    @Override
    public EnvironmentBuilder addressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
        return this;
    }

    @Override
    public EnvironmentBuilder maxProducersByConnection(int maxProducersByConnection) {
        if (maxProducersByConnection < 1 || maxProducersByConnection > 256) {
            throw new IllegalArgumentException("maxProducersByConnection must be between 1 and 256");
        }
        this.maxProducersByConnection = maxProducersByConnection;
        return this;
    }

    @Override
    public EnvironmentBuilder maxTrackingConsumersByConnection(int maxTrackingConsumersByConnection) {
        if (maxTrackingConsumersByConnection < 1 || maxTrackingConsumersByConnection > 50) {
            throw new IllegalArgumentException("maxTrackingConsumersByConnection must be between 1 and 50");
        }
        this.maxTrackingConsumersByConnection = maxTrackingConsumersByConnection;
        return this;
    }

    @Override
    public EnvironmentBuilder maxConsumersByConnection(int maxConsumersByConnection) {
        if (maxConsumersByConnection < 1 || maxConsumersByConnection > 256) {
            throw new IllegalArgumentException("maxConsumersByConnection must be between 1 and 256");
        }
        this.maxConsumersByConnection = maxConsumersByConnection;
        return this;
    }

    @Override
    public EnvironmentBuilder lazyInitialization(boolean lazy) {
        this.lazyInit = lazy;
        return this;
    }

    @Override
    public EnvironmentBuilder.TlsConfiguration tls() {
        this.tls.enable();
        return this.tls;
    }

    @Override
    public Environment build() {
        if (this.compressionCodecFactory == null) {
            this.clientParameters.compressionCodecFactory(CompressionCodecs.DEFAULT);
        } else {
            this.clientParameters.compressionCodecFactory(this.compressionCodecFactory);
        }
        this.id = this.id == null ? "rabbitmq-stream" : this.id;
        this.connectionNamingStrategy = Utils.defaultConnectionNamingStrategy(this.id + "-");
        return new StreamEnvironment(this.scheduledExecutorService, this.clientParameters, this.uris, this.recoveryBackOffDelayPolicy, this.topologyBackOffDelayPolicy, this.addressResolver, this.maxProducersByConnection, this.maxTrackingConsumersByConnection, this.maxConsumersByConnection, this.tls, this.byteBufAllocator, this.lazyInit, this.connectionNamingStrategy);
    }

    static final class DefaultTlsConfiguration
    implements EnvironmentBuilder.TlsConfiguration {
        private final EnvironmentBuilder environmentBuilder;
        private boolean enabled = false;
        private boolean hostnameVerification = true;
        private SslContext sslContext;

        private DefaultTlsConfiguration(EnvironmentBuilder environmentBuilder) {
            this.environmentBuilder = environmentBuilder;
        }

        @Override
        public EnvironmentBuilder.TlsConfiguration hostnameVerification() {
            this.hostnameVerification = true;
            return this;
        }

        @Override
        public EnvironmentBuilder.TlsConfiguration hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        @Override
        public EnvironmentBuilder.TlsConfiguration sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Override
        public EnvironmentBuilder.TlsConfiguration trustEverything() {
            LOGGER.warn("SECURITY ALERT: this feature trusts every server certificate, effectively disabling peer verification. This is convenient for local development but offers no protection against man-in-the-middle attacks. Please see https://www.rabbitmq.com/ssl.html to learn more about peer certificate verification.");
            try {
                this.sslContext(SslContextBuilder.forClient().trustManager((TrustManager)Utils.TRUST_EVERYTHING_TRUST_MANAGER).build());
            }
            catch (SSLException e) {
                throw new StreamException("Error while creating Netty SSL context", e);
            }
            return this;
        }

        @Override
        public EnvironmentBuilder environmentBuilder() {
            return this.environmentBuilder;
        }

        void enable() {
            this.enabled = true;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean hostnameVerificationEnabled() {
            return this.hostnameVerification;
        }

        public SslContext sslContext() {
            return this.sslContext;
        }
    }
}

