/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Address;
import com.rabbitmq.stream.Constants;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.StreamEnvironment;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Utils {
    static final LongConsumer NO_OP_LONG_CONSUMER = someLong -> {};
    static final X509TrustManager TRUST_EVERYTHING_TRUST_MANAGER = new TrustEverythingTrustManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Map<Short, String> CONSTANT_LABELS;

    private Utils() {
    }

    static Runnable makeIdempotent(Runnable action) {
        AtomicBoolean executed = new AtomicBoolean(false);
        return () -> {
            if (executed.compareAndSet(false, true)) {
                action.run();
            }
        };
    }

    static <T> Consumer<T> makeIdempotent(Consumer<T> action) {
        AtomicBoolean executed = new AtomicBoolean(false);
        return t -> {
            if (executed.compareAndSet(false, true)) {
                action.accept(t);
            }
        };
    }

    static String formatConstant(short value) {
        return value + " (" + CONSTANT_LABELS.getOrDefault(value, "UNKNOWN") + ")";
    }

    static short encodeRequestCode(Short code) {
        return code;
    }

    static short extractResponseCode(Short code) {
        return (short)(code & Short.MAX_VALUE);
    }

    static short encodeResponseCode(Short code) {
        return (short)(code | 0x8000);
    }

    static ClientFactory coordinatorClientFactory(StreamEnvironment environment) {
        return context -> {
            Client.ClientParameters parametersCopy = context.parameters().duplicate();
            Address address = new Address(parametersCopy.host, parametersCopy.port);
            address = environment.addressResolver().resolve(address);
            parametersCopy.host(address.host()).port(address.port());
            if (context.key() == null) {
                throw new IllegalArgumentException("A key is necessary to create the client connection");
            }
            return Utils.connectToAdvertisedNodeClientFactory(context.key(), context1 -> new Client(context1.parameters())).client(ClientFactoryContext.fromParameters(parametersCopy).key(context.key()));
        };
    }

    static ClientFactory connectToAdvertisedNodeClientFactory(String expectedAdvertisedHostPort, ClientFactory clientFactory) {
        return Utils.connectToAdvertisedNodeClientFactory(expectedAdvertisedHostPort, clientFactory, ExactNodeRetryClientFactory.RETRY_INTERVAL);
    }

    static ClientFactory connectToAdvertisedNodeClientFactory(String expectedAdvertisedHostPort, ClientFactory clientFactory, Duration retryInterval) {
        return new ExactNodeRetryClientFactory(clientFactory, client -> {
            String currentKey = client.serverAdvertisedHost() + ":" + client.serverAdvertisedPort();
            boolean success = expectedAdvertisedHostPort.equals(currentKey);
            LOGGER.debug("Expected client {}, got {}: {}", new Object[]{expectedAdvertisedHostPort, currentKey, success ? "success" : "failure"});
            return success;
        }, retryInterval);
    }

    static Function<ClientConnectionType, String> defaultConnectionNamingStrategy() {
        ConcurrentHashMap<ClientConnectionType, AtomicLong> sequences = new ConcurrentHashMap<ClientConnectionType, AtomicLong>(ClientConnectionType.values().length);
        ConcurrentHashMap<ClientConnectionType, String> prefixes = new ConcurrentHashMap<ClientConnectionType, String>(ClientConnectionType.values().length);
        for (ClientConnectionType type : ClientConnectionType.values()) {
            sequences.put(type, new AtomicLong(0L));
            prefixes.put(type, "rabbitmq-stream-" + type.name().toLowerCase(Locale.ENGLISH) + "-");
        }
        return clientConnectionType -> (String)prefixes.get(clientConnectionType) + ((AtomicLong)sequences.get(clientConnectionType)).getAndIncrement();
    }

    static {
        HashMap labels = new HashMap();
        Arrays.stream(Constants.class.getDeclaredFields()).filter(f -> f.getName().startsWith("RESPONSE_CODE_") || f.getName().startsWith("CODE_")).forEach(field -> {
            try {
                labels.put(field.getShort(null), field.getName().replace("RESPONSE_CODE_", "").replace("CODE_", ""));
            }
            catch (IllegalAccessException e) {
                LOGGER.info("Error while trying to access field Constants." + field.getName());
            }
        });
        CONSTANT_LABELS = Collections.unmodifiableMap(labels);
    }

    static enum ClientConnectionType {
        CONSUMER,
        PRODUCER,
        LOCATOR;

    }

    private static class TrustEverythingTrustManager
    implements X509TrustManager {
        private TrustEverythingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    static class ClientFactoryContext {
        private Client.ClientParameters parameters;
        private String key;

        ClientFactoryContext() {
        }

        static ClientFactoryContext fromParameters(Client.ClientParameters parameters) {
            return new ClientFactoryContext().parameters(parameters);
        }

        Client.ClientParameters parameters() {
            return this.parameters;
        }

        ClientFactoryContext parameters(Client.ClientParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        String key() {
            return this.key;
        }

        ClientFactoryContext key(String key) {
            this.key = key;
            return this;
        }
    }

    static class ExactNodeRetryClientFactory
    implements ClientFactory {
        private static final Duration RETRY_INTERVAL = Duration.ofSeconds(1L);
        private final ClientFactory delegate;
        private final Predicate<Client> condition;
        private final Duration retryInterval;

        ExactNodeRetryClientFactory(ClientFactory delegate, Predicate<Client> condition, Duration retryInterval) {
            this.delegate = delegate;
            this.condition = condition;
            this.retryInterval = retryInterval;
        }

        @Override
        public Client client(ClientFactoryContext context) {
            Client client;
            while (!this.condition.test(client = this.delegate.client(context))) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error while trying to close client", (Throwable)e);
                }
                try {
                    Thread.sleep(this.retryInterval.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    return null;
                }
            }
            return client;
        }
    }

    static interface ClientFactory {
        public Client client(ClientFactoryContext var1);
    }
}

