/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

class MonitoringContext {
    private final int monitoringPort;
    private final CompositeMeterRegistry meterRegistry;
    private final Map<String, Handler> handlers = new LinkedHashMap<String, Handler>();
    private volatile Server server;

    MonitoringContext(int monitoringPort, CompositeMeterRegistry meterRegistry) {
        this.monitoringPort = monitoringPort;
        this.meterRegistry = meterRegistry;
    }

    void addHttpEndpoint(String path, Handler handler) {
        this.handlers.put(path, handler);
    }

    void start() throws Exception {
        if (!this.handlers.isEmpty()) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setMinThreads(2);
            threadPool.setMaxThreads(12);
            this.server = new Server((ThreadPool)threadPool);
            ServerConnector connector = new ServerConnector(this.server);
            connector.setPort(this.monitoringPort);
            this.server.setConnectors(new Connector[]{connector});
            ArrayList<ContextHandler> contextHandlers = new ArrayList<ContextHandler>(this.handlers.size());
            for (Map.Entry<String, Handler> entry : this.handlers.entrySet()) {
                String path = entry.getKey().startsWith("/") ? entry.getKey() : "/" + entry.getKey();
                Handler handler = entry.getValue();
                ContextHandler contextHandler = new ContextHandler();
                contextHandler.setContextPath(path);
                contextHandler.setHandler(handler);
                contextHandlers.add(contextHandler);
            }
            ContextHandlerCollection contextHandler = new ContextHandlerCollection(contextHandlers.toArray(new ContextHandler[0]));
            this.server.setHandler((Handler)contextHandler);
            this.server.setStopTimeout(1000L);
            this.server.start();
        }
    }

    void close() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    CompositeMeterRegistry meterRegistry() {
        return this.meterRegistry;
    }
}

