/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.metrics;

import com.rabbitmq.stream.metrics.MetricsCollector;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class MicrometerMetricsCollector
implements MetricsCollector {
    private final AtomicLong connections;
    private final Counter publish;
    private final Counter publishConfirm;
    private final Counter publishError;
    private final Counter chunk;
    private final Counter consume;
    private final Counter writtenBytes;
    private final Counter readBytes;
    private final AtomicLong outstandingPublishConfirm;
    private final DistributionSummary chunkSize;

    public MicrometerMetricsCollector(MeterRegistry registry) {
        this(registry, "rabbitmq.stream");
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix) {
        this(registry, prefix, Collections.emptyList());
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix, String ... tags) {
        this(registry, prefix, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
        this.connections = (AtomicLong)registry.gauge(prefix + ".connections", tags, (Number)new AtomicLong(0L));
        this.publish = registry.counter(prefix + ".published", tags);
        this.publishConfirm = registry.counter(prefix + ".confirmed", tags);
        this.publishError = registry.counter(prefix + ".errored", tags);
        this.chunk = registry.counter(prefix + ".chunk", tags);
        this.chunkSize = registry.summary(prefix + ".chunk_size", tags);
        this.consume = registry.counter(prefix + ".consumed", tags);
        this.writtenBytes = registry.counter(prefix + ".written_bytes", tags);
        this.readBytes = registry.counter(prefix + ".read_bytes", tags);
        this.outstandingPublishConfirm = (AtomicLong)registry.gauge(prefix + ".outstanding_publish_confirm", tags, (Number)new AtomicLong(0L));
    }

    @Override
    public void openConnection() {
        this.connections.incrementAndGet();
    }

    @Override
    public void closeConnection() {
        this.connections.decrementAndGet();
    }

    @Override
    public void publish(int count) {
        this.publish.increment((double)count);
        this.outstandingPublishConfirm.addAndGet(count);
    }

    @Override
    public void publishConfirm(int count) {
        this.publishConfirm.increment((double)count);
        this.outstandingPublishConfirm.addAndGet(-count);
    }

    @Override
    public void publishError(int count) {
        this.publishError.increment((double)count);
        this.outstandingPublishConfirm.addAndGet(-count);
    }

    @Override
    public void chunk(int entriesCount) {
        this.chunk.increment();
        this.chunkSize.record((double)entriesCount);
    }

    @Override
    public void consume(long count) {
        this.consume.increment((double)count);
    }

    @Override
    public void writtenBytes(int writtenBytes) {
        this.writtenBytes.increment((double)writtenBytes);
    }

    @Override
    public void readBytes(int readBytes) {
        this.readBytes.increment((double)readBytes);
    }
}

