/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.codec;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.Properties;
import com.rabbitmq.stream.amqp.UnsignedShort;
import com.rabbitmq.stream.codec.QpidProtonMessageBuilder;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;

public class QpidProtonCodec
implements Codec {
    private static final Function<String, String> MESSAGE_ANNOTATIONS_STRING_KEY_EXTRACTOR = k -> k;
    private static final Function<Symbol, String> MESSAGE_ANNOTATIONS_SYMBOL_KEY_EXTRACTOR = Symbol::toString;

    private static Map<String, Object> createApplicationProperties(org.apache.qpid.proton.message.Message message) {
        if (message.getApplicationProperties() != null) {
            return QpidProtonCodec.createMapFromAmqpMap(MESSAGE_ANNOTATIONS_STRING_KEY_EXTRACTOR, message.getApplicationProperties().getValue());
        }
        return null;
    }

    private static Map<String, Object> createMessageAnnotations(org.apache.qpid.proton.message.Message message) {
        if (message.getMessageAnnotations() != null) {
            return QpidProtonCodec.createMapFromAmqpMap(MESSAGE_ANNOTATIONS_SYMBOL_KEY_EXTRACTOR, message.getMessageAnnotations().getValue());
        }
        return null;
    }

    private static <K> Map<String, Object> createMapFromAmqpMap(Function<K, String> keyMaker, Map<K, Object> amqpMap) {
        LinkedHashMap<String, Object> result;
        if (amqpMap != null) {
            result = new LinkedHashMap<String, Object>(amqpMap.size());
            for (Map.Entry<K, Object> entry : amqpMap.entrySet()) {
                result.put(keyMaker.apply(entry.getKey()), QpidProtonCodec.convertApplicationProperty(entry.getValue()));
            }
        } else {
            result = null;
        }
        return result;
    }

    private static Object convertApplicationProperty(Object value) {
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Character || value instanceof UUID) {
            return value;
        }
        if (value instanceof Binary) {
            return ((Binary)value).getArray();
        }
        if (value instanceof UnsignedByte) {
            return com.rabbitmq.stream.amqp.UnsignedByte.valueOf(((UnsignedByte)value).byteValue());
        }
        if (value instanceof org.apache.qpid.proton.amqp.UnsignedShort) {
            return UnsignedShort.valueOf(((org.apache.qpid.proton.amqp.UnsignedShort)value).shortValue());
        }
        if (value instanceof UnsignedInteger) {
            return com.rabbitmq.stream.amqp.UnsignedInteger.valueOf(((UnsignedInteger)value).intValue());
        }
        if (value instanceof UnsignedLong) {
            return com.rabbitmq.stream.amqp.UnsignedLong.valueOf(((UnsignedLong)value).longValue());
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Symbol) {
            return ((Symbol)value).toString();
        }
        throw new IllegalArgumentException("Type not supported for an application property: " + value.getClass());
    }

    @Override
    public Codec.EncodedMessage encode(Message message) {
        org.apache.qpid.proton.message.Message qpidMessage;
        if (message instanceof QpidProtonAmqpMessageWrapper) {
            qpidMessage = ((QpidProtonAmqpMessageWrapper)message).message;
        } else {
            qpidMessage = Message.Factory.create();
            if (message.getProperties() != null) {
                boolean bl;
                Properties headers = message.getProperties();
                org.apache.qpid.proton.amqp.messaging.Properties properties = new org.apache.qpid.proton.amqp.messaging.Properties();
                boolean bl2 = false;
                if (headers.getMessageId() != null) {
                    if (headers.getMessageId() instanceof String) {
                        properties.setMessageId((Object)headers.getMessageIdAsString());
                    } else if (headers.getMessageId().getClass().isPrimitive() || headers.getMessageId() instanceof Long) {
                        properties.setMessageId((Object)new UnsignedLong(headers.getMessageIdAsLong()));
                    } else if (headers.getMessageId().getClass().isArray()) {
                        properties.setMessageId((Object)new Binary(headers.getMessageIdAsBinary()));
                    } else if (headers.getMessageId() instanceof UUID) {
                        properties.setMessageId((Object)headers.getMessageIdAsUuid());
                    } else {
                        throw new IllegalStateException("Type not supported for message ID:" + properties.getMessageId().getClass());
                    }
                    boolean bl3 = true;
                }
                if (headers.getUserId() != null) {
                    properties.setUserId(new Binary(headers.getUserId()));
                    boolean bl4 = true;
                }
                if (headers.getTo() != null) {
                    properties.setTo(headers.getTo());
                    boolean bl5 = true;
                }
                if (headers.getSubject() != null) {
                    properties.setSubject(headers.getSubject());
                    boolean bl6 = true;
                }
                if (headers.getReplyTo() != null) {
                    properties.setReplyTo(headers.getReplyTo());
                    boolean bl7 = true;
                }
                if (headers.getCorrelationId() != null) {
                    if (headers.getCorrelationId() instanceof String) {
                        properties.setCorrelationId((Object)headers.getCorrelationIdAsString());
                    } else if (headers.getCorrelationId().getClass().isPrimitive() || headers.getCorrelationId() instanceof Long) {
                        properties.setCorrelationId((Object)new UnsignedLong(headers.getCorrelationIdAsLong()));
                    } else if (headers.getCorrelationId().getClass().isArray()) {
                        properties.setCorrelationId((Object)new Binary(headers.getCorrelationIdAsBinary()));
                    } else if (headers.getCorrelationId() instanceof UUID) {
                        properties.setCorrelationId((Object)headers.getCorrelationIdAsUuid());
                    } else {
                        throw new IllegalStateException("Type not supported for correlation ID:" + properties.getCorrelationId().getClass());
                    }
                    boolean bl8 = true;
                }
                if (headers.getContentType() != null) {
                    properties.setContentType(Symbol.getSymbol((String)headers.getContentType()));
                    boolean bl9 = true;
                }
                if (headers.getContentEncoding() != null) {
                    properties.setContentEncoding(Symbol.getSymbol((String)headers.getContentEncoding()));
                    boolean bl10 = true;
                }
                if (headers.getAbsoluteExpiryTime() > 0L) {
                    properties.setAbsoluteExpiryTime(new Date(headers.getAbsoluteExpiryTime()));
                    boolean bl11 = true;
                }
                if (headers.getCreationTime() > 0L) {
                    properties.setCreationTime(new Date(headers.getCreationTime()));
                    boolean bl12 = true;
                }
                if (headers.getGroupId() != null) {
                    properties.setGroupId(headers.getGroupId());
                    boolean bl13 = true;
                }
                if (headers.getGroupSequence() >= 0L) {
                    properties.setGroupSequence(UnsignedInteger.valueOf((long)headers.getGroupSequence()));
                    boolean bl14 = true;
                }
                if (headers.getReplyToGroupId() != null) {
                    properties.setReplyToGroupId(headers.getReplyToGroupId());
                    bl = true;
                }
                if (bl) {
                    qpidMessage.setProperties(properties);
                }
            }
            if (message.getApplicationProperties() != null && !message.getApplicationProperties().isEmpty()) {
                LinkedHashMap applicationProperties = new LinkedHashMap(message.getApplicationProperties().size());
                for (Map.Entry entry : message.getApplicationProperties().entrySet()) {
                    applicationProperties.put(entry.getKey(), this.convertToQpidType(entry.getValue()));
                }
                qpidMessage.setApplicationProperties(new ApplicationProperties(applicationProperties));
            }
            if (message.getMessageAnnotations() != null && !message.getMessageAnnotations().isEmpty()) {
                LinkedHashMap<Symbol, Object> messageAnnotations = new LinkedHashMap<Symbol, Object>(message.getMessageAnnotations().size());
                for (Map.Entry entry : message.getMessageAnnotations().entrySet()) {
                    messageAnnotations.put(Symbol.getSymbol((String)((String)entry.getKey())), this.convertToQpidType(entry.getValue()));
                }
                qpidMessage.setMessageAnnotations(new MessageAnnotations(messageAnnotations));
            }
            if (message.getBodyAsBinary() != null) {
                qpidMessage.setBody((Section)new Data(new Binary(message.getBodyAsBinary())));
            }
        }
        int bufferSize = qpidMessage.getBody() instanceof Data ? ((Data)qpidMessage.getBody()).getValue().getLength() * 2 : 8192;
        ByteArrayWritableBuffer writableBuffer = new ByteArrayWritableBuffer(bufferSize);
        qpidMessage.encode((WritableBuffer)writableBuffer);
        return new Codec.EncodedMessage(writableBuffer.getArrayLength(), writableBuffer.getArray());
    }

    @Override
    public Message decode(byte[] data) {
        org.apache.qpid.proton.message.Message message = Message.Factory.create();
        message.decode(data, 0, data.length);
        return new QpidProtonMessage(message, this.createProperties(message), QpidProtonCodec.createApplicationProperties(message), QpidProtonCodec.createMessageAnnotations(message));
    }

    protected Properties createProperties(org.apache.qpid.proton.message.Message message) {
        if (message.getProperties() != null) {
            return new QpidProtonProperties(message.getProperties());
        }
        return null;
    }

    protected Object convertToQpidType(Object value) {
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Character || value instanceof UUID || value instanceof Date) {
            return value;
        }
        if (value instanceof com.rabbitmq.stream.amqp.UnsignedByte) {
            return UnsignedByte.valueOf((byte)((com.rabbitmq.stream.amqp.UnsignedByte)value).byteValue());
        }
        if (value instanceof UnsignedShort) {
            return org.apache.qpid.proton.amqp.UnsignedShort.valueOf((short)((UnsignedShort)value).shortValue());
        }
        if (value instanceof com.rabbitmq.stream.amqp.UnsignedInteger) {
            return UnsignedInteger.valueOf((int)((com.rabbitmq.stream.amqp.UnsignedInteger)value).intValue());
        }
        if (value instanceof com.rabbitmq.stream.amqp.UnsignedLong) {
            return UnsignedLong.valueOf((long)((com.rabbitmq.stream.amqp.UnsignedLong)value).longValue());
        }
        if (value instanceof com.rabbitmq.stream.amqp.Symbol) {
            return Symbol.getSymbol((String)value.toString());
        }
        if (value instanceof byte[]) {
            return new Binary((byte[])value);
        }
        throw new IllegalArgumentException("Type not supported for an application property: " + value.getClass());
    }

    @Override
    public MessageBuilder messageBuilder() {
        return new QpidProtonMessageBuilder();
    }

    private class ByteArrayWritableBuffer
    implements WritableBuffer {
        public static final int DEFAULT_CAPACITY = 4096;
        byte[] buffer;
        int position;

        public ByteArrayWritableBuffer() {
            this(4096);
        }

        public ByteArrayWritableBuffer(int capacity) {
            this.buffer = new byte[capacity];
        }

        public byte[] getArray() {
            return this.buffer;
        }

        public int getArrayLength() {
            return this.position;
        }

        public void put(byte b) {
            int newPosition = this.position + 1;
            this.ensureCapacity(newPosition);
            this.buffer[this.position] = b;
            this.position = newPosition;
        }

        public void putShort(short value) {
            this.ensureCapacity(this.position + 2);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)(value >>> 0);
        }

        public void putInt(int value) {
            this.ensureCapacity(this.position + 4);
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)(value >>> 0);
        }

        public void putLong(long value) {
            this.ensureCapacity(this.position + 8);
            this.buffer[this.position++] = (byte)(value >>> 56);
            this.buffer[this.position++] = (byte)(value >>> 48);
            this.buffer[this.position++] = (byte)(value >>> 40);
            this.buffer[this.position++] = (byte)(value >>> 32);
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)(value >>> 0);
        }

        public void putFloat(float value) {
            this.putInt(Float.floatToRawIntBits(value));
        }

        public void putDouble(double value) {
            this.putLong(Double.doubleToRawLongBits(value));
        }

        public void put(byte[] src, int offset, int length) {
            if (length == 0) {
                return;
            }
            int newPosition = this.position + length;
            this.ensureCapacity(newPosition);
            System.arraycopy(src, offset, this.buffer, this.position, length);
            this.position = newPosition;
        }

        public boolean hasRemaining() {
            return this.position < Integer.MAX_VALUE;
        }

        public int remaining() {
            return Integer.MAX_VALUE - this.position;
        }

        public int position() {
            return this.position;
        }

        public void position(int position) {
            this.ensureCapacity(position);
            this.position = position;
        }

        public void put(ByteBuffer payload) {
            int newPosition = this.position + payload.remaining();
            this.ensureCapacity(newPosition);
            while (payload.hasRemaining()) {
                this.buffer[this.position++] = payload.get();
            }
            this.position = newPosition;
        }

        public int limit() {
            return Integer.MAX_VALUE;
        }

        public void put(ReadableBuffer src) {
            this.ensureCapacity(this.position);
            src.get((WritableBuffer)this);
        }

        private void ensureCapacity(int minimumCapacity) {
            if (minimumCapacity > this.buffer.length) {
                byte[] newBuffer = new byte[Math.max(this.buffer.length << 1, minimumCapacity)];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
                this.buffer = newBuffer;
            }
        }
    }

    static class QpidProtonAmqpMessageWrapper
    implements Message {
        private final boolean hasPublishingId;
        private final long publishingId;
        private final org.apache.qpid.proton.message.Message message;
        private Properties properties;
        private Map<String, Object> applicationProperties;
        private Map<String, Object> messageAnnotations;

        QpidProtonAmqpMessageWrapper(boolean hasPublishingId, long publishingId, org.apache.qpid.proton.message.Message message) {
            this.hasPublishingId = hasPublishingId;
            this.publishingId = publishingId;
            this.message = message;
        }

        @Override
        public boolean hasPublishingId() {
            return this.hasPublishingId;
        }

        @Override
        public long getPublishingId() {
            return this.publishingId;
        }

        @Override
        public byte[] getBodyAsBinary() {
            return this.message.getBody() == null ? null : ((Data)this.message.getBody()).getValue().getArray();
        }

        @Override
        public Object getBody() {
            return this.message.getBody();
        }

        @Override
        public Properties getProperties() {
            if (this.properties != null) {
                return this.properties;
            }
            if (this.message.getProperties() != null) {
                this.properties = new QpidProtonProperties(this.message.getProperties());
                return this.properties;
            }
            return null;
        }

        @Override
        public Map<String, Object> getApplicationProperties() {
            if (this.applicationProperties != null) {
                return this.applicationProperties;
            }
            if (this.message.getApplicationProperties() != null) {
                this.applicationProperties = QpidProtonCodec.createApplicationProperties(this.message);
                return this.applicationProperties;
            }
            return null;
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            if (this.messageAnnotations != null) {
                return this.messageAnnotations;
            }
            if (this.message.getMessageAnnotations() != null) {
                this.messageAnnotations = QpidProtonCodec.createMessageAnnotations(this.message);
                return this.messageAnnotations;
            }
            return null;
        }
    }

    private static class QpidProtonMessage
    implements Message {
        private final org.apache.qpid.proton.message.Message message;
        private final Properties properties;
        private final Map<String, Object> applicationProperties;
        private final Map<String, Object> messageAnnotations;

        private QpidProtonMessage(org.apache.qpid.proton.message.Message message, Properties properties, Map<String, Object> applicationProperties, Map<String, Object> messageAnnotations) {
            this.message = message;
            this.properties = properties;
            this.applicationProperties = applicationProperties;
            this.messageAnnotations = messageAnnotations;
        }

        @Override
        public boolean hasPublishingId() {
            return false;
        }

        @Override
        public long getPublishingId() {
            return 0L;
        }

        @Override
        public byte[] getBodyAsBinary() {
            return this.message.getBody() == null ? null : ((Data)this.message.getBody()).getValue().getArray();
        }

        @Override
        public Object getBody() {
            return this.message.getBody();
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public Map<String, Object> getApplicationProperties() {
            return this.applicationProperties;
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            return this.messageAnnotations;
        }
    }

    private static final class QpidProtonProperties
    implements Properties {
        private static final long NULL_GROUP_SEQUENCE = -1L;
        private static final long NULL_TIMESTAMP = 0L;
        private final org.apache.qpid.proton.amqp.messaging.Properties properties;

        private QpidProtonProperties(org.apache.qpid.proton.amqp.messaging.Properties properties) {
            this.properties = properties;
        }

        @Override
        public Object getMessageId() {
            return this.properties.getMessageId();
        }

        @Override
        public String getMessageIdAsString() {
            return this.properties.getMessageId() == null ? null : this.properties.getMessageId().toString();
        }

        @Override
        public long getMessageIdAsLong() {
            return ((UnsignedLong)this.properties.getMessageId()).longValue();
        }

        @Override
        public byte[] getMessageIdAsBinary() {
            return this.properties.getMessageId() == null ? null : ((Binary)this.properties.getMessageId()).getArray();
        }

        @Override
        public UUID getMessageIdAsUuid() {
            return this.properties.getMessageId() == null ? null : (UUID)this.properties.getMessageId();
        }

        @Override
        public byte[] getUserId() {
            return this.properties.getUserId() == null ? null : this.properties.getUserId().getArray();
        }

        @Override
        public String getTo() {
            return this.properties.getTo();
        }

        @Override
        public String getSubject() {
            return this.properties.getSubject();
        }

        @Override
        public String getReplyTo() {
            return this.properties.getReplyTo();
        }

        @Override
        public Object getCorrelationId() {
            return this.properties.getCorrelationId();
        }

        @Override
        public String getCorrelationIdAsString() {
            return this.properties.getCorrelationId() == null ? null : this.properties.getCorrelationId().toString();
        }

        @Override
        public long getCorrelationIdAsLong() {
            return ((UnsignedLong)this.properties.getCorrelationId()).longValue();
        }

        @Override
        public byte[] getCorrelationIdAsBinary() {
            return this.properties.getCorrelationId() == null ? null : ((Binary)this.properties.getCorrelationId()).getArray();
        }

        @Override
        public UUID getCorrelationIdAsUuid() {
            return this.properties.getCorrelationId() == null ? null : (UUID)this.properties.getCorrelationId();
        }

        @Override
        public String getContentType() {
            return this.properties.getContentType() == null ? null : this.properties.getContentType().toString();
        }

        @Override
        public String getContentEncoding() {
            return this.properties.getContentEncoding() == null ? null : this.properties.getContentEncoding().toString();
        }

        @Override
        public long getAbsoluteExpiryTime() {
            return this.properties.getAbsoluteExpiryTime() == null ? 0L : this.properties.getAbsoluteExpiryTime().getTime();
        }

        @Override
        public long getCreationTime() {
            return this.properties.getCreationTime() == null ? 0L : this.properties.getCreationTime().getTime();
        }

        @Override
        public String getGroupId() {
            return this.properties.getGroupId();
        }

        @Override
        public long getGroupSequence() {
            return this.properties.getGroupSequence() == null ? -1L : this.properties.getGroupSequence().longValue();
        }

        @Override
        public String getReplyToGroupId() {
            return this.properties.getReplyToGroupId();
        }

        public String toString() {
            return "QpidProtonProperties{properties=" + this.properties + '}';
        }
    }
}

