/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import java.time.Duration;

public interface BackOffDelayPolicy {
    public static final Duration TIMEOUT = Duration.ofMillis(Long.MAX_VALUE);

    public static BackOffDelayPolicy fixed(Duration delay) {
        return new FixedWithInitialDelayBackOffPolicy(delay, delay);
    }

    public static BackOffDelayPolicy fixedWithInitialDelay(Duration initialDelay, Duration delay) {
        return new FixedWithInitialDelayBackOffPolicy(initialDelay, delay);
    }

    public static BackOffDelayPolicy fixedWithInitialDelay(Duration initialDelay, Duration delay, Duration timeout) {
        return new FixedWithInitialDelayAndTimeoutBackOffPolicy(initialDelay, delay, timeout);
    }

    public Duration delay(int var1);

    public static class FixedWithInitialDelayAndTimeoutBackOffPolicy
    implements BackOffDelayPolicy {
        private final Duration initialDelay;
        private final Duration delay;
        private final int attemptLimitBeforeTimeout;

        private FixedWithInitialDelayAndTimeoutBackOffPolicy(Duration initialDelay, Duration delay, Duration timeout) {
            if (timeout.toMillis() < initialDelay.toMillis()) {
                throw new IllegalArgumentException("Timeout must be longer than initial delay");
            }
            this.initialDelay = initialDelay;
            this.delay = delay;
            long timeoutWithInitialDelay = timeout.toMillis() - initialDelay.toMillis();
            this.attemptLimitBeforeTimeout = (int)(timeoutWithInitialDelay / delay.toMillis()) + 1;
        }

        @Override
        public Duration delay(int recoveryAttempt) {
            if (recoveryAttempt == 0) {
                return this.initialDelay;
            }
            if (recoveryAttempt >= this.attemptLimitBeforeTimeout) {
                return TIMEOUT;
            }
            return this.delay;
        }
    }

    public static class FixedWithInitialDelayBackOffPolicy
    implements BackOffDelayPolicy {
        private final Duration initialDelay;
        private final Duration delay;

        private FixedWithInitialDelayBackOffPolicy(Duration initialDelay, Duration delay) {
            this.initialDelay = initialDelay;
            this.delay = delay;
        }

        @Override
        public Duration delay(int recoveryAttempt) {
            return recoveryAttempt == 0 ? this.initialDelay : this.delay;
        }
    }
}

