/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.codec;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.Properties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class SimpleCodec
implements Codec {
    static final byte[] EMPTY_BODY = new byte[0];

    @Override
    public Codec.EncodedMessage encode(Message message) {
        byte[] body = message.getBodyAsBinary() == null ? EMPTY_BODY : message.getBodyAsBinary();
        return new Codec.EncodedMessage(body.length, body);
    }

    @Override
    public Message decode(byte[] data) {
        return new SimpleMessage(false, 0L, data);
    }

    @Override
    public MessageBuilder messageBuilder() {
        return new SimpleMessageBuilder();
    }

    private static class SimpleMessageBuilder
    implements MessageBuilder {
        private boolean hasPublishingId = false;
        private long publishingId = 0L;
        private byte[] body;
        private final AtomicBoolean built = new AtomicBoolean(false);

        private SimpleMessageBuilder() {
        }

        @Override
        public Message build() {
            if (this.built.compareAndSet(false, true)) {
                return new SimpleMessage(this.hasPublishingId, this.publishingId, this.body);
            }
            throw new IllegalStateException("A message builder can build only one message");
        }

        @Override
        @SuppressFBWarnings(value={"AT_NONATOMIC_64BIT_PRIMITIVE", "AT_STALE_THREAD_WRITE_OF_PRIMITIVE"})
        public MessageBuilder publishingId(long publishingId) {
            this.publishingId = publishingId;
            this.hasPublishingId = true;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder applicationProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder messageAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder addData(byte[] data) {
            this.body = data;
            return this;
        }
    }

    private static class SimpleMessage
    implements Message {
        private final boolean hasPublishingId;
        private final long publishingId;
        private final byte[] body;

        private SimpleMessage(boolean hasPublishingId, long publishingId, byte[] body) {
            this.hasPublishingId = hasPublishingId;
            this.publishingId = publishingId;
            this.body = body;
        }

        @Override
        public boolean hasPublishingId() {
            return this.hasPublishingId;
        }

        @Override
        public long getPublishingId() {
            return this.publishingId;
        }

        @Override
        public byte[] getBodyAsBinary() {
            return this.body;
        }

        @Override
        public Object getBody() {
            return this.body;
        }

        @Override
        public Properties getProperties() {
            return null;
        }

        @Override
        public Map<String, Object> getApplicationProperties() {
            return null;
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            return null;
        }
    }
}

