/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import java.util.Objects;

public class OffsetSpecification {
    private static final short TYPE_NONE = 0;
    private static final short TYPE_FIRST = 1;
    private static final short TYPE_LAST = 2;
    private static final short TYPE_NEXT = 3;
    private static final short TYPE_OFFSET = 4;
    private static final short TYPE_TIMESTAMP = 5;
    private static final long UNUSED_OFFSET = -1L;
    private static final OffsetSpecification NONE = new OffsetSpecification(0, -1L);
    private static final OffsetSpecification FIRST = new OffsetSpecification(1, -1L);
    private static final OffsetSpecification LAST = new OffsetSpecification(2, -1L);
    private static final OffsetSpecification NEXT = new OffsetSpecification(3, -1L);
    private final short type;
    private final long offset;

    private OffsetSpecification(short type, long offset) {
        this.type = type;
        this.offset = offset;
    }

    public static OffsetSpecification none() {
        return NONE;
    }

    public static OffsetSpecification first() {
        return FIRST;
    }

    public static OffsetSpecification last() {
        return LAST;
    }

    public static OffsetSpecification next() {
        return NEXT;
    }

    public static OffsetSpecification offset(long offset) {
        return new OffsetSpecification(4, offset);
    }

    public static OffsetSpecification timestamp(long timestamp) {
        return new OffsetSpecification(5, timestamp);
    }

    public boolean isOffset() {
        return this.type == 4;
    }

    public boolean isTimestamp() {
        return this.type == 5;
    }

    public short getType() {
        return this.type;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return "OffsetSpecification{type=" + this.type + ", offset=" + this.offset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetSpecification that = (OffsetSpecification)o;
        return this.type == that.type && this.offset == that.offset;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.offset);
    }
}

