/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.http.client.GetAckMode;
import com.rabbitmq.http.client.GetEncoding;
import com.rabbitmq.http.client.HttpClientException;
import com.rabbitmq.http.client.HttpEndpoint;
import com.rabbitmq.http.client.HttpResponse;
import com.rabbitmq.http.client.HttpServerException;
import com.rabbitmq.http.client.JsonUtils;
import com.rabbitmq.http.client.ReactorNettyClientOptions;
import com.rabbitmq.http.client.Utils;
import com.rabbitmq.http.client.domain.AlivenessTestResult;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.ChannelInfo;
import com.rabbitmq.http.client.domain.ClusterId;
import com.rabbitmq.http.client.domain.ConnectionInfo;
import com.rabbitmq.http.client.domain.ConsumerDetails;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.Definitions;
import com.rabbitmq.http.client.domain.DeleteQueueParameters;
import com.rabbitmq.http.client.domain.DetailsParameters;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import com.rabbitmq.http.client.domain.InboundMessage;
import com.rabbitmq.http.client.domain.NodeInfo;
import com.rabbitmq.http.client.domain.OutboundMessage;
import com.rabbitmq.http.client.domain.OverviewResponse;
import com.rabbitmq.http.client.domain.PolicyInfo;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.rabbitmq.http.client.domain.ShovelInfo;
import com.rabbitmq.http.client.domain.ShovelStatus;
import com.rabbitmq.http.client.domain.TopicPermissions;
import com.rabbitmq.http.client.domain.UpstreamDetails;
import com.rabbitmq.http.client.domain.UpstreamInfo;
import com.rabbitmq.http.client.domain.UpstreamSetDetails;
import com.rabbitmq.http.client.domain.UpstreamSetInfo;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.UserPermissions;
import com.rabbitmq.http.client.domain.VhostInfo;
import com.rabbitmq.http.client.domain.VhostLimits;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class ReactorNettyClient {
    private static final Consumer<HttpHeaders> JSON_HEADER = headers -> headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
    private final ObjectMapper objectMapper;
    private final HttpClient client;
    private final Mono<String> token;
    private final Supplier<ByteBuf> byteBufSupplier;
    private final Consumer<HttpClientResponse> responseCallback;

    public ReactorNettyClient(String url, ReactorNettyClientOptions options) {
        this(Utils.urlWithoutCredentials(url), Utils.extractUsernamePassword(url)[0], Utils.extractUsernamePassword(url)[1], options);
    }

    public ReactorNettyClient(String url) {
        this(url, new ReactorNettyClientOptions());
    }

    public ReactorNettyClient(String url, String username, String password) {
        this(url, username, password, new ReactorNettyClientOptions());
    }

    public ReactorNettyClient(String url, String username, String password, ReactorNettyClientOptions options) {
        this.objectMapper = options.objectMapper() == null ? ReactorNettyClient.createDefaultObjectMapper() : options.objectMapper().get();
        this.client = options.client() == null ? HttpClient.create().baseUrl(url) : options.client().get();
        this.token = options.token() == null ? ReactorNettyClient.createBasicAuthenticationToken(username, password) : options.token();
        this.responseCallback = options.onResponseCallback() == null ? response -> {
            if (response.method() == HttpMethod.GET) {
                if (response.status().code() >= 500) {
                    throw new HttpServerException(response.status().code(), response.status().reasonPhrase());
                }
                if (response.status().code() >= 400) {
                    throw new HttpClientException(response.status().code(), response.status().reasonPhrase());
                }
            }
        } : response -> options.onResponseCallback().accept(new HttpEndpoint(response.uri(), response.method().name()), ReactorNettyClient.toHttpResponse(response));
        this.byteBufSupplier = options.byteBufSupplier() == null ? () -> PooledByteBufAllocator.DEFAULT.buffer() : options.byteBufSupplier();
    }

    private static HttpResponse toHttpResponse(HttpClientResponse response) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Map.Entry headerEntry : response.responseHeaders().entries()) {
            headers.put((String)headerEntry.getKey(), (String)headerEntry.getValue());
        }
        return new HttpResponse(response.status().code(), response.status().reasonPhrase(), headers);
    }

    public static ObjectMapper createDefaultObjectMapper() {
        return JsonUtils.createDefaultObjectMapper();
    }

    public static Mono<String> createBasicAuthenticationToken(String username, String password) {
        return Mono.fromSupplier(() -> ReactorNettyClient.basicAuthentication(username, password)).cache();
    }

    public static String basicAuthentication(String username, String password) {
        String credentials = username + ":" + password;
        byte[] credentialsAsBytes = credentials.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodedBytes = Base64.getEncoder().encode(credentialsAsBytes);
        String encodedCredentials = new String(encodedBytes, StandardCharsets.ISO_8859_1);
        return "Basic " + encodedCredentials;
    }

    public Mono<OverviewResponse> getOverview() {
        return this.doGetMono(OverviewResponse.class, "overview");
    }

    public Flux<NodeInfo> getNodes() {
        return this.doGetFlux(NodeInfo.class, "nodes");
    }

    public Mono<NodeInfo> getNode(String name) {
        return this.doGetMono(NodeInfo.class, "nodes", ReactorNettyClient.encodePath(name));
    }

    public Flux<ConnectionInfo> getConnections() {
        return this.doGetFlux(ConnectionInfo.class, "connections");
    }

    public Mono<ConnectionInfo> getConnection(String name) {
        return this.doGetMono(ConnectionInfo.class, "connections", ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> closeConnection(String name) {
        return this.doDelete("connections", ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> closeConnection(String name, String reason) {
        return this.doDelete((? super HttpHeaders headers) -> headers.set("X-Reason", (Object)reason), "connections", ReactorNettyClient.encodePath(name));
    }

    public Flux<ConsumerDetails> getConsumers() {
        return this.doGetFlux(ConsumerDetails.class, "consumers");
    }

    public Flux<ConsumerDetails> getConsumers(String vhost) {
        return this.doGetFlux(ConsumerDetails.class, "consumers", ReactorNettyClient.encodePath(vhost));
    }

    public Mono<HttpResponse> declarePolicy(String vhost, String name, PolicyInfo info) {
        return this.doPut(info, "policies", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> declareOperatorPolicy(String vhost, String name, PolicyInfo info) {
        return this.doPut(info, "operator-policies", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Flux<PolicyInfo> getPolicies() {
        return this.doGetFlux(PolicyInfo.class, "policies");
    }

    public Flux<PolicyInfo> getPolicies(String vhost) {
        return this.doGetFlux(PolicyInfo.class, "policies", ReactorNettyClient.encodePath(vhost));
    }

    public Flux<PolicyInfo> getOperatorPolicies() {
        return this.doGetFlux(PolicyInfo.class, "operator-policies");
    }

    public Flux<PolicyInfo> getOperatorPolicies(String vhost) {
        return this.doGetFlux(PolicyInfo.class, "operator-policies", ReactorNettyClient.encodePath(vhost));
    }

    public Mono<HttpResponse> deletePolicy(String vhost, String name) {
        return this.doDelete("policies", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> deleteOperatorPolicy(String vhost, String name) {
        return this.doDelete("operator-policies", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Flux<ChannelInfo> getChannels() {
        return this.doGetFlux(ChannelInfo.class, "channels");
    }

    public Flux<ChannelInfo> getChannels(String connectionName) {
        return this.doGetFlux(ChannelInfo.class, "connections", ReactorNettyClient.encodePath(connectionName), "channels");
    }

    public Mono<ChannelInfo> getChannel(String name) {
        return this.doGetMono(ChannelInfo.class, "channels", ReactorNettyClient.encodePath(name));
    }

    public Flux<VhostInfo> getVhosts() {
        return this.doGetFlux(VhostInfo.class, "vhosts");
    }

    public Mono<VhostInfo> getVhost(String name) {
        return this.doGetMono(VhostInfo.class, "vhosts", ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> createVhost(String name, boolean tracing, String description, String ... tags) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tracing", tracing);
        if (description != null && !description.isEmpty()) {
            body.put("description", description);
        }
        if (tags != null && tags.length > 0) {
            body.put("tags", String.join((CharSequence)",", tags));
        }
        return this.doPut(body, "vhosts", ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> createVhost(String name, String description, String ... tags) {
        return this.createVhost(name, false, description, tags);
    }

    public Mono<HttpResponse> createVhost(String name, boolean tracing) {
        return this.createVhost(name, tracing, null, new String[0]);
    }

    public Mono<HttpResponse> createVhost(String name) {
        return this.doPut("vhosts", ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> deleteVhost(String name) {
        return this.doDelete("vhosts", ReactorNettyClient.encodePath(name));
    }

    public Flux<UserPermissions> getPermissionsIn(String vhost) {
        return this.doGetFlux(UserPermissions.class, "vhosts", ReactorNettyClient.encodePath(vhost), "permissions");
    }

    public Mono<HttpResponse> updatePermissions(String vhost, String username, UserPermissions permissions) {
        return this.doPut(permissions, "permissions", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(username));
    }

    public Flux<TopicPermissions> getTopicPermissionsIn(String vhost) {
        return this.doGetFlux(TopicPermissions.class, "vhosts", ReactorNettyClient.encodePath(vhost), "topic-permissions");
    }

    public Mono<HttpResponse> updateTopicPermissions(String vhost, String username, TopicPermissions permissions) {
        return this.doPut(permissions, "topic-permissions", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(username));
    }

    public Flux<UserInfo> getUsers() {
        return this.doGetFlux(UserInfo.class, "users");
    }

    public Mono<UserInfo> getUser(String username) {
        return this.doGetMono(UserInfo.class, "users", ReactorNettyClient.encodePath(username));
    }

    public Mono<HttpResponse> deleteUser(String username) {
        return this.doDelete("users", ReactorNettyClient.encodePath(username));
    }

    public Mono<HttpResponse> createUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null or empty. If you need to create a user that will only authenticate using an x509 certificate, use createUserWithPasswordHash with a blank hash.");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password", new String(password));
        if (tags == null || tags.isEmpty()) {
            body.put("tags", "");
        } else {
            body.put("tags", String.join((CharSequence)",", tags));
        }
        return this.doPut(body, "users", ReactorNettyClient.encodePath(username));
    }

    public Mono<HttpResponse> updateUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        if (password != null) {
            body.put("password", new String(password));
        }
        if (tags == null || tags.isEmpty()) {
            body.put("tags", "");
        } else {
            body.put("tags", String.join((CharSequence)",", tags));
        }
        return this.doPut(body, "users", ReactorNettyClient.encodePath(username));
    }

    public Flux<UserPermissions> getPermissionsOf(String username) {
        return this.doGetFlux(UserPermissions.class, "users", ReactorNettyClient.encodePath(username), "permissions");
    }

    public Flux<TopicPermissions> getTopicPermissionsOf(String username) {
        return this.doGetFlux(TopicPermissions.class, "users", ReactorNettyClient.encodePath(username), "topic-permissions");
    }

    public Mono<HttpResponse> createUserWithPasswordHash(String username, char[] passwordHash, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (passwordHash == null) {
            passwordHash = "".toCharArray();
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password_hash", String.valueOf(passwordHash));
        if (tags == null || tags.isEmpty()) {
            body.put("tags", "");
        } else {
            body.put("tags", String.join((CharSequence)",", tags));
        }
        return this.doPut(body, "users", ReactorNettyClient.encodePath(username));
    }

    public Mono<CurrentUserDetails> whoAmI() {
        return this.doGetMono(CurrentUserDetails.class, "whoami");
    }

    public Flux<UserPermissions> getPermissions() {
        return this.doGetFlux(UserPermissions.class, "permissions");
    }

    public Mono<UserPermissions> getPermissions(String vhost, String username) {
        return this.doGetMono(UserPermissions.class, "permissions", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(username));
    }

    public Mono<HttpResponse> clearPermissions(String vhost, String username) {
        return this.doDelete("permissions", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(username));
    }

    public Flux<TopicPermissions> getTopicPermissions() {
        return this.doGetFlux(TopicPermissions.class, "topic-permissions");
    }

    public Flux<TopicPermissions> getTopicPermissions(String vhost, String username) {
        return this.doGetFlux(TopicPermissions.class, "topic-permissions", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(username));
    }

    public Mono<HttpResponse> clearTopicPermissions(String vhost, String username) {
        return this.doDelete("topic-permissions", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(username));
    }

    public Flux<ExchangeInfo> getExchanges() {
        return this.doGetFlux(ExchangeInfo.class, "exchanges");
    }

    public Flux<ExchangeInfo> getExchanges(String vhost) {
        return this.doGetFlux(ExchangeInfo.class, "exchanges", ReactorNettyClient.encodePath(vhost));
    }

    public Mono<ExchangeInfo> getExchange(String vhost, String name) {
        return this.doGetMono(ExchangeInfo.class, "exchanges", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> declareExchange(String vhost, String name, ExchangeInfo info) {
        return this.doPut(info, "exchanges", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> deleteExchange(String vhost, String name) {
        return this.doDelete("exchanges", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<Boolean> publish(String vhost, String exchange, String routingKey, OutboundMessage outboundMessage) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        Map<String, Object> body = Utils.bodyForPublish(routingKey, outboundMessage);
        return this.doPostMono(body, Map.class, "exchanges", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(exchange), "publish").map(response -> {
            Boolean routed = (Boolean)response.get("routed");
            if (routed == null) {
                return Boolean.FALSE;
            }
            return routed;
        });
    }

    public Mono<AlivenessTestResult> alivenessTest(String vhost) {
        return this.doGetMono(AlivenessTestResult.class, "aliveness-test", ReactorNettyClient.encodePath(vhost));
    }

    public Mono<ClusterId> getClusterName() {
        return this.doGetMono(ClusterId.class, "cluster-name");
    }

    public Mono<HttpResponse> setClusterName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        return this.doPut(Collections.singletonMap("name", name), "cluster-name");
    }

    public Flux<Map> getExtensions() {
        return this.doGetFlux(Map.class, "extensions");
    }

    public Mono<Definitions> getDefinitions() {
        return this.doGetMono(Definitions.class, "definitions");
    }

    public Flux<QueueInfo> getQueues() {
        return this.getQueues((DetailsParameters)null);
    }

    public Flux<QueueInfo> getQueues(DetailsParameters detailsParameters) {
        return this.doGetFlux(QueueInfo.class, detailsParameters == null ? Collections.emptyMap() : detailsParameters.parameters(), "queues");
    }

    public Flux<QueueInfo> getQueues(String vhost) {
        return this.getQueues(vhost, null);
    }

    public Flux<QueueInfo> getQueues(String vhost, DetailsParameters detailsParameters) {
        return this.doGetFlux(QueueInfo.class, detailsParameters == null ? Collections.emptyMap() : detailsParameters.parameters(), "queues", ReactorNettyClient.encodePath(vhost));
    }

    public Mono<QueueInfo> getQueue(String vhost, String name, DetailsParameters detailsParameters) {
        return this.doGetMono(QueueInfo.class, detailsParameters == null ? Collections.emptyMap() : detailsParameters.parameters(), "queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<QueueInfo> getQueue(String vhost, String name) {
        return this.getQueue(vhost, name, null);
    }

    public Mono<HttpResponse> declareQueue(String vhost, String name, QueueInfo info) {
        return this.doPut(info, "queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> purgeQueue(String vhost, String name) {
        return this.doDelete("queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name), "contents");
    }

    public Mono<HttpResponse> deleteQueue(String vhost, String name) {
        return this.doDelete("queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> deleteQueue(String vhost, String name, DeleteQueueParameters parameters) {
        return this.doDelete((? super HttpHeaders headers) -> {}, parameters.getAsQueryParams(), "queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Flux<InboundMessage> get(String vhost, String queue, int count, GetAckMode ackMode, GetEncoding encoding, int truncate) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        Map<String, Object> body = Utils.bodyForGet(count, ackMode, encoding, truncate);
        return this.doPostFlux(body, InboundMessage.class, "queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(queue), "get");
    }

    public Flux<InboundMessage> get(String vhost, String queue, int count, GetAckMode ackMode, GetEncoding encoding) {
        return this.get(vhost, queue, count, ackMode, encoding, -1);
    }

    public Mono<InboundMessage> get(String vhost, String queue) {
        return this.get(vhost, queue, 1, GetAckMode.NACK_REQUEUE_TRUE, GetEncoding.AUTO, 50000).last();
    }

    public Flux<BindingInfo> getBindings() {
        return this.doGetFlux(BindingInfo.class, "bindings");
    }

    public Flux<BindingInfo> getBindings(String vhost) {
        return this.doGetFlux(BindingInfo.class, "bindings", ReactorNettyClient.encodePath(vhost));
    }

    public Flux<BindingInfo> getExchangeBindingsBySource(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        return this.doGetFlux(BindingInfo.class, "exchanges", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(x), "bindings", "source");
    }

    public Flux<BindingInfo> getExchangeBindingsByDestination(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        return this.doGetFlux(BindingInfo.class, "exchanges", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(x), "bindings", "destination");
    }

    public Flux<BindingInfo> getQueueBindings(String vhost, String queue) {
        return this.doGetFlux(BindingInfo.class, "queues", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(queue), "bindings");
    }

    public Flux<BindingInfo> getQueueBindingsBetween(String vhost, String exchange, String queue) {
        return this.doGetFlux(BindingInfo.class, "bindings", ReactorNettyClient.encodePath(vhost), "e", ReactorNettyClient.encodePath(exchange), "q", ReactorNettyClient.encodePath(queue));
    }

    public Flux<BindingInfo> getExchangeBindingsBetween(String vhost, String source, String destination) {
        return this.doGetFlux(BindingInfo.class, "bindings", ReactorNettyClient.encodePath(vhost), "e", ReactorNettyClient.encodePath(source), "e", ReactorNettyClient.encodePath(destination));
    }

    public Mono<HttpResponse> bindExchange(String vhost, String destination, String source, String routingKey) {
        return this.bindExchange(vhost, destination, source, routingKey, new HashMap<String, Object>());
    }

    public Mono<HttpResponse> bindExchange(String vhost, String destination, String source, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("arguments", args);
        }
        body.put("routing_key", routingKey);
        return this.doPost(body, "bindings", ReactorNettyClient.encodePath(vhost), "e", ReactorNettyClient.encodePath(source), "e", ReactorNettyClient.encodePath(destination));
    }

    public Mono<HttpResponse> bindQueue(String vhost, String queue, String exchange, String routingKey) {
        return this.bindQueue(vhost, queue, exchange, routingKey, new HashMap<String, Object>());
    }

    public Mono<HttpResponse> bindQueue(String vhost, String queue, String exchange, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("arguments", args);
        }
        body.put("routing_key", routingKey);
        return this.doPost(body, "bindings", ReactorNettyClient.encodePath(vhost), "e", ReactorNettyClient.encodePath(exchange), "q", ReactorNettyClient.encodePath(queue));
    }

    public Mono<HttpResponse> declareShovel(String vhost, ShovelInfo info) {
        Map<String, Object> props = info.getDetails().getPublishProperties();
        if (props != null && props.isEmpty()) {
            throw new IllegalArgumentException("Shovel publish properties must be a non-empty map or null");
        }
        return this.doPut(info, "parameters", "shovel", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(info.getName()));
    }

    public Flux<ShovelInfo> getShovels() {
        return this.doGetFlux(ShovelInfo.class, "parameters", "shovel");
    }

    public Flux<ShovelStatus> getShovelsStatus() {
        return this.doGetFlux(ShovelStatus.class, "shovels");
    }

    public Mono<HttpResponse> deleteShovel(String vhost, String shovelName) {
        return this.doDelete("parameters", "shovel", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(shovelName));
    }

    public Mono<HttpResponse> declareUpstream(String vhost, String name, UpstreamDetails details) {
        if (ReactorNettyClient.isEmpty(details.getUri())) {
            throw new IllegalArgumentException("Upstream uri must not be null or empty");
        }
        UpstreamInfo body = new UpstreamInfo();
        body.setVhost(vhost);
        body.setName(name);
        body.setValue(details);
        return this.doPut(body, "parameters", "federation-upstream", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> deleteUpstream(String vhost, String name) {
        return this.doDelete("parameters", "federation-upstream", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Flux<UpstreamInfo> getUpstreams() {
        return this.doGetFlux(UpstreamInfo.class, "parameters", "federation-upstream");
    }

    public Flux<UpstreamInfo> getUpstreams(String vhost) {
        return this.doGetFlux(UpstreamInfo.class, "parameters", "federation-upstream", ReactorNettyClient.encodePath(vhost));
    }

    public Mono<HttpResponse> declareUpstreamSet(String vhost, String name, List<UpstreamSetDetails> details) {
        for (UpstreamSetDetails item : details) {
            if (!ReactorNettyClient.isEmpty(item.getUpstream())) continue;
            throw new IllegalArgumentException("Each federation upstream set item must have a non-null and not empty upstream name");
        }
        UpstreamSetInfo body = new UpstreamSetInfo();
        body.setVhost(vhost);
        body.setName(name);
        body.setValue(details);
        return this.doPut(body, "parameters", "federation-upstream-set", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Mono<HttpResponse> deleteUpstreamSet(String vhost, String name) {
        return this.doDelete("parameters", "federation-upstream-set", ReactorNettyClient.encodePath(vhost), ReactorNettyClient.encodePath(name));
    }

    public Flux<UpstreamSetInfo> getUpstreamSets() {
        return this.doGetFlux(UpstreamSetInfo.class, "parameters", "federation-upstream-set");
    }

    public Flux<UpstreamSetInfo> getUpstreamSets(String vhost) {
        return this.doGetFlux(UpstreamSetInfo.class, "parameters", "federation-upstream-set", ReactorNettyClient.encodePath(vhost));
    }

    public Flux<VhostLimits> getVhostLimits() {
        return this.doGetFlux(VhostLimits.class, "vhost-limits");
    }

    public Mono<VhostLimits> getVhostLimits(String vhost) {
        return this.doGetMono(VhostLimits.class, "vhost-limits", ReactorNettyClient.encodePath(vhost)).map(limits -> limits.getVhost() == null ? new VhostLimits(vhost, -1, -1) : limits);
    }

    public Mono<HttpResponse> limitMaxNumberOfConnections(String vhost, int limit) {
        return this.doPut(Collections.singletonMap("value", limit), "vhost-limits", ReactorNettyClient.encodePath(vhost), "max-connections");
    }

    public Mono<HttpResponse> limitMaxNumberOfQueues(String vhost, int limit) {
        return this.doPut(Collections.singletonMap("value", limit), "vhost-limits", ReactorNettyClient.encodePath(vhost), "max-queues");
    }

    public Mono<HttpResponse> clearMaxConnectionsLimit(String vhost) {
        return this.doDelete("vhost-limits", ReactorNettyClient.encodePath(vhost), "max-connections");
    }

    public Mono<HttpResponse> clearMaxQueuesLimit(String vhost) {
        return this.doDelete("vhost-limits", ReactorNettyClient.encodePath(vhost), "max-queues");
    }

    private <T> Mono<T> doGetMono(Class<T> type, String ... pathSegments) {
        return this.doGetMono(type, (Map<String, String>)null, pathSegments);
    }

    private <T> Mono<T> doGetMono(Class<T> type, Map<String, String> queryParameters, String ... pathSegments) {
        Object uri = ReactorNettyClient.uri(pathSegments);
        if (queryParameters != null && !queryParameters.isEmpty()) {
            uri = (String)uri + queryParameters.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), ReactorNettyClient.encodeHttpParameter((String)e.getValue()))).collect(Collectors.joining("&", "?", ""));
        }
        return Mono.from((Publisher)((HttpClient.ResponseReceiver)this.client.headersWhen(this.authorizedHeader()).get().uri((String)uri)).response(this.decode(type)));
    }

    protected <T> BiFunction<? super HttpClientResponse, ? super ByteBufFlux, Publisher<T>> decode(Class<T> type) {
        return (response, byteBufFlux) -> {
            this.responseCallback.accept((HttpClientResponse)response);
            if (response.status().code() == 404) {
                return Mono.empty();
            }
            return byteBufFlux.aggregate().asInputStream().map(bytes -> this.deserialize((InputStream)bytes, type));
        };
    }

    private <T> T deserialize(InputStream inputStream, Class<T> type) {
        try {
            Object value = this.objectMapper.readValue(inputStream, type);
            inputStream.close();
            return (T)value;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private <T> Flux<T> doGetFlux(Class<T> type, String ... pathSegments) {
        return this.doGetFlux(type, (Map<String, String>)null, pathSegments);
    }

    private <T> Flux<T> doGetFlux(Class<T> type, Map<String, String> queryParameters, String ... pathSegments) {
        return this.doGetMono(Array.newInstance(type, 0).getClass(), queryParameters, pathSegments).flatMapMany(items -> Flux.fromArray((Object[])((Object[])items)));
    }

    protected Function<? super HttpHeaders, Mono<? extends HttpHeaders>> authorizedHeader() {
        return headers -> this.token.map(t -> headers.set((CharSequence)HttpHeaderNames.AUTHORIZATION, t));
    }

    private Mono<HttpResponse> doPost(Object body, String ... pathSegments) {
        return ((HttpClient.RequestSender)this.client.headersWhen(this.authorizedHeader()).headers(JSON_HEADER).post().uri(ReactorNettyClient.uri(pathSegments))).send(this.bodyPublisher(body)).response().doOnNext(this.applyResponseCallback()).map(ReactorNettyClient::toHttpResponse);
    }

    private <T> Mono<T> doPostMono(Object body, Class<T> type, String ... pathSegments) {
        return Mono.from((Publisher)((HttpClient.RequestSender)this.client.headersWhen(this.authorizedHeader()).headers(JSON_HEADER).post().uri(ReactorNettyClient.uri(pathSegments))).send(this.bodyPublisher(body)).response(this.decode(type)));
    }

    private <T> Flux<T> doPostFlux(Object body, Class<T> type, String ... pathSegments) {
        return this.doPostMono(body, Array.newInstance(type, 0).getClass(), pathSegments).flatMapMany(items -> Flux.fromArray((Object[])((Object[])items)));
    }

    protected Consumer<HttpClientResponse> applyResponseCallback() {
        return response -> this.responseCallback.accept((HttpClientResponse)response);
    }

    private Mono<HttpResponse> doPut(Object body, String ... pathSegments) {
        return ((HttpClient.RequestSender)this.client.headersWhen(this.authorizedHeader()).headers(JSON_HEADER).put().uri(ReactorNettyClient.uri(pathSegments))).send(this.bodyPublisher(body)).response().doOnNext(this.applyResponseCallback()).map(ReactorNettyClient::toHttpResponse);
    }

    private Mono<ByteBuf> bodyPublisher(Object body) {
        return Mono.fromCallable(() -> {
            ByteBuf byteBuf = this.byteBufSupplier.get();
            ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(byteBuf);
            this.objectMapper.writeValue((OutputStream)byteBufOutputStream, body);
            return byteBuf;
        });
    }

    private Mono<HttpResponse> doPut(String ... pathSegments) {
        return ((HttpClient.RequestSender)this.client.headersWhen(this.authorizedHeader()).headers(JSON_HEADER).put().uri(ReactorNettyClient.uri(pathSegments))).response().doOnNext(this.applyResponseCallback()).map(ReactorNettyClient::toHttpResponse);
    }

    private Mono<HttpResponse> doDelete(Consumer<? super HttpHeaders> headerBuilder, Map<String, String> queryParams, String ... pathSegments) {
        Object uri = ReactorNettyClient.uri(pathSegments);
        if (queryParams != null && !queryParams.isEmpty()) {
            uri = (String)uri + queryParams.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), ReactorNettyClient.encodeHttpParameter((String)e.getValue()))).collect(Collectors.joining("&", "?", ""));
        }
        return ((HttpClient.RequestSender)this.client.headersWhen(this.authorizedHeader()).headers(headerBuilder).delete().uri((String)uri)).response().doOnNext(this.applyResponseCallback()).map(ReactorNettyClient::toHttpResponse);
    }

    private Mono<HttpResponse> doDelete(Consumer<? super HttpHeaders> headerBuilder, String ... pathSegments) {
        return this.doDelete(headerBuilder, Collections.emptyMap(), pathSegments);
    }

    private Mono<HttpResponse> doDelete(String ... pathSegments) {
        return this.doDelete((? super HttpHeaders headers) -> {}, pathSegments);
    }

    private static String uri(String ... pathSegments) {
        return "/" + String.join((CharSequence)"/", pathSegments);
    }

    private static String encodeHttpParameter(String parameter) {
        return Utils.encodeHttpParameter(parameter);
    }

    private static String encodePath(String pathSegment) {
        return Utils.encode(pathSegment);
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }
}

