/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.rabbitmq.http.client.domain.AlivenessTestResult;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.ChannelInfo;
import com.rabbitmq.http.client.domain.ClusterId;
import com.rabbitmq.http.client.domain.ConnectionInfo;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.Definitions;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import com.rabbitmq.http.client.domain.NodeInfo;
import com.rabbitmq.http.client.domain.OverviewResponse;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.UserPermissions;
import com.rabbitmq.http.client.domain.VhostInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class Client {
    private final RestTemplate rt;
    private final URI rootUri;

    public Client(String url, String username, String password) throws MalformedURLException, URISyntaxException {
        this(new URL(url), username, password);
    }

    public Client(URL url, String username, String password) throws MalformedURLException, URISyntaxException {
        this(url, username, password, null, null);
    }

    private Client(URL url, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext) throws MalformedURLException, URISyntaxException {
        this.rootUri = url.toURI();
        this.rt = new RestTemplate((ClientHttpRequestFactory)this.getRequestFactory(url, username, password, sslConnectionSocketFactory, sslContext));
        this.rt.setMessageConverters(this.getMessageConverters());
    }

    public Client(URL url, String username, String password, SSLContext sslContext) throws MalformedURLException, URISyntaxException {
        this(url, username, password, null, sslContext);
    }

    private Client(URL url, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory) throws MalformedURLException, URISyntaxException {
        this(url, username, password, sslConnectionSocketFactory, null);
    }

    public Client(String url) throws MalformedURLException, URISyntaxException {
        this(url, null, null);
    }

    public Client(URL url) throws MalformedURLException, URISyntaxException {
        this(url, null, null);
    }

    public OverviewResponse getOverview() {
        return (OverviewResponse)this.rt.getForObject(this.uriWithPath("./overview"), OverviewResponse.class);
    }

    public boolean alivenessTest(String vhost) {
        URI uri = this.uriWithPath("./aliveness-test/" + this.encodePathSegment(vhost));
        return ((AlivenessTestResult)this.rt.getForObject(uri, AlivenessTestResult.class)).isSuccessful();
    }

    public CurrentUserDetails whoAmI() {
        URI uri = this.uriWithPath("./whoami/");
        return (CurrentUserDetails)this.rt.getForObject(uri, CurrentUserDetails.class);
    }

    public List<NodeInfo> getNodes() {
        URI uri = this.uriWithPath("./nodes/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, NodeInfo[].class));
    }

    public NodeInfo getNode(String name) {
        URI uri = this.uriWithPath("./nodes/" + this.encodePathSegment(name));
        return (NodeInfo)this.rt.getForObject(uri, NodeInfo.class);
    }

    public List<ConnectionInfo> getConnections() {
        URI uri = this.uriWithPath("./connections/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ConnectionInfo[].class));
    }

    public ConnectionInfo getConnection(String name) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(name));
        return (ConnectionInfo)this.rt.getForObject(uri, ConnectionInfo.class);
    }

    public void closeConnection(String name) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(name));
        this.deleteIgnoring404(uri);
    }

    public List<ChannelInfo> getChannels() {
        URI uri = this.uriWithPath("./channels/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ChannelInfo[].class));
    }

    public List<ChannelInfo> getChannels(String connectionName) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(connectionName) + "/channels/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ChannelInfo[].class));
    }

    public ChannelInfo getChannel(String name) {
        URI uri = this.uriWithPath("./channels/" + this.encodePathSegment(name));
        return (ChannelInfo)this.rt.getForObject(uri, ChannelInfo.class);
    }

    public List<VhostInfo> getVhosts() {
        URI uri = this.uriWithPath("./vhosts/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, VhostInfo[].class));
    }

    public VhostInfo getVhost(String name) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        return this.getForObjectReturningNullOn404(uri, VhostInfo.class);
    }

    public void createVhost(String name) throws JsonProcessingException {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        this.rt.put(uri, null);
    }

    public void deleteVhost(String name) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        this.deleteIgnoring404(uri);
    }

    public List<UserPermissions> getPermissionsIn(String vhost) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(vhost) + "/permissions");
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<UserPermissions> getPermissionsOf(String username) {
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username) + "/permissions");
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<UserPermissions> getPermissions() {
        URI uri = this.uriWithPath("./permissions");
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public UserPermissions getPermissions(String vhost, String username) {
        URI uri = this.uriWithPath("./permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        return this.getForObjectReturningNullOn404(uri, UserPermissions.class);
    }

    public List<ExchangeInfo> getExchanges() {
        URI uri = this.uriWithPath("./exchanges/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ExchangeInfo[].class));
    }

    public List<ExchangeInfo> getExchanges(String vhost) {
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost));
        ExchangeInfo[] result = this.getForObjectReturningNullOn404(uri, ExchangeInfo[].class);
        return this.asListOrNull(result);
    }

    public ExchangeInfo getExchange(String vhost, String name) {
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        return this.getForObjectReturningNullOn404(uri, ExchangeInfo.class);
    }

    public void declareExchange(String vhost, String name, ExchangeInfo info) {
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        this.rt.put(uri, (Object)info);
    }

    public void deleteExchange(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public List<QueueInfo> getQueues() {
        URI uri = this.uriWithPath("./queues/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, QueueInfo[].class));
    }

    public List<QueueInfo> getQueues(String vhost) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost));
        QueueInfo[] result = this.getForObjectReturningNullOn404(uri, QueueInfo[].class);
        return this.asListOrNull(result);
    }

    public QueueInfo getQueue(String vhost, String name) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        return this.getForObjectReturningNullOn404(uri, QueueInfo.class);
    }

    public void declareQueue(String vhost, String name, QueueInfo info) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        this.rt.put(uri, (Object)info);
    }

    public void purgeQueue(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name) + "/contents/"));
    }

    public void deleteQueue(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public List<UserInfo> getUsers() {
        URI uri = this.uriWithPath("./users/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, UserInfo[].class));
    }

    public UserInfo getUser(String username) {
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        return this.getForObjectReturningNullOn404(uri, UserInfo.class);
    }

    public void createUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("password cannot be null or empty");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password", new String(password));
        body.put("tags", this.joinStrings(",", tags));
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        this.rt.put(uri, body);
    }

    public void updateUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        if (password != null) {
            body.put("password", new String(password));
        }
        body.put("tags", this.joinStrings(",", tags));
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        this.rt.put(uri, body);
    }

    public void deleteUser(String username) {
        this.deleteIgnoring404(this.uriWithPath("./users/" + this.encodePathSegment(username)));
    }

    public void updatePermissions(String vhost, String username, UserPermissions permissions) {
        URI uri = this.uriWithPath("./permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        this.rt.put(uri, (Object)permissions);
    }

    public void clearPermissions(String vhost, String username) {
        URI uri = this.uriWithPath("./permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        this.deleteIgnoring404(uri);
    }

    public List<BindingInfo> getBindings() {
        URI uri = this.uriWithPath("./bindings/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getBindings(String vhost) {
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost));
        return Arrays.asList((Object[])this.rt.getForObject(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getBindingsBySource(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(x) + "/bindings/source");
        return Arrays.asList((Object[])this.rt.getForObject(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getExchangeBindingsByDestination(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(x) + "/bindings/destination");
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getQueueBindingsBetween(String vhost, String exchange, String queue) {
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(exchange) + "/q/" + this.encodePathSegment(queue));
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getExchangeBindingsBetween(String vhost, String source, String destination) {
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(source) + "/e/" + this.encodePathSegment(destination));
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public void bindQueue(String vhost, String queue, String exchange, String routingKey) {
        this.bindQueue(vhost, queue, exchange, routingKey, new HashMap<String, Object>());
    }

    public void bindQueue(String vhost, String queue, String exchange, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("args", args);
        }
        body.put("routing_key", routingKey);
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(exchange) + "/q/" + this.encodePathSegment(queue));
        this.rt.postForLocation(uri, body);
    }

    public void bindExchange(String vhost, String destination, String source, String routingKey) {
        this.bindExchange(vhost, destination, source, routingKey, new HashMap<String, Object>());
    }

    public void bindExchange(String vhost, String destination, String source, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("args", args);
        }
        body.put("routing_key", routingKey);
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(source) + "/e/" + this.encodePathSegment(destination));
        this.rt.postForLocation(uri, body);
    }

    public ClusterId getClusterName() {
        return (ClusterId)this.rt.getForObject(this.uriWithPath("./cluster-name"), ClusterId.class);
    }

    public void setClusterName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        URI uri = this.uriWithPath("./cluster-name");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("name", name);
        this.rt.put(uri, m);
    }

    public List<Map> getExtensions() {
        URI uri = this.uriWithPath("./extensions/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, Map[].class));
    }

    public Definitions getDefinitions() {
        URI uri = this.uriWithPath("./definitions/");
        return (Definitions)this.rt.getForObject(uri, Definitions.class);
    }

    private URI uriWithPath(String path) {
        return this.rootUri.resolve(path);
    }

    private String encodePathSegment(String pathSegment) {
        return URLEncoder.encode(pathSegment);
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList xs = new ArrayList();
        Jackson2ObjectMapperBuilder bldr = Jackson2ObjectMapperBuilder.json().serializationInclusion(JsonInclude.Include.NON_NULL);
        xs.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(bldr.build()));
        return xs;
    }

    private HttpComponentsClientHttpRequestFactory getRequestFactory(URL url, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext) throws MalformedURLException {
        String theUser = username;
        String thePassword = password;
        String userInfo = url.getUserInfo();
        if (userInfo != null && theUser == null) {
            String[] userParts = userInfo.split(":");
            if (userParts.length > 0) {
                theUser = userParts[0];
            }
            if (userParts.length > 1) {
                thePassword = userParts[1];
            }
        }
        HttpClientBuilder bldr = HttpClientBuilder.create().setDefaultCredentialsProvider(this.getCredentialsProvider(url, theUser, thePassword));
        bldr.setDefaultHeaders(Arrays.asList(new BasicHeader("Content-Type", "application/json")));
        if (sslConnectionSocketFactory != null) {
            bldr.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }
        if (sslContext != null) {
            bldr.setSslcontext(sslContext);
        }
        CloseableHttpClient httpClient = bldr.build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicScheme = new BasicScheme();
        authCache.put(new HttpHost(this.rootUri.getHost(), this.rootUri.getPort(), this.rootUri.getScheme()), (AuthScheme)basicScheme);
        final HttpClientContext ctx = HttpClientContext.create();
        ctx.setAuthCache((AuthCache)authCache);
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient){

            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                return ctx;
            }
        };
    }

    private CredentialsProvider getCredentialsProvider(URL url, String username, String password) {
        BasicCredentialsProvider cp = new BasicCredentialsProvider();
        cp.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        return cp;
    }

    private <T> T getForObjectReturningNullOn404(URI uri, Class<T> klass) {
        try {
            return (T)this.rt.getForObject(uri, klass);
        }
        catch (HttpClientErrorException ce) {
            if (ce.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw ce;
        }
    }

    private void deleteIgnoring404(URI uri) {
        block2: {
            try {
                this.rt.delete(uri);
            }
            catch (HttpClientErrorException ce) {
                if (ce.getStatusCode() == HttpStatus.NOT_FOUND) break block2;
                throw ce;
            }
        }
    }

    private <T> List<T> asListOrNull(T[] result) {
        if (result == null) {
            return null;
        }
        return Arrays.asList(result);
    }

    private String joinStrings(String delimiter, List<String> tags) {
        StringBuilder sb = new StringBuilder();
        boolean appendedFirst = false;
        for (String tag : tags) {
            if (!appendedFirst) {
                sb.append(tag);
                appendedFirst = true;
                continue;
            }
            sb.append(delimiter);
            if (tag == null) continue;
            sb.append(tag);
        }
        return sb.toString();
    }
}

