/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr.widget;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.r0adkll.slidr.model.SlidrConfig;

public class SliderPanel
extends FrameLayout {
    private static final int MIN_FLING_VELOCITY = 400;
    private int mScreenWidth;
    private int mScreenHeight;
    private View mDimView;
    private View mDecorView;
    private ViewDragHelper mDragHelper;
    private OnPanelSlideListener mListener;
    private boolean mIsLocked = false;
    private boolean mIsEdgeTouched = false;
    private int mEdgePosition;
    private SlidrConfig mConfig;
    private ViewDragHelper.Callback mLeftCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            boolean edgeCase = !SliderPanel.this.mConfig.isEdgeOnly() || SliderPanel.this.mDragHelper.isEdgeTouched(SliderPanel.this.mEdgePosition, pointerId);
            return child.getId() == SliderPanel.this.mDecorView.getId() && edgeCase;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, 0, SliderPanel.this.mScreenWidth);
        }

        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isVerticalSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int left = releasedChild.getLeft();
            int settleLeft = 0;
            int leftThreshold = (int)((float)SliderPanel.this.getWidth() * SliderPanel.this.mConfig.getDistanceThreshold());
            boolean bl = isVerticalSwiping = Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold();
            if (xvel > 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = SliderPanel.this.mScreenWidth;
                } else if (left > leftThreshold) {
                    settleLeft = SliderPanel.this.mScreenWidth;
                }
            } else if (xvel == 0.0f && left > leftThreshold) {
                settleLeft = SliderPanel.this.mScreenWidth;
            }
            SliderPanel.this.mDragHelper.settleCapturedViewAt(settleLeft, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)left / (float)SliderPanel.this.mScreenWidth;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getLeft() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mRightCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            boolean edgeCase = !SliderPanel.this.mConfig.isEdgeOnly() || SliderPanel.this.mDragHelper.isEdgeTouched(SliderPanel.this.mEdgePosition, pointerId);
            return child.getId() == SliderPanel.this.mDecorView.getId() && edgeCase;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, -SliderPanel.this.mScreenWidth, 0);
        }

        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isVerticalSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int left = releasedChild.getLeft();
            int settleLeft = 0;
            int leftThreshold = (int)((float)SliderPanel.this.getWidth() * SliderPanel.this.mConfig.getDistanceThreshold());
            boolean bl = isVerticalSwiping = Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold();
            if (xvel < 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = -SliderPanel.this.mScreenWidth;
                } else if (left < -leftThreshold) {
                    settleLeft = -SliderPanel.this.mScreenWidth;
                }
            } else if (xvel == 0.0f && left < -leftThreshold) {
                settleLeft = -SliderPanel.this.mScreenWidth;
            }
            SliderPanel.this.mDragHelper.settleCapturedViewAt(settleLeft, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(left) / (float)SliderPanel.this.mScreenWidth;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getLeft() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mTopCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId() && (!SliderPanel.this.mConfig.isEdgeOnly() || SliderPanel.this.mIsEdgeTouched);
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, 0, SliderPanel.this.mScreenHeight);
        }

        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.mScreenHeight;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isSideSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int top = releasedChild.getTop();
            int settleTop = 0;
            int topThreshold = (int)((float)SliderPanel.this.getHeight() * SliderPanel.this.mConfig.getDistanceThreshold());
            boolean bl = isSideSwiping = Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold();
            if (yvel > 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = SliderPanel.this.mScreenHeight;
                } else if (top > topThreshold) {
                    settleTop = SliderPanel.this.mScreenHeight;
                }
            } else if (yvel == 0.0f && top > topThreshold) {
                settleTop = SliderPanel.this.mScreenHeight;
            }
            SliderPanel.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), settleTop);
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.mScreenHeight;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getTop() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mBottomCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId() && (!SliderPanel.this.mConfig.isEdgeOnly() || SliderPanel.this.mIsEdgeTouched);
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, -SliderPanel.this.mScreenHeight, 0);
        }

        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.mScreenHeight;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isSideSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int top = releasedChild.getTop();
            int settleTop = 0;
            int topThreshold = (int)((float)SliderPanel.this.getHeight() * SliderPanel.this.mConfig.getDistanceThreshold());
            boolean bl = isSideSwiping = Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold();
            if (yvel < 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = -SliderPanel.this.mScreenHeight;
                } else if (top < -topThreshold) {
                    settleTop = -SliderPanel.this.mScreenHeight;
                }
            } else if (yvel == 0.0f && top < -topThreshold) {
                settleTop = -SliderPanel.this.mScreenHeight;
            }
            SliderPanel.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), settleTop);
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.mScreenHeight;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getTop() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mVerticalCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId() && (!SliderPanel.this.mConfig.isEdgeOnly() || SliderPanel.this.mIsEdgeTouched);
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, -SliderPanel.this.mScreenHeight, SliderPanel.this.mScreenHeight);
        }

        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.mScreenHeight;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isSideSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int top = releasedChild.getTop();
            int settleTop = 0;
            int topThreshold = (int)((float)SliderPanel.this.getHeight() * SliderPanel.this.mConfig.getDistanceThreshold());
            boolean bl = isSideSwiping = Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold();
            if (yvel > 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = SliderPanel.this.mScreenHeight;
                } else if (top > topThreshold) {
                    settleTop = SliderPanel.this.mScreenHeight;
                }
            } else if (yvel < 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = -SliderPanel.this.mScreenHeight;
                } else if (top < -topThreshold) {
                    settleTop = -SliderPanel.this.mScreenHeight;
                }
            } else if (top > topThreshold) {
                settleTop = SliderPanel.this.mScreenHeight;
            } else if (top < -topThreshold) {
                settleTop = -SliderPanel.this.mScreenHeight;
            }
            SliderPanel.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), settleTop);
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.mScreenHeight;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getTop() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mHorizontalCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            boolean edgeCase = !SliderPanel.this.mConfig.isEdgeOnly() || SliderPanel.this.mDragHelper.isEdgeTouched(SliderPanel.this.mEdgePosition, pointerId);
            return child.getId() == SliderPanel.this.mDecorView.getId() && edgeCase;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, -SliderPanel.this.mScreenWidth, SliderPanel.this.mScreenWidth);
        }

        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isVerticalSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int left = releasedChild.getLeft();
            int settleLeft = 0;
            int leftThreshold = (int)((float)SliderPanel.this.getWidth() * SliderPanel.this.mConfig.getDistanceThreshold());
            boolean bl = isVerticalSwiping = Math.abs(yvel) > SliderPanel.this.mConfig.getVelocityThreshold();
            if (xvel > 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = SliderPanel.this.mScreenWidth;
                } else if (left > leftThreshold) {
                    settleLeft = SliderPanel.this.mScreenWidth;
                }
            } else if (xvel < 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.mConfig.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = -SliderPanel.this.mScreenWidth;
                } else if (left < -leftThreshold) {
                    settleLeft = -SliderPanel.this.mScreenWidth;
                }
            } else if (left > leftThreshold) {
                settleLeft = SliderPanel.this.mScreenWidth;
            } else if (left < -leftThreshold) {
                settleLeft = -SliderPanel.this.mScreenWidth;
            }
            SliderPanel.this.mDragHelper.settleCapturedViewAt(settleLeft, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(left) / (float)SliderPanel.this.mScreenWidth;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getLeft() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };

    public SliderPanel(Context context) {
        super(context);
    }

    public SliderPanel(Context context, View decorView) {
        this(context, decorView, null);
    }

    public SliderPanel(Context context, View decorView, SlidrConfig config) {
        super(context);
        this.mDecorView = decorView;
        this.mConfig = config == null ? new SlidrConfig.Builder().build() : config;
        this.init();
    }

    public void setOnPanelSlideListener(OnPanelSlideListener listener) {
        this.mListener = listener;
    }

    private void init() {
        ViewDragHelper.Callback callback;
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        float density = this.getResources().getDisplayMetrics().density;
        float minVel = 400.0f * density;
        switch (this.mConfig.getPosition()) {
            case LEFT: {
                callback = this.mLeftCallback;
                this.mEdgePosition = 1;
                break;
            }
            case RIGHT: {
                callback = this.mRightCallback;
                this.mEdgePosition = 2;
                break;
            }
            case TOP: {
                callback = this.mTopCallback;
                this.mEdgePosition = 4;
                break;
            }
            case BOTTOM: {
                callback = this.mBottomCallback;
                this.mEdgePosition = 8;
                break;
            }
            case VERTICAL: {
                callback = this.mVerticalCallback;
                this.mEdgePosition = 12;
                break;
            }
            case HORIZONTAL: {
                callback = this.mHorizontalCallback;
                this.mEdgePosition = 3;
                break;
            }
            default: {
                callback = this.mLeftCallback;
                this.mEdgePosition = 1;
            }
        }
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)this.mConfig.getSensitivity(), (ViewDragHelper.Callback)callback);
        this.mDragHelper.setMinVelocity(minVel);
        this.mDragHelper.setEdgeTrackingEnabled(this.mEdgePosition);
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
        this.mDimView = new View(this.getContext());
        this.mDimView.setBackgroundColor(this.mConfig.getScrimColor());
        this.mDimView.setAlpha(this.mConfig.getScrimStartAlpha());
        this.addView(this.mDimView);
        this.post(new Runnable(){

            @Override
            public void run() {
                SliderPanel.this.mScreenHeight = SliderPanel.this.getHeight();
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean interceptForDrag;
        if (this.mIsLocked) {
            return false;
        }
        if (this.mConfig.isEdgeOnly()) {
            this.mIsEdgeTouched = this.canDragFromEdge(ev);
        }
        try {
            interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception e) {
            interceptForDrag = false;
        }
        return interceptForDrag && !this.mIsLocked;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mIsLocked) {
            return false;
        }
        try {
            this.mDragHelper.processTouchEvent(event);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void lock() {
        this.mDragHelper.abort();
        this.mIsLocked = true;
    }

    public void unlock() {
        this.mDragHelper.abort();
        this.mIsLocked = false;
    }

    private boolean canDragFromEdge(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        switch (this.mConfig.getPosition()) {
            case LEFT: {
                return x < this.mConfig.getEdgeSize(this.getWidth());
            }
            case RIGHT: {
                return x > (float)this.getWidth() - this.mConfig.getEdgeSize(this.getWidth());
            }
            case BOTTOM: {
                return y > (float)this.getHeight() - this.mConfig.getEdgeSize(this.getHeight());
            }
            case TOP: {
                return y < this.mConfig.getEdgeSize(this.getHeight());
            }
            case HORIZONTAL: {
                return x < this.mConfig.getEdgeSize(this.getWidth()) || x > (float)this.getWidth() - this.mConfig.getEdgeSize(this.getWidth());
            }
            case VERTICAL: {
                return y < this.mConfig.getEdgeSize(this.getHeight()) || y > (float)this.getHeight() - this.mConfig.getEdgeSize(this.getHeight());
            }
        }
        return false;
    }

    public void applyScrim(float percent) {
        float alpha = percent * (this.mConfig.getScrimStartAlpha() - this.mConfig.getScrimEndAlpha()) + this.mConfig.getScrimEndAlpha();
        this.mDimView.setAlpha(alpha);
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static interface OnPanelSlideListener {
        public void onStateChanged(int var1);

        public void onClosed();

        public void onOpened();

        public void onSlideChange(float var1);
    }
}

