/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;

public class ScreenHelper {
    @SuppressLint(value={"NewApi"})
    public static ScreenSize getScreenSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        float density = context.getResources().getDisplayMetrics().density;
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return new ScreenSize(density, size.x, size.y);
    }

    public static class ScreenSize {
        private float density = 0.0f;
        private float width = 0.0f;
        private float height = 0.0f;
        private float dpWidth = 0.0f;
        private float dpHeight = 0.0f;

        public ScreenSize(float density, float width, float height) {
            this.density = density;
            this.width = width;
            this.height = height;
            this.dpWidth = width / density;
            this.dpHeight = height / density;
        }

        public float getDp(int pixel) {
            return (float)pixel / this.density;
        }

        public float getPixel(int dp) {
            return (float)dp * this.density;
        }

        public float getDensity() {
            return this.density;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public float getDpWidth() {
            return this.dpWidth;
        }

        public float getDpHeight() {
            return this.dpHeight;
        }
    }
}

