/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.app.content;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuickSharedPreferences
implements SharedPreferences {
    private static final Gson gson = new Gson();
    private SharedPreferences sharedPreferences;

    public QuickSharedPreferences(Context context) {
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public QuickSharedPreferences(Context context, String prefName) {
        this.sharedPreferences = context.getSharedPreferences(prefName, 0);
    }

    public Map<String, ?> getAll() {
        return this.sharedPreferences.getAll();
    }

    @Nullable
    public String getString(String key, String defValue) {
        return this.sharedPreferences.getString(key, defValue);
    }

    @Nullable
    public Set<String> getStringSet(String key, Set<String> defValues) {
        return null;
    }

    public int getInt(String key, int defValue) {
        return this.sharedPreferences.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return this.sharedPreferences.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return this.sharedPreferences.getFloat(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.sharedPreferences.getBoolean(key, defValue);
    }

    public boolean contains(String key) {
        return this.sharedPreferences.contains(key);
    }

    public Editor edit() {
        return new Editor(this.sharedPreferences.edit());
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.sharedPreferences.registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.sharedPreferences.unregisterOnSharedPreferenceChangeListener(listener);
    }

    public String[] getStringArray(String key) {
        try {
            return (String[])gson.fromJson(this.sharedPreferences.getString(key, "[]"), String[].class);
        }
        catch (JsonSyntaxException e) {
            return new String[0];
        }
    }

    public List<String> getStringList(String key) {
        try {
            return (List)gson.fromJson(this.sharedPreferences.getString(key, "[]"), new TypeToken<List<String>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
    }

    public boolean[] getBooleanArray(String key) {
        try {
            return (boolean[])gson.fromJson(this.sharedPreferences.getString(key, "[]"), boolean[].class);
        }
        catch (JsonSyntaxException e) {
            return new boolean[0];
        }
    }

    public List<Boolean> getBooleanList(String key) {
        try {
            return (List)gson.fromJson(this.sharedPreferences.getString(key, "[]"), new TypeToken<List<Boolean>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
    }

    public int[] getIntArray(String key) {
        try {
            return (int[])gson.fromJson(this.sharedPreferences.getString(key, "[]"), int[].class);
        }
        catch (JsonSyntaxException e) {
            return new int[0];
        }
    }

    public List<Integer> getIntList(String key) {
        try {
            return (List)gson.fromJson(this.sharedPreferences.getString(key, "[]"), new TypeToken<List<Integer>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
    }

    public float[] getFloatArray(String key) {
        try {
            return (float[])gson.fromJson(this.sharedPreferences.getString(key, "[]"), float[].class);
        }
        catch (JsonSyntaxException e) {
            return new float[0];
        }
    }

    public List<Float> getFloatList(String key) {
        try {
            return (List)gson.fromJson(this.sharedPreferences.getString(key, "[]"), new TypeToken<List<Float>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
    }

    public long[] getLongArray(String key) {
        try {
            return (long[])gson.fromJson(this.sharedPreferences.getString(key, "[]"), long[].class);
        }
        catch (JsonSyntaxException e) {
            return new long[0];
        }
    }

    public List<Long> getLongList(String key) {
        try {
            return (List)gson.fromJson(this.sharedPreferences.getString(key, "[]"), new TypeToken<List<Long>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
    }

    public static class Editor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor editor;

        private Editor(SharedPreferences.Editor editor) {
            this.editor = editor;
        }

        public Editor putString(String key, String value) {
            this.editor.putString(key, value);
            return this;
        }

        @TargetApi(value=11)
        public Editor putStringSet(String key, Set<String> values) {
            this.editor.putStringSet(key, values);
            return this;
        }

        public Editor putInt(String key, int value) {
            this.editor.putInt(key, value);
            return this;
        }

        public Editor putLong(String key, long value) {
            this.editor.putLong(key, value);
            return this;
        }

        public Editor putFloat(String key, float value) {
            this.editor.putFloat(key, value);
            return this;
        }

        public Editor putBoolean(String key, boolean value) {
            this.editor.putBoolean(key, value);
            return this;
        }

        public Editor putStringArray(String key, String[] value) {
            this.editor.putString(key, gson.toJson((Object)value));
            return this;
        }

        public Editor putStringList(String key, List<String> value) {
            this.editor.putString(key, gson.toJson(value));
            return this;
        }

        public Editor putBooleanArray(String key, boolean[] value) {
            this.editor.putString(key, gson.toJson((Object)value));
            return this;
        }

        public Editor putBooleanList(String key, List<Boolean> value) {
            this.editor.putString(key, gson.toJson(value));
            return this;
        }

        public Editor putIntArray(String key, int[] value) {
            this.editor.putString(key, gson.toJson((Object)value));
            return this;
        }

        public Editor putIntList(String key, List<Integer> value) {
            this.editor.putString(key, gson.toJson(value));
            return this;
        }

        public Editor putFloatArray(String key, float[] value) {
            this.editor.putString(key, gson.toJson((Object)value));
            return this;
        }

        public Editor putFloatList(String key, List<Float> value) {
            this.editor.putString(key, gson.toJson(value));
            return this;
        }

        public Editor putLongArray(String key, long[] value) {
            this.editor.putString(key, gson.toJson((Object)value));
            return this;
        }

        public Editor putLongList(String key, List<Long> value) {
            this.editor.putString(key, gson.toJson(value));
            return this;
        }

        public Editor remove(String key) {
            this.editor.clear();
            return this;
        }

        public Editor clear() {
            this.editor.clear();
            return this;
        }

        public boolean commit() {
            return this.editor.commit();
        }

        public void apply() {
            this.editor.apply();
        }
    }
}

