/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class KeyDataFactory {
    private static final int FK_FOREIGN_COLUMN_NAME = 8;
    private static final int FK_FOREIGN_TABLE_NAME = 7;
    private static final int FK_FOREIGN_SCHEMA_NAME = 6;
    private static final int FK_NAME = 12;
    private static final int FK_PARENT_COLUMN_NAME = 4;
    private static final int FK_PARENT_TABLE_NAME = 3;
    private static final int FK_PARENT_SCHEMA_NAME = 2;
    private static final int PK_COLUMN_NAME = 4;
    private static final int PK_NAME = 6;
    private final NamingStrategy namingStrategy;
    private final String packageName;
    private final String prefix;
    private final String suffix;
    private final boolean schemaToPackage;

    public KeyDataFactory(NamingStrategy namingStrategy, String packageName, String prefix, String suffix, boolean schemaToPackage) {
        this.namingStrategy = namingStrategy;
        this.packageName = packageName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.schemaToPackage = schemaToPackage;
    }

    public Map<String, InverseForeignKeyData> getExportedKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        try (ResultSet foreignKeys = md.getExportedKeys(catalog, schema, tableName);){
            TreeMap<String, InverseForeignKeyData> inverseForeignKeyData = new TreeMap<String, InverseForeignKeyData>();
            while (foreignKeys.next()) {
                InverseForeignKeyData data;
                String name = foreignKeys.getString(12);
                String parentColumnName = this.namingStrategy.normalizeColumnName(foreignKeys.getString(4));
                String foreignSchemaName = this.namingStrategy.normalizeSchemaName(foreignKeys.getString(6));
                String foreignTableName = this.namingStrategy.normalizeTableName(foreignKeys.getString(7));
                String foreignColumn = this.namingStrategy.normalizeColumnName(foreignKeys.getString(8));
                if (name == null || name.isEmpty()) {
                    name = tableName + "_" + foreignTableName + "_IFK";
                }
                if ((data = (InverseForeignKeyData)inverseForeignKeyData.get(name)) == null) {
                    data = new InverseForeignKeyData(name, foreignSchemaName, foreignTableName, this.createType(foreignSchemaName, foreignTableName));
                    inverseForeignKeyData.put(name, data);
                }
                data.add(parentColumnName, foreignColumn);
            }
            TreeMap<String, InverseForeignKeyData> treeMap = inverseForeignKeyData;
            return treeMap;
        }
    }

    public Map<String, ForeignKeyData> getImportedKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        try (ResultSet foreignKeys = md.getImportedKeys(catalog, schema, tableName);){
            TreeMap<String, ForeignKeyData> foreignKeyData = new TreeMap<String, ForeignKeyData>();
            while (foreignKeys.next()) {
                ForeignKeyData data;
                String name = foreignKeys.getString(12);
                String parentSchemaName = this.namingStrategy.normalizeSchemaName(foreignKeys.getString(2));
                String parentTableName = this.namingStrategy.normalizeTableName(foreignKeys.getString(3));
                String parentColumnName = this.namingStrategy.normalizeColumnName(foreignKeys.getString(4));
                String foreignColumn = this.namingStrategy.normalizeColumnName(foreignKeys.getString(8));
                if (name == null || name.isEmpty()) {
                    name = tableName + "_" + parentTableName + "_FK";
                }
                if ((data = (ForeignKeyData)foreignKeyData.get(name)) == null) {
                    data = new ForeignKeyData(name, parentSchemaName, parentTableName, this.createType(parentSchemaName, parentTableName));
                    foreignKeyData.put(name, data);
                }
                data.add(foreignColumn, parentColumnName);
            }
            TreeMap<String, ForeignKeyData> treeMap = foreignKeyData;
            return treeMap;
        }
    }

    public Map<String, PrimaryKeyData> getPrimaryKeys(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        try (ResultSet primaryKeys = md.getPrimaryKeys(catalog, schema, tableName);){
            TreeMap<String, PrimaryKeyData> primaryKeyData = new TreeMap<String, PrimaryKeyData>();
            while (primaryKeys.next()) {
                PrimaryKeyData data;
                String name = primaryKeys.getString(6);
                String columnName = primaryKeys.getString(4);
                if (name == null || name.isEmpty()) {
                    name = tableName + "_PK";
                }
                if ((data = (PrimaryKeyData)primaryKeyData.get(name)) == null) {
                    data = new PrimaryKeyData(name);
                    primaryKeyData.put(name, data);
                }
                data.add(columnName);
            }
            TreeMap<String, PrimaryKeyData> treeMap = primaryKeyData;
            return treeMap;
        }
    }

    private Type createType(@Nullable String schemaName, String table) {
        SchemaAndTable schemaAndTable = new SchemaAndTable(schemaName, table);
        String packageName = this.packageName;
        if (this.schemaToPackage) {
            packageName = this.namingStrategy.getPackage(packageName, schemaAndTable);
        }
        String simpleName = this.prefix + this.namingStrategy.getClassName(schemaAndTable) + this.suffix;
        return new SimpleType(packageName + "." + simpleName, packageName, simpleName, new Type[0]);
    }
}

