/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.mongodb;

import com.google.common.collect.Sets;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.mongodb.MongodbOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public abstract class MongodbSerializer
implements Visitor<Object, Void> {
    public Object handle(Expression<?> expression) {
        return expression.accept((Visitor)this, null);
    }

    public DBObject toSort(List<OrderSpecifier<?>> orderBys) {
        BasicDBObject sort = new BasicDBObject();
        for (OrderSpecifier<?> orderBy : orderBys) {
            Object key = orderBy.getTarget().accept((Visitor)this, null);
            sort.append(key.toString(), (Object)(orderBy.getOrder() == Order.ASC ? 1 : -1));
        }
        return sort;
    }

    public Object visit(Constant<?> expr, Void context) {
        if (Enum.class.isAssignableFrom(expr.getType())) {
            Constant<?> expectedExpr = expr;
            return ((Enum)expectedExpr.getConstant()).name();
        }
        return expr.getConstant();
    }

    public Object visit(TemplateExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(FactoryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    private String asDBKey(Operation<?> expr, int index) {
        return (String)this.asDBValue(expr, index);
    }

    private Object asDBValue(Operation<?> expr, int index) {
        return expr.getArg(index).accept((Visitor)this, null);
    }

    private String regexValue(Operation<?> expr, int index) {
        return Pattern.quote(expr.getArg(index).accept((Visitor)this, null).toString());
    }

    protected DBObject asDBObject(String key, Object value) {
        return new BasicDBObject(key, value);
    }

    public Object visit(Operation<?> expr, Void context) {
        Operator op = expr.getOperator();
        if (op == Ops.EQ) {
            if (expr.getArg(0) instanceof Operation) {
                Operation lhs = (Operation)expr.getArg(0);
                if (lhs.getOperator() == Ops.COL_SIZE || lhs.getOperator() == Ops.ARRAY_SIZE) {
                    return this.asDBObject(this.asDBKey(lhs, 0), this.asDBObject("$size", this.asDBValue(expr, 1)));
                }
                throw new UnsupportedOperationException("Illegal operation " + expr);
            }
            if (expr.getArg(0) instanceof Path) {
                Path path = (Path)expr.getArg(0);
                Constant constant = (Constant)expr.getArg(1);
                return this.asDBObject(this.asDBKey(expr, 0), this.convert(path, constant));
            }
        } else {
            if (op == Ops.STRING_IS_EMPTY) {
                return this.asDBObject(this.asDBKey(expr, 0), "");
            }
            if (op == Ops.AND) {
                BSONObject lhs = (BSONObject)this.handle(expr.getArg(0));
                BSONObject rhs = (BSONObject)this.handle(expr.getArg(1));
                if (Sets.intersection((Set)lhs.keySet(), (Set)rhs.keySet()).isEmpty()) {
                    lhs.putAll(rhs);
                    return lhs;
                }
                BasicDBList list = new BasicDBList();
                list.add(this.handle(expr.getArg(0)));
                list.add(this.handle(expr.getArg(1)));
                return this.asDBObject("$and", list);
            }
            if (op == Ops.NOT) {
                Operation subOperation = (Operation)expr.getArg(0);
                Operator subOp = subOperation.getOperator();
                if (subOp == Ops.IN) {
                    return this.visit(ExpressionUtils.operation(Boolean.class, (Operator)Ops.NOT_IN, (Expression[])new Expression[]{subOperation.getArg(0), subOperation.getArg(1)}), context);
                }
                BasicDBObject arg = (BasicDBObject)this.handle(expr.getArg(0));
                return this.negate(arg);
            }
            if (op == Ops.OR) {
                BasicDBList list = new BasicDBList();
                list.add(this.handle(expr.getArg(0)));
                list.add(this.handle(expr.getArg(1)));
                return this.asDBObject("$or", list);
            }
            if (op == Ops.NE) {
                Path path = (Path)expr.getArg(0);
                Constant constant = (Constant)expr.getArg(1);
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$ne", this.convert(path, constant)));
            }
            if (op == Ops.STARTS_WITH) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile("^" + this.regexValue(expr, 1)));
            }
            if (op == Ops.STARTS_WITH_IC) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile("^" + this.regexValue(expr, 1), 2));
            }
            if (op == Ops.ENDS_WITH) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.regexValue(expr, 1) + "$"));
            }
            if (op == Ops.ENDS_WITH_IC) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.regexValue(expr, 1) + "$", 2));
            }
            if (op == Ops.EQ_IGNORE_CASE) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile("^" + this.regexValue(expr, 1) + "$", 2));
            }
            if (op == Ops.STRING_CONTAINS) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(".*" + this.regexValue(expr, 1) + ".*"));
            }
            if (op == Ops.STRING_CONTAINS_IC) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(".*" + this.regexValue(expr, 1) + ".*", 2));
            }
            if (op == Ops.MATCHES) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.asDBValue(expr, 1).toString()));
            }
            if (op == Ops.MATCHES_IC) {
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(this.asDBValue(expr, 1).toString(), 2));
            }
            if (op == Ops.LIKE) {
                String regex = ExpressionUtils.likeToRegex((Expression)expr.getArg(1)).toString();
                return this.asDBObject(this.asDBKey(expr, 0), Pattern.compile(regex));
            }
            if (op == Ops.BETWEEN) {
                BasicDBObject value = new BasicDBObject("$gte", this.asDBValue(expr, 1));
                value.append("$lte", this.asDBValue(expr, 2));
                return this.asDBObject(this.asDBKey(expr, 0), value);
            }
            if (op == Ops.IN) {
                int constIndex = 0;
                int exprIndex = 1;
                if (expr.getArg(1) instanceof Constant) {
                    constIndex = 1;
                    exprIndex = 0;
                }
                if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                    Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                    return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$in", values.toArray()));
                }
                Path path = (Path)expr.getArg(exprIndex);
                Constant constant = (Constant)expr.getArg(constIndex);
                return this.asDBObject(this.asDBKey(expr, exprIndex), this.convert(path, constant));
            }
            if (op == Ops.NOT_IN) {
                int constIndex = 0;
                int exprIndex = 1;
                if (expr.getArg(1) instanceof Constant) {
                    constIndex = 1;
                    exprIndex = 0;
                }
                if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                    Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                    return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$nin", values.toArray()));
                }
                Path path = (Path)expr.getArg(exprIndex);
                Constant constant = (Constant)expr.getArg(constIndex);
                return this.asDBObject(this.asDBKey(expr, exprIndex), this.asDBObject("$ne", this.convert(path, constant)));
            }
            if (op == Ops.COL_IS_EMPTY) {
                BasicDBList list = new BasicDBList();
                list.add((Object)this.asDBObject(this.asDBKey(expr, 0), new BasicDBList()));
                list.add((Object)this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$exists", false)));
                return this.asDBObject("$or", list);
            }
            if (op == Ops.LT) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$lt", this.asDBValue(expr, 1)));
            }
            if (op == Ops.GT) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$gt", this.asDBValue(expr, 1)));
            }
            if (op == Ops.LOE) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$lte", this.asDBValue(expr, 1)));
            }
            if (op == Ops.GOE) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$gte", this.asDBValue(expr, 1)));
            }
            if (op == Ops.IS_NULL) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$exists", false));
            }
            if (op == Ops.IS_NOT_NULL) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$exists", true));
            }
            if (op == Ops.CONTAINS_KEY) {
                Path path = (Path)expr.getArg(0);
                Expression key = expr.getArg(1);
                return this.asDBObject(this.visit(path, context) + "." + key.toString(), this.asDBObject("$exists", true));
            }
            if (op == MongodbOps.NEAR) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$near", this.asDBValue(expr, 1)));
            }
            if (op == MongodbOps.NEAR_SPHERE) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$nearSphere", this.asDBValue(expr, 1)));
            }
            if (op == MongodbOps.ELEM_MATCH) {
                return this.asDBObject(this.asDBKey(expr, 0), this.asDBObject("$elemMatch", this.asDBValue(expr, 1)));
            }
        }
        throw new UnsupportedOperationException("Illegal operation " + expr);
    }

    private Object negate(BasicDBObject arg) {
        BasicDBList list = new BasicDBList();
        for (Map.Entry entry : arg.entrySet()) {
            if (((String)entry.getKey()).equals("$or")) {
                list.add((Object)this.asDBObject("$nor", entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equals("$and")) {
                BasicDBList list2 = new BasicDBList();
                for (Object o : (BasicDBList)entry.getValue()) {
                    list2.add(this.negate((BasicDBObject)o));
                }
                list.add((Object)this.asDBObject("$or", list2));
                continue;
            }
            if (entry.getValue() instanceof Pattern) {
                list.add((Object)this.asDBObject((String)entry.getKey(), this.asDBObject("$not", entry.getValue())));
                continue;
            }
            if (entry.getValue() instanceof BasicDBObject) {
                list.add(this.negate((String)entry.getKey(), (BasicDBObject)entry.getValue()));
                continue;
            }
            list.add((Object)this.asDBObject((String)entry.getKey(), this.asDBObject("$ne", entry.getValue())));
        }
        return list.size() == 1 ? list.get(0) : this.asDBObject("$or", list);
    }

    private Object negate(String key, BasicDBObject value) {
        if (value.size() == 1) {
            return this.asDBObject(key, this.asDBObject("$not", value));
        }
        BasicDBList list2 = new BasicDBList();
        for (Map.Entry entry2 : value.entrySet()) {
            list2.add((Object)this.asDBObject(key, this.asDBObject("$not", this.asDBObject((String)entry2.getKey(), entry2.getValue()))));
        }
        return this.asDBObject("$or", list2);
    }

    protected Object convert(Path<?> property, Constant<?> constant) {
        if (this.isReference(property)) {
            return this.asReference(constant.getConstant());
        }
        if (this.isId(property)) {
            if (this.isReference(property.getMetadata().getParent())) {
                return this.asReferenceKey(property.getMetadata().getParent().getType(), constant.getConstant());
            }
            if (constant.getType().equals(String.class) && this.isImplicitObjectIdConversion()) {
                String id = (String)constant.getConstant();
                return ObjectId.isValid((String)id) ? new ObjectId(id) : id;
            }
        }
        return this.visit(constant, null);
    }

    protected boolean isImplicitObjectIdConversion() {
        return true;
    }

    protected DBRef asReferenceKey(Class<?> entity, Object id) {
        throw new UnsupportedOperationException();
    }

    protected abstract DBRef asReference(Object var1);

    protected abstract boolean isReference(Path<?> var1);

    protected boolean isId(Path<?> arg) {
        return false;
    }

    public String visit(Path<?> expr, Void context) {
        PathMetadata metadata = expr.getMetadata();
        if (metadata.getParent() != null) {
            Path parent = metadata.getParent();
            if (parent.getMetadata().getPathType() == PathType.DELEGATE) {
                parent = parent.getMetadata().getParent();
            }
            if (metadata.getPathType() == PathType.COLLECTION_ANY) {
                return this.visit(parent, context);
            }
            if (parent.getMetadata().getPathType() != PathType.VARIABLE) {
                String rv = this.getKeyForPath(expr, metadata);
                String parentStr = this.visit(parent, context);
                return rv != null ? parentStr + "." + rv : parentStr;
            }
        }
        return this.getKeyForPath(expr, metadata);
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        return metadata.getElement().toString();
    }

    public Object visit(SubQueryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(ParamExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }
}

