/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.support;

import com.google.common.primitives.Primitives;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;

public class JPAPathBuilderValidator
implements PathBuilderValidator {
    private final Metamodel metamodel;

    public JPAPathBuilderValidator(EntityManager entityManager) {
        this.metamodel = entityManager.getMetamodel();
    }

    public JPAPathBuilderValidator(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    public Class<?> validate(Class<?> parent, String property, Class<?> propertyType) {
        try {
            ManagedType managedType = this.metamodel.managedType(parent);
            Attribute attribute = managedType.getAttribute(property);
            if (attribute instanceof PluralAttribute) {
                return ((PluralAttribute)attribute).getElementType().getJavaType();
            }
            return Primitives.wrap((Class)attribute.getJavaType());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

