/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPAQueryBase;
import com.querydsl.jpa.JPQLQueryFactory;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.hibernate.HibernateDeleteClause;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.HibernateUpdateClause;
import javax.inject.Provider;
import org.hibernate.Session;

public class HibernateQueryFactory
implements JPQLQueryFactory {
    private final JPQLTemplates templates;
    private final Provider<Session> session;

    public HibernateQueryFactory(Session session) {
        this((JPQLTemplates)HQLTemplates.DEFAULT, session);
    }

    public HibernateQueryFactory(JPQLTemplates templates, final Session session) {
        this.session = new Provider<Session>(){

            public Session get() {
                return session;
            }
        };
        this.templates = templates;
    }

    public HibernateQueryFactory(Provider<Session> session) {
        this((JPQLTemplates)HQLTemplates.DEFAULT, session);
    }

    public HibernateQueryFactory(JPQLTemplates templates, Provider<Session> session) {
        this.session = session;
        this.templates = templates;
    }

    public HibernateDeleteClause delete(EntityPath<?> path) {
        return new HibernateDeleteClause((Session)this.session.get(), path, this.templates);
    }

    public <T> HibernateQuery<T> select(Expression<T> expr) {
        return this.query().select((Expression)expr);
    }

    public HibernateQuery<Tuple> select(Expression<?> ... exprs) {
        return this.query().select((Expression[])exprs);
    }

    public <T> HibernateQuery<T> selectDistinct(Expression<T> expr) {
        return (HibernateQuery)this.select((Expression)expr).distinct();
    }

    public HibernateQuery<Tuple> selectDistinct(Expression<?> ... exprs) {
        return (HibernateQuery)this.select((Expression[])exprs).distinct();
    }

    public HibernateQuery<Integer> selectOne() {
        return this.select((Expression)Expressions.ONE);
    }

    public HibernateQuery<Integer> selectZero() {
        return this.select((Expression)Expressions.ZERO);
    }

    public <T> HibernateQuery<T> selectFrom(EntityPath<T> from) {
        return (HibernateQuery)((JPAQueryBase)this.select((Expression)from)).from((EntityPath<?>)from);
    }

    public HibernateQuery<?> from(EntityPath<?> from) {
        return (HibernateQuery)this.query().from(from);
    }

    public HibernateQuery<?> from(EntityPath<?> ... from) {
        return (HibernateQuery)this.query().from((EntityPath[])from);
    }

    public HibernateUpdateClause update(EntityPath<?> path) {
        return new HibernateUpdateClause((Session)this.session.get(), path, this.templates);
    }

    public HibernateQuery<?> query() {
        return new HibernateQuery((Session)this.session.get(), this.templates);
    }
}

