/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.codegen;

import com.querydsl.codegen.Property;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.jpa.codegen.AbstractDomainExporter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Temporal;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.xml.stream.XMLStreamException;
import org.hibernate.MappingException;

public class JPADomainExporter
extends AbstractDomainExporter {
    private final Metamodel metamodel;

    public JPADomainExporter(File targetFolder, Metamodel metamodel) {
        this("Q", "", targetFolder, SimpleSerializerConfig.DEFAULT, metamodel, Charset.defaultCharset());
    }

    public JPADomainExporter(String namePrefix, File targetFolder, Metamodel metamodel) {
        this(namePrefix, "", targetFolder, SimpleSerializerConfig.DEFAULT, metamodel, Charset.defaultCharset());
    }

    public JPADomainExporter(String namePrefix, File targetFolder, Metamodel metamodel, Charset charset) {
        this(namePrefix, "", targetFolder, SimpleSerializerConfig.DEFAULT, metamodel, charset);
    }

    public JPADomainExporter(String namePrefix, String nameSuffix, File targetFolder, Metamodel metamodel) {
        this(namePrefix, nameSuffix, targetFolder, SimpleSerializerConfig.DEFAULT, metamodel, Charset.defaultCharset());
    }

    public JPADomainExporter(String namePrefix, File targetFolder, SerializerConfig serializerConfig, Metamodel metamodel) {
        this(namePrefix, "", targetFolder, serializerConfig, metamodel, Charset.defaultCharset());
    }

    public JPADomainExporter(String namePrefix, File targetFolder, SerializerConfig serializerConfig, Metamodel metamodel, Charset charset) {
        this(namePrefix, "", targetFolder, serializerConfig, metamodel, charset);
    }

    public JPADomainExporter(String namePrefix, String nameSuffix, File targetFolder, SerializerConfig serializerConfig, Metamodel metamodel, Charset charset) {
        super(namePrefix, nameSuffix, targetFolder, serializerConfig, charset);
        this.metamodel = metamodel;
    }

    @Override
    protected void collectTypes() throws IOException, XMLStreamException, ClassNotFoundException, NoSuchMethodException {
        HashMap<ManagedType, com.querydsl.codegen.EntityType> types = new HashMap<ManagedType, com.querydsl.codegen.EntityType>();
        for (ManagedType managedType : this.metamodel.getManagedTypes()) {
            if (managedType instanceof MappedSuperclassType) {
                types.put(managedType, this.createSuperType(managedType.getJavaType()));
                continue;
            }
            if (managedType instanceof EntityType) {
                types.put(managedType, this.createEntityType(managedType.getJavaType()));
                continue;
            }
            if (managedType instanceof EmbeddableType) {
                types.put(managedType, this.createEmbeddableType(managedType.getJavaType()));
                continue;
            }
            throw new IllegalArgumentException("Unknown type " + managedType);
        }
        for (Map.Entry entry : types.entrySet()) {
            com.querydsl.codegen.EntityType entityType = (com.querydsl.codegen.EntityType)entry.getValue();
            for (Attribute attribute : ((ManagedType)entry.getKey()).getDeclaredAttributes()) {
                this.handleProperty(entityType, entityType.getJavaClass(), attribute);
            }
        }
    }

    private void handleProperty(com.querydsl.codegen.EntityType entityType, Class<?> cl, Attribute<?, ?> p) throws NoSuchMethodException, ClassNotFoundException {
        Class clazz = Object.class;
        try {
            clazz = p.getJavaType();
        }
        catch (MappingException mappingException) {
            // empty catch block
        }
        Type propertyType = this.getType(cl, clazz, p.getName());
        AnnotatedElement annotated = this.getAnnotatedElement(cl, p.getName());
        propertyType = this.getTypeOverride(propertyType, annotated);
        if (propertyType == null) {
            return;
        }
        if (p.isCollection()) {
            if (p instanceof MapAttribute) {
                MapAttribute map = (MapAttribute)p;
                Type keyType = this.typeFactory.get(map.getKeyJavaType());
                Type valueType = this.typeFactory.get(map.getElementType().getJavaType());
                valueType = this.getPropertyType(p, valueType);
                propertyType = new SimpleType(propertyType, new Type[]{this.normalize((Type)propertyType.getParameters().get(0), keyType), this.normalize((Type)propertyType.getParameters().get(1), valueType)});
            } else {
                Type valueType = this.typeFactory.get(((PluralAttribute)p).getElementType().getJavaType());
                valueType = this.getPropertyType(p, valueType);
                propertyType = new SimpleType(propertyType, new Type[]{this.normalize((Type)propertyType.getParameters().get(0), valueType)});
            }
        } else {
            propertyType = this.getPropertyType(p, propertyType);
        }
        Property property = this.createProperty(entityType, p.getName(), propertyType, annotated);
        entityType.addProperty(property);
    }

    private Type getPropertyType(Attribute<?, ?> p, Type propertyType) {
        Temporal temporal = ((AnnotatedElement)((Object)p.getJavaMember())).getAnnotation(Temporal.class);
        if (temporal != null) {
            switch (temporal.value()) {
                case DATE: {
                    propertyType = propertyType.as(TypeCategory.DATE);
                    break;
                }
                case TIME: {
                    propertyType = propertyType.as(TypeCategory.TIME);
                    break;
                }
                case TIMESTAMP: {
                    propertyType = propertyType.as(TypeCategory.DATETIME);
                }
            }
        }
        return propertyType;
    }
}

