/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jdo.dml;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jdo.JDOQLSerializer;
import com.querydsl.jdo.JDOQLTemplates;
import java.util.ArrayList;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class JDODeleteClause
implements DeleteClause<JDODeleteClause> {
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final PersistenceManager persistenceManager;
    private final JDOQLTemplates templates;
    private final EntityPath<?> entity;

    public JDODeleteClause(PersistenceManager pm, EntityPath<?> entity) {
        this(pm, entity, JDOQLTemplates.DEFAULT);
    }

    public JDODeleteClause(PersistenceManager persistenceManager, EntityPath<?> entity, JDOQLTemplates templates) {
        this.entity = entity;
        this.persistenceManager = persistenceManager;
        this.templates = templates;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute() {
        Query query = this.persistenceManager.newQuery(this.entity.getType());
        if (this.metadata.getWhere() != null) {
            JDOQLSerializer serializer = new JDOQLSerializer(this.templates, (Expression<?>)this.entity);
            serializer.handle((Expression)this.metadata.getWhere());
            query.setFilter(serializer.toString());
            Map<Object, String> constToLabel = serializer.getConstantToLabel();
            try {
                if (!constToLabel.isEmpty()) {
                    ArrayList<Object> constants = new ArrayList<Object>(constToLabel.size());
                    StringBuilder builder = new StringBuilder();
                    for (Map.Entry<Object, String> entry : constToLabel.entrySet()) {
                        if (builder.length() > 0) {
                            builder.append(", ");
                        }
                        builder.append(entry.getKey().getClass().getName()).append(" ");
                        builder.append(entry.getValue());
                        constants.add(entry.getKey());
                    }
                    query.declareParameters(builder.toString());
                    long l = query.deletePersistentAll(constants.toArray());
                    return l;
                }
                long l = query.deletePersistentAll();
                return l;
            }
            finally {
                query.closeAll();
            }
        }
        try {
            long l = query.deletePersistentAll();
            return l;
        }
        finally {
            query.closeAll();
        }
    }

    public JDODeleteClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.metadata.addWhere(p);
        }
        return this;
    }

    public String toString() {
        JDOQLSerializer serializer = new JDOQLSerializer(this.templates, (Expression<?>)this.entity);
        serializer.handle((Expression)this.metadata.getWhere());
        return serializer.toString();
    }
}

