/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group.guava;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.group.AbstractGroupExpression;
import com.querydsl.core.group.GroupCollector;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.QPair;
import com.querydsl.core.types.Expression;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

abstract class GTable<R, C, V, M extends Table<R, C, V>>
extends AbstractGroupExpression<Pair<Pair<R, C>, V>, M> {
    private static final long serialVersionUID = 7106389414200843920L;

    GTable(QPair<Pair<R, C>, V> qpair) {
        super(Table.class, qpair);
    }

    protected abstract M createTable();

    public static <T, U, W> GTable<T, U, W, Table<T, U, W>> create(QPair<Pair<T, U>, W> expr) {
        return new GTable<T, U, W, Table<T, U, W>>((QPair)expr){

            @Override
            protected Table<T, U, W> createTable() {
                return HashBasedTable.create();
            }
        };
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>, W> GTable<T, U, W, TreeBasedTable<T, U, W>> createSorted(QPair<Pair<T, U>, W> expr) {
        return new GTable<T, U, W, TreeBasedTable<T, U, W>>((QPair)expr){

            @Override
            protected TreeBasedTable<T, U, W> createTable() {
                return TreeBasedTable.create();
            }
        };
    }

    public static <T, U, W> GTable<T, U, W, TreeBasedTable<T, U, W>> createSorted(QPair<Pair<T, U>, W> expr, final Comparator<? super T> rowComparator, final Comparator<? super U> columnComparator) {
        return new GTable<T, U, W, TreeBasedTable<T, U, W>>(expr){

            @Override
            protected TreeBasedTable<T, U, W> createTable() {
                return TreeBasedTable.create((Comparator)rowComparator, (Comparator)columnComparator);
            }
        };
    }

    public GroupCollector<Pair<Pair<R, C>, V>, M> createGroupCollector() {
        return new GroupCollector<Pair<Pair<R, C>, V>, M>(){
            private final M table;
            {
                this.table = GTable.this.createTable();
            }

            public void add(Pair<Pair<R, C>, V> pair) {
                this.table.put(((Pair)pair.getFirst()).getFirst(), ((Pair)pair.getFirst()).getSecond(), pair.getSecond());
            }

            public M get() {
                return this.table;
            }
        };
    }

    static class Mixin<R, C, V, T, U, W, RES extends Table<? super T, ? super U, ? super W>>
    extends AbstractGroupExpression<Pair<Pair<R, C>, V>, RES> {
        private static final long serialVersionUID = 1939989270493531116L;
        private final GroupExpression<Pair<Pair<T, U>, W>, RES> mixin;
        private final GroupExpression<R, T> rowExpression;
        private final GroupExpression<C, U> columnExpression;
        private final GroupExpression<V, W> valueExpression;

        Mixin(GroupExpression<R, T> rowExpression, GroupExpression<C, U> columnExpression, GroupExpression<V, W> valueExpression, AbstractGroupExpression<Pair<Pair<T, U>, W>, RES> mixin) {
            super(mixin.getType(), (Expression)QPair.create((Expression)QPair.create((Expression)rowExpression.getExpression(), (Expression)columnExpression.getExpression()), (Expression)valueExpression.getExpression()));
            this.rowExpression = rowExpression;
            this.columnExpression = columnExpression;
            this.valueExpression = valueExpression;
            this.mixin = mixin;
        }

        public GroupCollector<Pair<Pair<R, C>, V>, RES> createGroupCollector() {
            return new GroupCollectorImpl();
        }

        private class GroupCollectorImpl
        implements GroupCollector<Pair<Pair<R, C>, V>, RES> {
            private final GroupCollector<Pair<Pair<T, U>, W>, RES> groupCollector;
            private final Table<R, C, GroupCollector<R, T>> rowCollectors = HashBasedTable.create();
            private final Map<GroupCollector<R, T>, GroupCollector<C, U>> columnCollectors = new HashMap();
            private final Map<GroupCollector<C, U>, GroupCollector<V, W>> valueCollectors = new HashMap();

            GroupCollectorImpl() {
                this.groupCollector = Mixin.this.mixin.createGroupCollector();
            }

            public void add(Pair<Pair<R, C>, V> pair) {
                Object columnKey;
                Pair first = (Pair)pair.getFirst();
                Object rowKey = first.getFirst();
                GroupCollector rowCollector = (GroupCollector)this.rowCollectors.get(rowKey, columnKey = first.getSecond());
                if (rowCollector == null) {
                    rowCollector = Mixin.this.rowExpression.createGroupCollector();
                    this.rowCollectors.put(rowKey, columnKey, (Object)rowCollector);
                }
                rowCollector.add(rowKey);
                GroupCollector columnCollector = this.columnCollectors.get(rowCollector);
                if (columnCollector == null) {
                    columnCollector = Mixin.this.columnExpression.createGroupCollector();
                    this.columnCollectors.put(rowCollector, columnCollector);
                }
                columnCollector.add(columnKey);
                GroupCollector valueCollector = this.valueCollectors.get(columnCollector);
                if (valueCollector == null) {
                    valueCollector = Mixin.this.valueExpression.createGroupCollector();
                    this.valueCollectors.put(columnCollector, valueCollector);
                }
                Object second = pair.getSecond();
                valueCollector.add(second);
            }

            public RES get() {
                for (GroupCollector rowCollector : this.rowCollectors.values()) {
                    Object rowKey = rowCollector.get();
                    GroupCollector columnCollector = this.columnCollectors.get(rowCollector);
                    Object columnKey = columnCollector.get();
                    GroupCollector valueCollector = this.valueCollectors.get(columnCollector);
                    Object value = valueCollector.get();
                    this.groupCollector.add((Object)Pair.of((Object)Pair.of((Object)rowKey, (Object)columnKey), (Object)value));
                }
                return (Table)this.groupCollector.get();
            }
        }
    }
}

