/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group.guava;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.group.AbstractGroupExpression;
import com.querydsl.core.group.GroupCollector;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.QPair;
import com.querydsl.core.types.Expression;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class GMultimap<K, V, M extends Multimap<K, V>>
extends AbstractGroupExpression<Pair<K, V>, M> {
    private static final long serialVersionUID = 7106389414200843920L;

    GMultimap(QPair<K, V> qpair) {
        super(Multimap.class, qpair);
    }

    protected abstract M createMap();

    public static <T, U> GMultimap<T, U, Multimap<T, U>> createLinked(QPair<T, U> expr) {
        return new GMultimap<T, U, Multimap<T, U>>((QPair)expr){

            @Override
            protected Multimap<T, U> createMap() {
                return LinkedHashMultimap.create();
            }
        };
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> GMultimap<T, U, SortedSetMultimap<T, U>> createSorted(QPair<T, U> expr) {
        return new GMultimap<T, U, SortedSetMultimap<T, U>>((QPair)expr){

            @Override
            protected SortedSetMultimap<T, U> createMap() {
                return TreeMultimap.create();
            }
        };
    }

    public static <T, U> GMultimap<T, U, SortedSetMultimap<T, U>> createSorted(QPair<T, U> expr, final Comparator<? super T> comparator, final Comparator<? super U> comparator2) {
        return new GMultimap<T, U, SortedSetMultimap<T, U>>(expr){

            @Override
            protected SortedSetMultimap<T, U> createMap() {
                return TreeMultimap.create((Comparator)comparator, (Comparator)comparator2);
            }
        };
    }

    public GroupCollector<Pair<K, V>, M> createGroupCollector() {
        return new GroupCollector<Pair<K, V>, M>(){
            private final M map;
            {
                this.map = GMultimap.this.createMap();
            }

            public void add(Pair<K, V> pair) {
                this.map.put(pair.getFirst(), pair.getSecond());
            }

            public M get() {
                return this.map;
            }
        };
    }

    static class Mixin<K, V, T, U, R extends Multimap<? super T, ? super U>>
    extends AbstractGroupExpression<Pair<K, V>, R> {
        private static final long serialVersionUID = 1939989270493531116L;
        private final GroupExpression<Pair<T, U>, R> mixin;
        private final GroupExpression<K, T> keyExpression;
        private final GroupExpression<V, U> valueExpression;

        Mixin(GroupExpression<K, T> keyExpression, GroupExpression<V, U> valueExpression, AbstractGroupExpression<Pair<T, U>, R> mixin) {
            super(mixin.getType(), (Expression)QPair.create((Expression)keyExpression.getExpression(), (Expression)valueExpression.getExpression()));
            this.keyExpression = keyExpression;
            this.valueExpression = valueExpression;
            this.mixin = mixin;
        }

        public GroupCollector<Pair<K, V>, R> createGroupCollector() {
            return new GroupCollectorImpl();
        }

        private class GroupCollectorImpl
        implements GroupCollector<Pair<K, V>, R> {
            private final GroupCollector<Pair<T, U>, R> groupCollector;
            private final Map<K, GroupCollector<K, T>> keyCollectors = new LinkedHashMap();
            private final Map<GroupCollector<K, T>, GroupCollector<V, U>> valueCollectors = new HashMap();

            GroupCollectorImpl() {
                this.groupCollector = Mixin.this.mixin.createGroupCollector();
            }

            public void add(Pair<K, V> pair) {
                Object first = pair.getFirst();
                GroupCollector keyCollector = this.keyCollectors.get(first);
                if (keyCollector == null) {
                    keyCollector = Mixin.this.keyExpression.createGroupCollector();
                    this.keyCollectors.put(first, keyCollector);
                }
                keyCollector.add(first);
                GroupCollector valueCollector = this.valueCollectors.get(keyCollector);
                if (valueCollector == null) {
                    valueCollector = Mixin.this.valueExpression.createGroupCollector();
                    this.valueCollectors.put(keyCollector, valueCollector);
                }
                Object second = pair.getSecond();
                valueCollector.add(second);
            }

            public R get() {
                for (GroupCollector keyCollector : this.keyCollectors.values()) {
                    Object key = keyCollector.get();
                    GroupCollector valueCollector = this.valueCollectors.remove(keyCollector);
                    Object value = valueCollector.get();
                    this.groupCollector.add((Object)Pair.of((Object)key, (Object)value));
                }
                this.keyCollectors.clear();
                return (Multimap)this.groupCollector.get();
            }
        }
    }
}

