/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.domain.QCat;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import org.junit.Assert;
import org.junit.Test;

public class ToStringVisitorTest {
    private Templates templates = new Templates(){
        {
            this.add((Operator)PathType.PROPERTY, "{0}_{1}");
            this.add((Operator)PathType.COLLECTION_ANY, "{0}");
        }
    };

    @Test
    public void operation() {
        Assert.assertEquals((Object)"cat_name is not null", (Object)QCat.cat.name.isNotNull().accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates));
    }

    @Test
    public void template() {
        TemplateExpression template = ExpressionUtils.template(Boolean.class, (String)"{0} is not null", (Object[])new Object[]{QCat.cat.name});
        Assert.assertEquals((Object)"cat_name is not null", (Object)template.accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates));
    }

    @Test
    public void path() {
        Assert.assertEquals((Object)"cat_kittens_kittens_name", (Object)((QCat)((QCat)QCat.cat.kittens.any()).kittens.any()).name.accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates));
    }

    @Test
    public void complex() {
        BooleanPath a = Expressions.booleanPath((String)"a");
        BooleanPath b = Expressions.booleanPath((String)"d");
        BooleanPath c = Expressions.booleanPath((String)"c");
        BooleanPath d = Expressions.booleanPath((String)"d");
        BooleanExpression complex = a.or((Predicate)b).and((Predicate)c.or((Predicate)d));
        Assert.assertEquals((Object)"(a || d) && (c || d)", (Object)complex.accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates));
    }
}

