/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.QueryModifiers;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class QueryModifiersTest {
    @Test
    public void limit() {
        QueryModifiers modifiers = QueryModifiers.limit((long)12L);
        Assert.assertEquals((Object)12L, (Object)modifiers.getLimit());
        Assert.assertNull((Object)modifiers.getOffset());
        Assert.assertTrue((boolean)modifiers.isRestricting());
    }

    @Test
    public void offset() {
        QueryModifiers modifiers = QueryModifiers.offset((long)12L);
        Assert.assertEquals((Object)12L, (Object)modifiers.getOffset());
        Assert.assertNull((Object)modifiers.getLimit());
        Assert.assertTrue((boolean)modifiers.isRestricting());
    }

    @Test
    public void both() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        Assert.assertEquals((Object)1L, (Object)modifiers.getLimit());
        Assert.assertEquals((Object)2L, (Object)modifiers.getOffset());
        Assert.assertTrue((boolean)modifiers.isRestricting());
    }

    @Test
    public void empty() {
        QueryModifiers modifiers = new QueryModifiers(null, null);
        Assert.assertNull((Object)modifiers.getLimit());
        Assert.assertNull((Object)modifiers.getOffset());
        Assert.assertFalse((boolean)modifiers.isRestricting());
    }

    @Test
    public void hashCode_() {
        QueryModifiers modifiers1 = new QueryModifiers(null, null);
        QueryModifiers modifiers2 = new QueryModifiers(Long.valueOf(1L), null);
        QueryModifiers modifiers3 = new QueryModifiers(null, Long.valueOf(1L));
        Assert.assertEquals((long)modifiers1.hashCode(), (long)QueryModifiers.EMPTY.hashCode());
        Assert.assertEquals((long)modifiers2.hashCode(), (long)QueryModifiers.limit((long)1L).hashCode());
        Assert.assertEquals((long)modifiers3.hashCode(), (long)QueryModifiers.offset((long)1L).hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalLimit() {
        QueryModifiers.limit((long)-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalOffset() {
        QueryModifiers.offset((long)-1L);
    }

    @Test
    public void subList() {
        List<Integer> ints = Arrays.asList(1, 2, 3, 4, 5);
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)QueryModifiers.offset((long)2L).subList(ints));
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)QueryModifiers.limit((long)3L).subList(ints));
        Assert.assertEquals(Arrays.asList(2, 3, 4), (Object)new QueryModifiers(Long.valueOf(3L), Long.valueOf(1L)).subList(ints));
    }
}

