/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.BooleanConstant;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.util.MathUtils;

final class NumberConstant<D extends Number>
extends NumberExpression<D>
implements Constant<D> {
    private static final long serialVersionUID = 2958824808974260439L;
    private final D constant;

    public static <T extends Number> NumberExpression<T> create(T val) {
        return new NumberConstant(val.getClass(), val);
    }

    NumberConstant(Class<? extends D> type, D constant) {
        super((Expression)ConstantImpl.create(constant));
        this.constant = constant;
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((Constant)this, context);
    }

    public BooleanExpression eq(D b) {
        return BooleanConstant.create(this.constant.equals(b));
    }

    public D getConstant() {
        return this.constant;
    }

    public BooleanExpression ne(D b) {
        return BooleanConstant.create(!this.constant.equals(b));
    }

    public NumberExpression<D> add(Number right) {
        return NumberConstant.create(MathUtils.sum(this.constant, (Number)right));
    }

    public <N extends Number> NumberExpression<D> add(Expression<N> right) {
        if (right instanceof Constant) {
            return this.add((Number)((Constant)right).getConstant());
        }
        return super.add(right);
    }

    public NumberExpression<D> subtract(Number right) {
        return NumberConstant.create(MathUtils.difference(this.constant, (Number)right));
    }

    public <N extends Number> NumberExpression<D> subtract(Expression<N> right) {
        if (right instanceof Constant) {
            return this.subtract((Number)((Constant)right).getConstant());
        }
        return super.subtract(right);
    }

    public NumberExpression<Byte> byteValue() {
        return NumberConstant.create(((Number)this.constant).byteValue());
    }

    public NumberExpression<Double> doubleValue() {
        return NumberConstant.create(((Number)this.constant).doubleValue());
    }

    public NumberExpression<Float> floatValue() {
        return NumberConstant.create(Float.valueOf(((Number)this.constant).floatValue()));
    }

    public NumberExpression<Long> longValue() {
        return NumberConstant.create(((Number)this.constant).longValue());
    }

    public NumberExpression<Short> shortValue() {
        return NumberConstant.create(((Number)this.constant).shortValue());
    }
}

