/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class DefaultQueryMetadataTest {
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final StringPath str = Expressions.stringPath((String)"str");
    private final StringPath str2 = Expressions.stringPath((String)"str2");

    public DefaultQueryMetadataTest() {
        this.metadata.setValidate(true);
    }

    @Test
    public void addWhere_with_null() {
        this.metadata.addWhere(null);
    }

    @Test
    public void addWhere_with_booleanBuilder() {
        this.metadata.addWhere((Predicate)new BooleanBuilder());
    }

    @Test
    public void addHaving_with_null() {
        this.metadata.addHaving(null);
    }

    @Test
    public void addHaving_with_booleanBuilder() {
        this.metadata.addHaving((Predicate)new BooleanBuilder());
    }

    @Test(expected=IllegalArgumentException.class)
    public void validation() {
        this.metadata.addWhere((Predicate)this.str.isNull());
    }

    @Test
    public void validation_no_error_for_groupBy() {
        this.metadata.addGroupBy((Expression)this.str);
    }

    @Test
    public void validation_no_error_for_having() {
        this.metadata.addHaving((Predicate)this.str.isNull());
    }

    @Test
    public void getGroupBy() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        Assert.assertEquals(Collections.singletonList(this.str), (Object)this.metadata.getGroupBy());
    }

    @Test
    public void getHaving() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        Assert.assertEquals((Object)this.str.isNotNull(), (Object)this.metadata.getHaving());
    }

    @Test
    public void getJoins() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str)), (Object)this.metadata.getJoins());
    }

    @Test
    public void getJoins2() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str)), (Object)this.metadata.getJoins());
    }

    @Test
    public void getJoins3() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str)), (Object)this.metadata.getJoins());
        this.metadata.addJoinCondition((Predicate)this.str.isNull());
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str, (Predicate)this.str.isNull(), Collections.emptySet())), (Object)this.metadata.getJoins());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str, (Predicate)this.str.isNull(), Collections.emptySet()), new JoinExpression(JoinType.DEFAULT, (Expression)this.str2)), (Object)this.metadata.getJoins());
    }

    @Test
    public void getModifiers() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        Assert.assertEquals((Object)modifiers, (Object)this.metadata.getModifiers());
    }

    @Test
    public void setLimit() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.setLimit(Long.valueOf(3L));
        Assert.assertEquals((Object)3L, (Object)this.metadata.getModifiers().getLimit());
        Assert.assertEquals((Object)2L, (Object)this.metadata.getModifiers().getOffset());
    }

    @Test
    public void setOffset() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(1L));
        this.metadata.setModifiers(modifiers);
        this.metadata.setOffset(Long.valueOf(2L));
        Assert.assertEquals((Object)1L, (Object)this.metadata.getModifiers().getLimit());
        Assert.assertEquals((Object)2L, (Object)this.metadata.getModifiers().getOffset());
    }

    @Test
    public void getOrderBy() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.addOrderBy(this.str.desc());
        Assert.assertEquals(Arrays.asList(this.str.asc(), this.str.desc()), (Object)this.metadata.getOrderBy());
    }

    @Test
    public void getProjection() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.setProjection((Expression)this.str.append("abc"));
        Assert.assertEquals((Object)this.str.append("abc"), (Object)this.metadata.getProjection());
    }

    @Test
    public void getWhere() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        Assert.assertEquals((Object)this.str.eq((Object)"b").and((Predicate)this.str.isNotEmpty()), (Object)this.metadata.getWhere());
    }

    @Test
    public void isDistinct() {
        Assert.assertFalse((boolean)this.metadata.isDistinct());
        this.metadata.setDistinct(true);
        Assert.assertTrue((boolean)this.metadata.isDistinct());
    }

    @Test
    public void isUnique() {
        Assert.assertFalse((boolean)this.metadata.isUnique());
        this.metadata.setUnique(true);
        Assert.assertTrue((boolean)this.metadata.isUnique());
    }

    @Test
    public void joinShouldBeCommitted() {
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)this.str);
        DefaultQueryMetadata emptyMetadata = new DefaultQueryMetadata();
        Assert.assertFalse((boolean)md.equals((Object)emptyMetadata));
    }

    @Test
    public void clone_() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.setProjection((Expression)this.str.append("abc"));
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        QueryMetadata clone = this.metadata.clone();
        Assert.assertEquals((Object)this.metadata.getGroupBy(), (Object)clone.getGroupBy());
        Assert.assertEquals((Object)this.metadata.getHaving(), (Object)clone.getHaving());
        Assert.assertEquals((Object)this.metadata.getJoins(), (Object)clone.getJoins());
        Assert.assertEquals((Object)this.metadata.getModifiers(), (Object)clone.getModifiers());
        Assert.assertEquals((Object)this.metadata.getOrderBy(), (Object)clone.getOrderBy());
        Assert.assertEquals((Object)this.metadata.getProjection(), (Object)clone.getProjection());
        Assert.assertEquals((Object)this.metadata.getWhere(), (Object)clone.getWhere());
    }

    @Test
    public void setParam() {
        this.metadata.setParam((ParamExpression)new Param(String.class, "str"), (Object)ConstantImpl.create((Object)"X"));
        Assert.assertEquals((long)1L, (long)this.metadata.getParams().size());
        Assert.assertTrue((boolean)this.metadata.getParams().get(new Param(String.class, "str")).equals(ConstantImpl.create((Object)"X")));
    }

    @Test
    public void addFlag() {
        QueryFlag flag = new QueryFlag(QueryFlag.Position.START, "X");
        this.metadata.addFlag(flag);
        Assert.assertTrue((boolean)this.metadata.hasFlag(flag));
    }

    @Test
    public void equals() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.setProjection((Expression)this.str.append("abc"));
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        DefaultQueryMetadata metadata2 = new DefaultQueryMetadata();
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.addGroupBy((Expression)this.str);
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.addHaving((Predicate)this.str.isNotNull());
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.setModifiers(modifiers);
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.addOrderBy(this.str.asc());
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.setProjection((Expression)this.str.append("abc"));
        Assert.assertFalse((boolean)this.metadata.equals(metadata2));
        metadata2.addWhere((Predicate)this.str.eq((Object)"b"));
        metadata2.addWhere((Predicate)this.str.isNotEmpty());
        Assert.assertTrue((boolean)this.metadata.equals(metadata2));
    }

    @Test
    public void hashCode_() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.setProjection((Expression)this.str.append("abc"));
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        this.metadata.hashCode();
    }

    @Test
    public void hashCode_empty_metadata() {
        this.metadata.hashCode();
    }
}

