/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.testutil.ThreadSafety;
import io.github.classgraph.ClassGraph;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class CycleClassInitDependencyTest {
    private static ClassLoader loader;

    @BeforeClass
    public static void overrideClassLoader() {
        loader = Thread.currentThread().getContextClassLoader();
        List urls = new ClassGraph().getClasspathURLs();
        URLClassLoader cl = URLClassLoader.newInstance(urls.toArray(new URL[0]), null);
        Thread.currentThread().setContextClassLoader(cl);
    }

    @AfterClass
    public static void resetClassLoader() {
        Thread.currentThread().setContextClassLoader(loader);
    }

    @Test(timeout=2000L)
    public void test() {
        ThreadSafety.check(new LoadClassRunnable("com.querydsl.core.types.dsl.NumberExpression"), new LoadClassRunnable("com.querydsl.core.types.dsl.Expressions"));
    }

    private static class LoadClassRunnable
    implements Runnable {
        private final String classToLoad;

        LoadClassRunnable(String classToLoad) {
            this.classToLoad = classToLoad;
        }

        @Override
        public void run() {
            try {
                Class.forName(this.classToLoad, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

