/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.BooleanConstant;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BooleanBuilderTest {
    private final BooleanExpression first = BooleanConstant.TRUE;
    private final BooleanExpression second = BooleanConstant.FALSE;

    @Test
    public void null_in_constructor() {
        Assert.assertNull((Object)new BooleanBuilder(null).getValue());
    }

    @Test
    public void and_empty() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)new BooleanBuilder());
        Assert.assertNull((Object)ExpressionUtils.extract((Expression)builder));
    }

    @Test
    public void and_any_of() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.andAnyOf(new Predicate[]{this.first, null});
        Assert.assertEquals((Object)this.first, (Object)builder.getValue());
    }

    @Test
    public void and_any_of2() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.andAnyOf(new Predicate[]{null, this.first});
        Assert.assertEquals((Object)this.first, (Object)builder.getValue());
    }

    @Test
    public void or_all_of() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.orAllOf(new Predicate[]{this.first, null});
        Assert.assertEquals((Object)this.first, (Object)builder.getValue());
    }

    @Test
    public void or_all_of2() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.orAllOf(new Predicate[]{null, this.first});
        Assert.assertEquals((Object)this.first, (Object)builder.getValue());
    }

    @Test(expected=QueryException.class)
    @Ignore
    public void wrapped_booleanBuilder() {
        new BooleanBuilder((Predicate)new BooleanBuilder());
    }

    @Test
    public void basic() {
        Assert.assertEquals((Object)this.first.or((Predicate)this.second).toString(), (Object)new BooleanBuilder().and((Predicate)this.first).or((Predicate)this.second).toString());
    }

    @Test
    public void advanced() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.andAnyOf(new Predicate[]{this.first, this.second, this.first});
        builder.orAllOf(new Predicate[]{this.first, this.second, this.first});
        Assert.assertEquals((Object)"true || false || true || true && false && true", (Object)builder.toString());
    }

    @Test
    public void if_then_else() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and(null);
        builder.or(null);
        builder.and((Predicate)this.second);
        Assert.assertEquals((Object)this.second, (Object)builder.getValue());
    }

    @Test
    public void and_null_supported() {
        Assert.assertEquals((Object)this.first, (Object)this.first.and(null));
    }

    @Test
    public void or_null_supported() {
        Assert.assertEquals((Object)this.first, (Object)this.first.or(null));
    }

    @Test
    public void and_not() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first).andNot((Predicate)this.second);
        Assert.assertEquals((Object)this.first.and((Predicate)this.second.not()), (Object)builder.getValue());
    }

    @Test
    public void or_not() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first).orNot((Predicate)this.second);
        Assert.assertEquals((Object)this.first.or((Predicate)this.second.not()), (Object)builder.getValue());
    }

    @Test
    public void not() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first).not();
        Assert.assertEquals((Object)this.first.not(), (Object)builder.getValue());
    }

    @Test
    public void booleanBuilder_equals_booleanBuilder() {
        Assert.assertEquals((Object)new BooleanBuilder((Predicate)this.first), (Object)new BooleanBuilder((Predicate)this.first));
    }

    @Test
    public void constant_equals_booleanBuilder() {
        Assert.assertFalse((boolean)this.first.equals((Object)new BooleanBuilder((Predicate)this.first)));
    }

    @Test
    public void booleanBuilder_equals_constant() {
        Assert.assertFalse((boolean)new BooleanBuilder((Predicate)this.first).equals((Object)this.first));
    }

    @Test
    public void hashCode_() {
        Assert.assertEquals((long)new BooleanBuilder((Predicate)this.first).hashCode(), (long)new BooleanBuilder((Predicate)this.first).hashCode());
        Assert.assertEquals((long)new BooleanBuilder().hashCode(), (long)new BooleanBuilder().hashCode());
    }

    @Test
    public void toString_() {
        BooleanBuilder builder = new BooleanBuilder().and((Predicate)this.first);
        Assert.assertEquals((Object)"true", (Object)builder.toString());
        builder.or((Predicate)Expressions.booleanPath((String)"condition"));
        Assert.assertEquals((Object)"true || condition", (Object)builder.toString());
    }

    @Test
    public void accept() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first);
        builder.or((Predicate)Expressions.booleanPath((String)"condition"));
        Assert.assertEquals((Object)"true || condition", (Object)builder.accept((Visitor)ToStringVisitor.DEFAULT, (Object)Templates.DEFAULT));
    }
}

