/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.querydsl.collections.CollQuery;
import com.querydsl.collections.DefaultQueryEngine;
import com.querydsl.collections.QueryEngine;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.util.BeanMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollUpdateClause<T>
implements UpdateClause<CollUpdateClause<T>> {
    private final Map<Path<?>, Object> paths = new HashMap();
    private final CollQuery<T> query;

    public CollUpdateClause(QueryEngine qe, Path<T> expr, Iterable<? extends T> col) {
        this.query = ((CollQuery)new CollQuery(qe).from(expr, col)).select((Expression)expr);
    }

    public CollUpdateClause(Path<T> expr, Iterable<? extends T> col) {
        this(DefaultQueryEngine.getDefault(), expr, col);
    }

    public long execute() {
        int rv = 0;
        for (Object match : this.query.fetch()) {
            BeanMap beanMap = new BeanMap(match);
            for (Map.Entry<Path<?>, Object> entry : this.paths.entrySet()) {
                String propertyName = entry.getKey().getMetadata().getName();
                beanMap.put(propertyName, entry.getValue());
            }
            ++rv;
        }
        return rv;
    }

    public <U> CollUpdateClause<T> set(Path<U> path, U value) {
        this.paths.put(path, value);
        return this;
    }

    public <U> CollUpdateClause<T> set(Path<U> path, Expression<? extends U> expression) {
        throw new UnsupportedOperationException();
    }

    public <U> CollUpdateClause<T> setNull(Path<U> path) {
        this.paths.put(path, null);
        return this;
    }

    public CollUpdateClause<T> set(List<? extends Path<?>> p, List<?> v) {
        for (int i = 0; i < p.size(); ++i) {
            this.paths.put(p.get(i), v.get(i));
        }
        return this;
    }

    public CollUpdateClause<T> where(Predicate ... o) {
        this.query.where(o);
        return this;
    }

    public String toString() {
        return "update " + this.query;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }
}

