/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.ScalaWriter;
import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.support.ClassUtils;
import com.querydsl.codegen.AnnotationHelper;
import com.querydsl.codegen.ClassPathUtils;
import com.querydsl.codegen.CodegenModule;
import com.querydsl.codegen.EmbeddableSerializer;
import com.querydsl.codegen.EntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.ProjectionSerializer;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.SupertypeSerializer;
import com.querydsl.codegen.TypeFactory;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.core.QueryException;
import com.querydsl.core.annotations.Config;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryEmbeddable;
import com.querydsl.core.annotations.QueryEmbedded;
import com.querydsl.core.annotations.QueryEntity;
import com.querydsl.core.annotations.QueryExclude;
import com.querydsl.core.annotations.QueryInit;
import com.querydsl.core.annotations.QueryProjection;
import com.querydsl.core.annotations.QuerySupertype;
import com.querydsl.core.annotations.QueryTransient;
import com.querydsl.core.annotations.QueryType;
import com.querydsl.core.util.BeanUtils;
import com.querydsl.core.util.ReflectionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class GenericExporter {
    private Class<? extends Annotation> entityAnnotation = QueryEntity.class;
    private Class<? extends Annotation> supertypeAnnotation = QuerySupertype.class;
    private Class<? extends Annotation> embeddableAnnotation = QueryEmbeddable.class;
    private Class<? extends Annotation> embeddedAnnotation = QueryEmbedded.class;
    private Class<? extends Annotation> skipAnnotation = QueryTransient.class;
    private boolean createScalaSources = false;
    private final Set<Class<?>> stopClasses = Sets.newHashSet();
    private final Map<String, EntityType> allTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> entityTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> superTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> embeddableTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> projectionTypes = Maps.newHashMap();
    private final CodegenModule codegenModule = new CodegenModule();
    private SerializerConfig serializerConfig = SimpleSerializerConfig.DEFAULT;
    private boolean handleFields = true;
    private boolean handleMethods = true;
    private boolean useFieldTypes = false;
    @Nullable
    private File targetFolder;
    @Nullable
    private TypeFactory typeFactory;
    private final List<AnnotationHelper> annotationHelpers = Lists.newArrayList();
    @Nullable
    private TypeMappings typeMappings;
    @Nullable
    private QueryTypeFactory queryTypeFactory;
    @Nullable
    private Class<? extends Serializer> serializerClass;
    private final Charset charset;
    private final ClassLoader classLoader;
    private Set<File> generatedFiles = new HashSet<File>();
    private boolean strictMode;

    public GenericExporter(ClassLoader classLoader, Charset charset) {
        this.classLoader = classLoader;
        this.charset = charset;
        this.stopClasses.add(Object.class);
        this.stopClasses.add(Enum.class);
    }

    public GenericExporter(ClassLoader classLoader) {
        this(classLoader, Charset.defaultCharset());
    }

    public GenericExporter(Charset charset) {
        this(Thread.currentThread().getContextClassLoader(), charset);
    }

    public GenericExporter() {
        this(Thread.currentThread().getContextClassLoader(), Charset.defaultCharset());
    }

    public void export(Package ... packages) {
        String[] pkgs = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            pkgs[i] = packages[i].getName();
        }
        this.export(pkgs);
    }

    public void export(String ... packages) {
        this.scanPackages(packages);
        this.innerExport();
    }

    public void export(Class<?> ... classes) {
        for (Class<?> cl : classes) {
            this.handleClass(cl);
        }
        this.innerExport();
    }

    /*
     * WARNING - void declaration
     */
    private void innerExport() {
        this.typeMappings = this.codegenModule.get(TypeMappings.class);
        this.queryTypeFactory = this.codegenModule.get(QueryTypeFactory.class);
        this.typeFactory = new TypeFactory((List<Class<? extends Annotation>>)ImmutableList.of(this.entityAnnotation, this.supertypeAnnotation, this.embeddableAnnotation), (Function<EntityType, String>)this.codegenModule.get(Function.class, "variableNameFunction"));
        for (AnnotationHelper annotationHelper : this.annotationHelpers) {
            this.typeFactory.addAnnotationHelper(annotationHelper);
        }
        for (Class clazz : this.superTypes.keySet()) {
            this.createEntityType(clazz, this.superTypes);
        }
        for (Class clazz : this.embeddableTypes.keySet()) {
            this.createEntityType(clazz, this.embeddableTypes);
        }
        for (Class clazz : this.entityTypes.keySet()) {
            this.createEntityType(clazz, this.entityTypes);
        }
        for (Class clazz : this.projectionTypes.keySet()) {
            this.createEntityType(clazz, this.projectionTypes);
        }
        for (Map map : Arrays.asList(this.superTypes, this.embeddableTypes, this.entityTypes, this.projectionTypes)) {
            for (Map.Entry entry : Sets.newHashSet(map.entrySet())) {
                this.addConstructors((Class)entry.getKey(), (EntityType)entry.getValue());
                this.addProperties((Class)entry.getKey(), (EntityType)entry.getValue());
            }
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : this.superTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.entityTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.embeddableTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        this.typeFactory.extendTypes();
        try {
            void var2_18;
            Serializer projectionSerializer;
            Serializer embeddableSerializer;
            Serializer entitySerializer;
            if (this.serializerClass != null) {
                Serializer serializer;
                Serializer serializer2 = serializer = this.codegenModule.get(this.serializerClass);
                entitySerializer = serializer;
                embeddableSerializer = serializer;
                projectionSerializer = serializer;
            } else {
                Serializer serializer = this.codegenModule.get(SupertypeSerializer.class);
                entitySerializer = this.codegenModule.get(EntitySerializer.class);
                embeddableSerializer = this.codegenModule.get(EmbeddableSerializer.class);
                projectionSerializer = this.codegenModule.get(ProjectionSerializer.class);
            }
            this.serialize((Serializer)var2_18, this.superTypes);
            this.serialize(entitySerializer, this.entityTypes);
            this.serialize(embeddableSerializer, this.embeddableTypes);
            this.serialize(projectionSerializer, this.projectionTypes);
        }
        catch (IOException iOException) {
            throw new QueryException((Throwable)iOException);
        }
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) {
                    if (supertype.getType().getPackageName().startsWith("java.")) continue;
                    Class cl = supertype.getType().getJavaClass();
                    this.typeFactory.addEmbeddableType(cl);
                    entityType = this.createEntityType(cl, new HashMap());
                    this.addProperties(cl, entityType);
                }
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private boolean containsAny(Class<?> clazz, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annType : annotations) {
            if (!clazz.isAnnotationPresent(annType)) continue;
            return true;
        }
        return false;
    }

    private EntityType createEntityType(Class<?> cl, Map<Class<?>, EntityType> types) {
        if (types.get(cl) != null) {
            return types.get(cl);
        }
        EntityType type = this.allTypes.get(ClassUtils.getFullName(cl));
        if (type == null) {
            type = this.typeFactory.getEntityType(cl);
        }
        types.put(cl, type);
        String fullName = ClassUtils.getFullName(cl);
        if (!this.allTypes.containsKey(fullName)) {
            this.allTypes.put(fullName, type);
        }
        this.typeMappings.register((com.mysema.codegen.model.Type)type, this.queryTypeFactory.create((com.mysema.codegen.model.Type)type));
        if (this.strictMode && cl.getSuperclass() != null && !this.containsAny(cl.getSuperclass(), this.entityAnnotation, this.supertypeAnnotation, this.embeddableAnnotation)) {
            return type;
        }
        if (cl.getSuperclass() != null && !this.stopClasses.contains(cl.getSuperclass()) && !cl.getSuperclass().isAnnotationPresent(QueryExclude.class)) {
            type.addSupertype(new Supertype(this.typeFactory.get(cl.getSuperclass(), cl.getGenericSuperclass())));
        }
        if (cl.isInterface()) {
            for (Class<?> iface : cl.getInterfaces()) {
                if (this.stopClasses.contains(iface) || iface.isAnnotationPresent(QueryExclude.class)) continue;
                type.addSupertype(new Supertype(this.typeFactory.get(iface)));
            }
        }
        return type;
    }

    private void addConstructors(Class<?> cl, EntityType type) {
        for (java.lang.reflect.Constructor<?> constructor : cl.getConstructors()) {
            if (!constructor.isAnnotationPresent(QueryProjection.class)) continue;
            ArrayList parameters = Lists.newArrayList();
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                com.mysema.codegen.model.Type parameterType = this.typeFactory.get(constructor.getParameterTypes()[i], constructor.getGenericParameterTypes()[i]);
                for (Annotation annotation : constructor.getParameterAnnotations()[i]) {
                    if (!annotation.annotationType().equals(QueryType.class)) continue;
                    QueryType queryType = (QueryType)annotation;
                    parameterType = parameterType.as(TypeCategory.valueOf((String)queryType.value().name()));
                }
                parameters.add(new Parameter("param" + i, parameterType));
            }
            type.addConstructor(new Constructor((Collection)parameters));
        }
    }

    private void addProperties(Class<?> cl, EntityType type) {
        Property property;
        com.mysema.codegen.model.Type propertyType;
        HashSet<String> handled = new HashSet<String>();
        if (this.handleFields) {
            for (AccessibleObject accessibleObject : cl.getDeclaredFields()) {
                if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || Modifier.isTransient(((Field)accessibleObject).getModifiers()) && !accessibleObject.isAnnotationPresent(QueryType.class)) continue;
                AnnotatedElement annotated = ReflectionUtils.getAnnotatedElement(cl, (String)((Field)accessibleObject).getName(), ((Field)accessibleObject).getType());
                Method method = ReflectionUtils.getGetterOrNull(cl, (String)((Field)accessibleObject).getName(), ((Field)accessibleObject).getType());
                propertyType = null;
                propertyType = method != null && !this.useFieldTypes ? this.getPropertyType(cl, annotated, method.getReturnType(), method.getGenericReturnType()) : this.getPropertyType(cl, annotated, ((Field)accessibleObject).getType(), ((Field)accessibleObject).getGenericType());
                property = this.createProperty(type, ((Field)accessibleObject).getName(), propertyType, accessibleObject);
                if (property != null) {
                    type.addProperty(property);
                }
                handled.add(((Field)accessibleObject).getName());
            }
        }
        if (this.handleMethods) {
            for (AccessibleObject accessibleObject : cl.getDeclaredMethods()) {
                String propertyName;
                String name = ((Method)accessibleObject).getName();
                if (((Method)accessibleObject).getParameterTypes().length != 0 || (!name.startsWith("get") || name.length() <= 3) && (!name.startsWith("is") || name.length() <= 2) || handled.contains(propertyName = name.startsWith("get") ? BeanUtils.uncapitalize((String)name.substring(3)) : BeanUtils.uncapitalize((String)name.substring(2))) || (property = this.createProperty(type, propertyName, propertyType = this.getPropertyType(cl, accessibleObject, ((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).getGenericReturnType()), accessibleObject)) == null) continue;
                type.addProperty(property);
            }
        }
    }

    private com.mysema.codegen.model.Type getPropertyType(Class<?> cl, AnnotatedElement annotated, Class<?> type, Type genericType) {
        String fullName;
        Object propertyType = null;
        if (annotated.isAnnotationPresent(this.embeddedAnnotation)) {
            Class embeddableType = type;
            if (Collection.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameterAsClass((Type)genericType, (int)0);
            } else if (Map.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameterAsClass((Type)genericType, (int)1);
            }
            if (!embeddableType.getName().startsWith("java.")) {
                this.typeFactory.addEmbeddableType(embeddableType);
                if (!(this.embeddableTypes.containsKey(embeddableType) || this.entityTypes.containsKey(embeddableType) || this.superTypes.containsKey(embeddableType))) {
                    EntityType entityType = this.createEntityType(embeddableType, this.embeddableTypes);
                    this.addProperties(embeddableType, entityType);
                    if (embeddableType == type) {
                        propertyType = entityType;
                    }
                }
            }
        }
        if (propertyType == null && (propertyType = this.typeFactory.get(type, annotated, genericType)) instanceof EntityType && !this.allTypes.containsKey(ClassUtils.getFullName((Class)type)) && !this.allTypes.containsKey(fullName = ClassUtils.getFullName((Class)type))) {
            this.allTypes.put(fullName, (EntityType)propertyType);
        }
        return propertyType;
    }

    @Nullable
    private Property createProperty(EntityType entityType, String propertyName, com.mysema.codegen.model.Type propertyType, AnnotatedElement annotated) {
        ImmutableList inits = Collections.emptyList();
        if (annotated.isAnnotationPresent(this.skipAnnotation) && !annotated.isAnnotationPresent(QueryType.class)) {
            return null;
        }
        if (annotated.isAnnotationPresent(QueryInit.class)) {
            inits = ImmutableList.copyOf((Object[])annotated.getAnnotation(QueryInit.class).value());
        }
        if (annotated.isAnnotationPresent(QueryType.class)) {
            QueryType queryType = annotated.getAnnotation(QueryType.class);
            if (queryType.value().equals((Object)PropertyType.NONE)) {
                return null;
            }
            propertyType = propertyType.as(TypeCategory.valueOf((String)queryType.value().name()));
        }
        return new Property(entityType, propertyName, propertyType, (List<String>)inits);
    }

    private void scanPackages(String ... packages) {
        if (packages == null) {
            return;
        }
        for (String pkg : packages) {
            try {
                for (Class<?> cl : ClassPathUtils.scanPackage(this.classLoader, pkg)) {
                    this.handleClass(cl);
                }
            }
            catch (IOException e) {
                throw new QueryException((Throwable)e);
            }
        }
    }

    private void handleClass(Class<?> cl) {
        if (this.stopClasses.contains(cl) || cl.isAnnotationPresent(QueryExclude.class)) {
            return;
        }
        if (cl.isAnnotationPresent(this.entityAnnotation)) {
            this.entityTypes.put(cl, null);
        } else if (cl.isAnnotationPresent(this.embeddableAnnotation)) {
            this.embeddableTypes.put(cl, null);
        } else if (cl.isAnnotationPresent(this.supertypeAnnotation)) {
            this.superTypes.put(cl, null);
        } else {
            for (java.lang.reflect.Constructor<?> constructor : cl.getConstructors()) {
                if (!constructor.isAnnotationPresent(QueryProjection.class)) continue;
                this.projectionTypes.put(cl, null);
                break;
            }
        }
    }

    private void serialize(Serializer serializer, Map<Class<?>, EntityType> types) throws IOException {
        for (Map.Entry<Class<?>, EntityType> entityType : types.entrySet()) {
            com.mysema.codegen.model.Type type = this.typeMappings.getPathType((com.mysema.codegen.model.Type)entityType.getValue(), entityType.getValue(), true);
            String packageName = type.getPackageName();
            String className = packageName.length() > 0 ? packageName + "." + type.getSimpleName() : type.getSimpleName();
            SerializerConfig config = this.serializerConfig;
            if (entityType.getKey().isAnnotationPresent(Config.class)) {
                config = SimpleSerializerConfig.getConfig(entityType.getKey().getAnnotation(Config.class));
            }
            String fileSuffix = this.createScalaSources ? ".scala" : ".java";
            this.write(serializer, className.replace('.', '/') + fileSuffix, config, entityType.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Serializer serializer, String path, SerializerConfig serializerConfig, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        this.generatedFiles.add(targetFile);
        Writer w = this.writerFor(targetFile);
        try {
            ScalaWriter writer = this.createScalaSources ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
            serializer.serialize(type, serializerConfig, (CodeWriter)writer);
        }
        finally {
            w.close();
        }
    }

    private Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            System.err.println("Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void setEntityAnnotation(Class<? extends Annotation> entityAnnotation) {
        this.entityAnnotation = entityAnnotation;
    }

    public void setSupertypeAnnotation(Class<? extends Annotation> supertypeAnnotation) {
        this.supertypeAnnotation = supertypeAnnotation;
    }

    public void setEmbeddableAnnotation(Class<? extends Annotation> embeddableAnnotation) {
        this.embeddableAnnotation = embeddableAnnotation;
    }

    public void setEmbeddedAnnotation(Class<? extends Annotation> embeddedAnnotation) {
        this.embeddedAnnotation = embeddedAnnotation;
    }

    public void setSkipAnnotation(Class<? extends Annotation> skipAnnotation) {
        this.skipAnnotation = skipAnnotation;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.codegenModule.bind(serializerClass);
        this.serializerClass = serializerClass;
    }

    public void setTypeMappingsClass(Class<? extends TypeMappings> typeMappingsClass) {
        this.codegenModule.bind(TypeMappings.class, typeMappingsClass);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setKeywords(Collection<String> keywords) {
        this.codegenModule.bind("keywords", keywords);
    }

    public void setNamePrefix(String prefix) {
        this.codegenModule.bind("prefix", prefix);
    }

    public void setNameSuffix(String suffix) {
        this.codegenModule.bind("suffix", suffix);
    }

    public void setPackageSuffix(String suffix) {
        this.codegenModule.bind("packageSuffix", suffix);
    }

    public void setHandleFields(boolean b) {
        this.handleFields = b;
    }

    public void setHandleMethods(boolean b) {
        this.handleMethods = b;
    }

    public void setUseFieldTypes(boolean b) {
        this.useFieldTypes = b;
    }

    public void addStopClass(Class<?> cl) {
        this.stopClasses.add(cl);
    }

    public void setStrictMode(boolean s) {
        this.strictMode = s;
    }

    public void setSerializerConfig(SerializerConfig serializerConfig) {
        this.serializerConfig = serializerConfig;
    }

    public void addAnnotationHelper(AnnotationHelper annotationHelper) {
        this.annotationHelpers.add(annotationHelper);
    }
}

