/*
 * Decompiled with CFR 0.152.
 */
package com.qoomon.maven.extension.gitversioning.config;

import com.qoomon.maven.BuildProperties;
import com.qoomon.maven.extension.gitversioning.ExtensionUtil;
import com.qoomon.maven.extension.gitversioning.SessionScopeUtil;
import com.qoomon.maven.extension.gitversioning.config.VersioningConfiguration;
import com.qoomon.maven.extension.gitversioning.config.model.Configuration;
import com.qoomon.maven.extension.gitversioning.config.model.VersionFormatDescription;
import java.io.File;
import java.util.LinkedList;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.simpleframework.xml.core.Persister;

@Component(role=VersioningConfigurationProvider.class, instantiationStrategy="singleton")
public class VersioningConfigurationProvider {
    private Logger logger;
    private SessionScope sessionScope;
    private VersioningConfiguration configuration;

    @Inject
    public VersioningConfigurationProvider(Logger logger, SessionScope sessionScope) {
        this.logger = logger;
        this.sessionScope = sessionScope;
    }

    public VersioningConfiguration get() {
        if (this.configuration == null) {
            MavenSession session = SessionScopeUtil.get(this.sessionScope, MavenSession.class).get();
            LinkedList<VersionFormatDescription> branchVersionDescriptions = new LinkedList<VersionFormatDescription>();
            LinkedList<VersionFormatDescription> tagVersionDescriptions = new LinkedList<VersionFormatDescription>();
            VersionFormatDescription commitVersionDescription = VersioningConfigurationProvider.defaultCommitVersionFormat();
            File configFile = ExtensionUtil.getConfigFile(session.getRequest(), BuildProperties.projectArtifactId());
            if (configFile.exists()) {
                Configuration configurationModel = this.loadConfiguration(configFile);
                branchVersionDescriptions.addAll(configurationModel.branches);
                tagVersionDescriptions.addAll(configurationModel.tags);
            } else {
                this.logger.info("No configuration file found. Apply default configuration.");
            }
            branchVersionDescriptions.add(VersioningConfigurationProvider.defaultBranchVersionFormat());
            this.configuration = new VersioningConfiguration(branchVersionDescriptions, tagVersionDescriptions, commitVersionDescription);
        }
        return this.configuration;
    }

    private static VersionFormatDescription defaultBranchVersionFormat() {
        VersionFormatDescription result = new VersionFormatDescription();
        result.pattern = ".*";
        result.versionFormat = "${branch}-SNAPSHOT";
        return result;
    }

    private static VersionFormatDescription defaultCommitVersionFormat() {
        VersionFormatDescription result = new VersionFormatDescription();
        result.pattern = ".*";
        result.versionFormat = "${commit}";
        return result;
    }

    private Configuration loadConfiguration(File configFile) {
        try {
            this.logger.debug("load config from " + configFile);
            Persister serializer = new Persister();
            return (Configuration)serializer.read(Configuration.class, configFile);
        }
        catch (Exception e) {
            throw new RuntimeException(configFile.toString(), e);
        }
    }
}

