/*
 * Decompiled with CFR 0.152.
 */
package com.qoomon.maven;

import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

public class GAV {
    private String groupId;
    private String artifactId;
    private String version;

    public GAV(String groupId, String artifactId, String version) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId must not be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public static GAV of(Model model) {
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (model.getParent() != null) {
            if (groupId == null) {
                groupId = model.getParent().getGroupId();
            }
            if (version == null) {
                version = model.getParent().getVersion();
            }
        }
        return new GAV(groupId, artifactId, version);
    }

    public static GAV of(Parent parent) {
        return new GAV(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public static GAV of(MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        if (project.getParent() != null) {
            if (groupId == null) {
                groupId = project.getParent().getGroupId();
            }
            if (version == null) {
                version = project.getParent().getVersion();
            }
        }
        return new GAV(groupId, artifactId, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GAV gav = (GAV)o;
        if (!this.groupId.equals(gav.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(gav.artifactId)) {
            return false;
        }
        return this.version.equals(gav.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }
}

