/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.rtc;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.rtc.QRTCClient;
import com.qiniu.rtc.model.AppParam;
import com.qiniu.rtc.model.AppResult;
import com.qiniu.rtc.model.QRTCResult;
import com.qiniu.rtc.service.AppService;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QRTC {
    public static final String VERSION = "8.0";
    private static volatile QRTCClient client = null;
    private static final Map<String, QRTCClient> holder = new ConcurrentHashMap<String, QRTCClient>(16);

    private QRTC() {
    }

    public static QRTCClient init(String accessKey, String secretKey, String appId) {
        if (null == appId || null == accessKey || null == secretKey) {
            throw new IllegalArgumentException("params cannot be null...");
        }
        if (holder.containsKey(appId)) {
            return holder.get(appId);
        }
        client = new QRTCClient(accessKey, secretKey, appId);
        holder.put(appId, client);
        return holder.get(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QRTCResult<AppResult> createApp(AppParam appParam, String accessKey, String secretKey) throws QiniuException {
        try (Response response = null;){
            response = QRTC.fetchCreateApp(appParam, accessKey, secretKey);
            QRTCResult<AppResult> qRTCResult = QRTC.formatCreateAppResult(response);
            return qRTCResult;
        }
    }

    private static QRTCResult<AppResult> formatCreateAppResult(Response response) throws QiniuException {
        if (null == response || StringUtils.isNullOrEmpty(response.bodyString())) {
            return QRTCResult.fail(-1, "result is null");
        }
        AppResult t = Json.decode(response.bodyString(), AppResult.class);
        return QRTCResult.success(response.statusCode, t);
    }

    private static Response fetchCreateApp(AppParam appParam, String accessKey, String secretKey) throws QiniuException {
        AppService appService = new AppService(Auth.create(accessKey, secretKey));
        return appService.createApp(appParam);
    }

    public static QRTCClient getClient(String appId) {
        return holder.get(appId);
    }
}

