/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qvs;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.qvs.QvsResponse;
import com.qiniu.qvs.model.DynamicLiveRoute;
import com.qiniu.qvs.model.PatchOperation;
import com.qiniu.qvs.model.StaticLiveRoute;
import com.qiniu.qvs.model.Stream;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlUtils;

public class StreamManager {
    private final String apiServer;
    private final Client client;
    private final Auth auth;

    public StreamManager(Auth auth) {
        this(auth, "http://qvs.qiniuapi.com");
    }

    public StreamManager(Auth auth, String apiServer) {
        this(auth, apiServer, new Client());
    }

    public StreamManager(Auth auth, String apiServer, Client client) {
        this.auth = auth;
        this.apiServer = apiServer;
        this.client = client;
    }

    public Response createStream(String namespaceId, Stream stream) throws QiniuException {
        StringMap params = new StringMap();
        params.putNotNull("streamId", stream.getStreamID());
        params.putNotNull("desc", stream.getDesc());
        params.putNotNull("recordTemplateId", stream.getRecordTemplateId());
        params.putNotNull("snapshotTemplateId", stream.getSnapShotTemplateId());
        String url = String.format("%s/v1/namespaces/%s/streams", this.apiServer, namespaceId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response deleteStream(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s", this.apiServer, namespaceId, streamId);
        return QvsResponse.delete(url, this.client, this.auth);
    }

    public Response updateStream(String namespaceId, String streamId, PatchOperation[] patchOperation) throws QiniuException {
        StringMap params = new StringMap().put("operations", patchOperation);
        String url = String.format("%s/v1/namespaces/%s/streams/%s", this.apiServer, namespaceId, streamId);
        return QvsResponse.patch(url, params, this.client, this.auth);
    }

    public Response queryStream(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s", this.apiServer, namespaceId, streamId);
        return QvsResponse.get(url, this.client, this.auth);
    }

    public Response listStream(String namespaceId, int offset, int line, int qtype, String prefix, String sortBy) throws QiniuException {
        String requestUrl = String.format("%s/v1/namespaces/%s/streams", this.apiServer, namespaceId);
        StringMap map = new StringMap().put("offset", offset).put("line", line).put("qtype", qtype).putNotEmpty("prefix", prefix).putNotEmpty("sortBy", sortBy);
        requestUrl = UrlUtils.composeUrlWithQueries(requestUrl, map);
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response staticPublishPlayURL(String namespaceId, String streamId, StaticLiveRoute staticLiveRoute) throws QiniuException {
        StringMap params = new StringMap().put("Domain", staticLiveRoute.getDomain()).put("DomainType", staticLiveRoute.getDomainType()).putNotNull("UrlExpireSec", staticLiveRoute.getUrlExpireSec());
        String url = String.format("%s/v1/namespaces/%s/streams/%s/domain", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response dynamicPublishPlayURL(String namespaceId, String streamId, DynamicLiveRoute dynamicLiveRoute) throws QiniuException {
        StringMap params = new StringMap();
        params.put("PublishIP", dynamicLiveRoute.getPublishIP());
        params.put("PlayIP", dynamicLiveRoute.getPlayIP());
        params.putNotNull("UrlExpireSec", dynamicLiveRoute.getUrlExpireSec());
        String url = String.format("%s/v1/namespaces/%s/streams/%s/urls", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response disableStream(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/disabled", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }

    public Response enableStream(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/enabled", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }

    public Response queryStreamPubHistories(String namespaceId, String streamId, int start, int end, int offset, int line) throws QiniuException {
        String requestUrl = String.format("%s/v1/namespaces/%s/streams/%s/pubhistories", this.apiServer, namespaceId, streamId);
        StringMap map = new StringMap().putNotNull("start", start).putNotNull("end", end).putNotNull("offset", offset).putNotNull("line", line);
        requestUrl = UrlUtils.composeUrlWithQueries(requestUrl, map);
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response queryStreamRecordHistories(String namespaceId, String streamId, int start, int end, int line, String marker) throws QiniuException {
        String requestUrl = String.format("%s/v1/namespaces/%s/streams/%s/recordhistories", this.apiServer, namespaceId, streamId);
        StringMap map = new StringMap().putNotNull("start", start).putNotNull("end", end).putNotNull("line", line).putNotEmpty("marker", marker);
        requestUrl = UrlUtils.composeUrlWithQueries(requestUrl, map);
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response queryStreamCover(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/cover", this.apiServer, namespaceId, streamId);
        return QvsResponse.get(url, this.client, this.auth);
    }

    public Response streamsSnapshots(String namespaceId, String streamId, int start, int end, int type, int line, String marker) throws QiniuException {
        String requestUrl = String.format("%s/v1/namespaces/%s/streams/%s/snapshots", this.apiServer, namespaceId, streamId);
        StringMap map = new StringMap().putNotNull("start", start).putNotNull("end", end).putNotNull("line", line).putNotEmpty("marker", marker).put("type", type);
        requestUrl = UrlUtils.composeUrlWithQueries(requestUrl, map);
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response stopStream(String namespaceId, String streamId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/stop", this.apiServer, namespaceId, streamId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }
}

