/*
 * Decompiled with CFR 0.152.
 */
package org.qeagle.devtools.webdriver;

import com.qeagle.devtools.services.ChromeDevToolsService;
import com.qeagle.devtools.services.impl.ChromeServiceImpl;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DevToolsService {
    private static String getDebuggerAddress(WebDriver driver) {
        Object capability = ((RemoteWebDriver)driver).getCapabilities().getCapability("goog:chromeOptions");
        Map chromeOptions = (Map)capability;
        return (String)chromeOptions.get("debuggerAddress");
    }

    public static ChromeDevToolsService getDevToolsService(WebDriver driver) {
        ChromeServiceImpl chromeService = new ChromeServiceImpl(Integer.parseInt(DevToolsService.getDebuggerAddress(driver).replaceAll("\\D", "")));
        ChromeDevToolsService devToolsService = chromeService.createDevToolsService();
        return devToolsService;
    }

    public static int getRemoteDebuggerPort(WebDriver driver) {
        return Integer.parseInt(DevToolsService.getDebuggerAddress(driver).replaceAll("\\D", ""));
    }

    public static String getRemoteDebuggerServer(WebDriver driver) {
        return DevToolsService.getDebuggerAddress(driver).replaceAll("[^A-Za-z]+", "").trim();
    }
}

