/*
 * Decompiled with CFR 0.152.
 */
package com.qeagle.devtools.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qeagle.devtools.services.ChromeDevToolsService;
import com.qeagle.devtools.services.ChromeService;
import com.qeagle.devtools.services.WebSocketService;
import com.qeagle.devtools.services.config.ChromeDevToolsServiceConfiguration;
import com.qeagle.devtools.services.exceptions.ChromeServiceException;
import com.qeagle.devtools.services.exceptions.WebSocketServiceException;
import com.qeagle.devtools.services.factory.WebSocketServiceFactory;
import com.qeagle.devtools.services.impl.ChromeDevToolsServiceImpl;
import com.qeagle.devtools.services.impl.WebSocketServiceImpl;
import com.qeagle.devtools.services.invocation.CommandInvocationHandler;
import com.qeagle.devtools.services.types.ChromeTab;
import com.qeagle.devtools.services.types.ChromeVersion;
import com.qeagle.devtools.services.utils.ProxyUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChromeServiceImpl
implements ChromeService {
    public static final String ABOUT_BLANK_PAGE = "about:blank";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String EMPTY_STRING = "";
    private static final String LOCALHOST = "localhost";
    private static final String LIST_TABS = "json/list";
    private static final String CREATE_TAB = "json/new";
    private static final String ACTIVATE_TAB = "json/activate";
    private static final String CLOSE_TAB = "json/close";
    private static final String VERSION = "json/version";
    private String host;
    private int port;
    private WebSocketServiceFactory webSocketServiceFactory;
    private Map<String, ChromeDevToolsService> chromeDevToolServiceCache = new ConcurrentHashMap<String, ChromeDevToolsService>();

    public ChromeServiceImpl(String host, int port, WebSocketServiceFactory webSocketServiceFactory) {
        this.host = host;
        this.port = port;
        this.webSocketServiceFactory = webSocketServiceFactory;
    }

    public ChromeServiceImpl(String host, int port) {
        this(host, port, wsUrl -> WebSocketServiceImpl.create(URI.create(wsUrl)));
    }

    public ChromeServiceImpl(int port) {
        this(LOCALHOST, port);
    }

    public ChromeServiceImpl(int port, WebSocketServiceFactory webSocketServiceFactory) {
        this(LOCALHOST, port, webSocketServiceFactory);
    }

    public void setWebSocketServiceFactory(WebSocketServiceFactory webSocketServiceFactory) {
        this.webSocketServiceFactory = webSocketServiceFactory;
    }

    @Override
    public List<ChromeTab> getTabs() throws ChromeServiceException {
        return Arrays.asList((Object[])ChromeServiceImpl.request(ChromeTab[].class, "http://%s:%d/%s", this.host, this.port, LIST_TABS));
    }

    @Override
    public ChromeTab createTab() throws ChromeServiceException {
        return this.createTab(ABOUT_BLANK_PAGE);
    }

    @Override
    public ChromeTab createTab(String tab) throws ChromeServiceException {
        return ChromeServiceImpl.request(ChromeTab.class, "http://%s:%d/%s?%s", this.host, this.port, CREATE_TAB, tab);
    }

    @Override
    public void activateTab(ChromeTab tab) throws ChromeServiceException {
        ChromeServiceImpl.request(Void.class, "http://%s:%d/%s/%s", this.host, this.port, ACTIVATE_TAB, tab.getId());
    }

    @Override
    public void closeTab(ChromeTab tab) throws ChromeServiceException {
        ChromeServiceImpl.request(Void.class, "http://%s:%d/%s/%s", this.host, this.port, CLOSE_TAB, tab.getId());
        this.clearChromeDevToolsServiceCache(tab);
    }

    @Override
    public ChromeVersion getVersion() throws ChromeServiceException {
        return ChromeServiceImpl.request(ChromeVersion.class, "http://%s:%d/%s", this.host, this.port, VERSION);
    }

    @Override
    public synchronized ChromeDevToolsService createDevToolsService() throws ChromeServiceException {
        List<ChromeTab> tabs = this.getTabs();
        return this.createDevToolsService(tabs.get(1), new ChromeDevToolsServiceConfiguration());
    }

    @Override
    public synchronized ChromeDevToolsService createDevToolsService(ChromeTab tab) throws ChromeServiceException {
        return this.createDevToolsService(tab, new ChromeDevToolsServiceConfiguration());
    }

    @Override
    public synchronized ChromeDevToolsService createDevToolsService(ChromeTab tab, ChromeDevToolsServiceConfiguration chromeDevToolsServiceConfiguration) throws ChromeServiceException {
        try {
            if (this.isChromeDevToolsServiceCached(tab)) {
                return this.getCachedChromeDevToolsService(tab);
            }
            String webSocketDebuggerUrl = tab.getWebSocketDebuggerUrl();
            WebSocketService webSocketService = this.webSocketServiceFactory.createWebSocketService(webSocketDebuggerUrl);
            CommandInvocationHandler commandInvocationHandler = new CommandInvocationHandler();
            ConcurrentHashMap commandsCache = new ConcurrentHashMap();
            ChromeDevToolsServiceImpl chromeDevToolsService = ProxyUtils.createProxyFromAbstract(ChromeDevToolsServiceImpl.class, new Class[]{WebSocketService.class, ChromeDevToolsServiceConfiguration.class}, new Object[]{webSocketService, chromeDevToolsServiceConfiguration}, (unused, method, args) -> commandsCache.computeIfAbsent(method, key -> {
                Class<?> returnType = method.getReturnType();
                return ProxyUtils.createProxy(returnType, commandInvocationHandler);
            }));
            commandInvocationHandler.setChromeDevToolsService(chromeDevToolsService);
            this.cacheChromeDevToolsService(tab, chromeDevToolsService);
            return chromeDevToolsService;
        }
        catch (WebSocketServiceException ex) {
            throw new ChromeServiceException("Failed connecting to tab web socket.", ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void clearChromeDevToolsServiceCache(ChromeTab tab) {
        ChromeDevToolsService chromeDevToolsService = this.chromeDevToolServiceCache.remove(tab.getId());
        if (chromeDevToolsService != null) {
            chromeDevToolsService.close();
        }
    }

    private boolean isChromeDevToolsServiceCached(ChromeTab tab) {
        return this.chromeDevToolServiceCache.get(tab.getId()) != null;
    }

    private ChromeDevToolsService getCachedChromeDevToolsService(ChromeTab tab) {
        return this.chromeDevToolServiceCache.get(tab.getId());
    }

    private void cacheChromeDevToolsService(ChromeTab tab, ChromeDevToolsService chromeDevToolsService) {
        this.chromeDevToolServiceCache.put(tab.getId(), chromeDevToolsService);
    }

    private static <T> T request(Class<T> responseType, String path, Object ... params) throws ChromeServiceException {
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        try {
            URL uri = new URL(String.format(path, params));
            connection = (HttpURLConnection)uri.openConnection();
            int responseCode = connection.getResponseCode();
            if (200 == responseCode) {
                if (Void.class.equals(responseType)) {
                    T t = null;
                    return t;
                }
                inputStream = connection.getInputStream();
                Object object = OBJECT_MAPPER.readerFor(responseType).readValue(inputStream);
                return (T)object;
            }
            try {
                inputStream = connection.getErrorStream();
                String responseBody = ChromeServiceImpl.inputStreamToString(inputStream);
                String message = MessageFormat.format("Server responded with non-200 code: {0} - {1}. {2}", responseCode, connection.getResponseMessage(), responseBody);
                throw new ChromeServiceException(message);
            }
            catch (IOException ex) {
                throw new ChromeServiceException("Failed sending HTTP request.", ex);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        int length;
        if (inputStream == null) {
            return EMPTY_STRING;
        }
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

