package com.qeagle.devtools.protocol.types.profiler;

/*-
 * #%L
 * cdt-java-client
 * %%
 * Copyright (C) 2018 - 2019 TL
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.qeagle.devtools.protocol.support.annotations.Experimental;
import java.util.List;

/** Source offset and types for a parameter or return value. */
@Experimental
public class TypeProfileEntry {

  private Integer offset;

  private List<TypeObject> types;

  /** Source offset of the parameter or end of function for return values. */
  public Integer getOffset() {
    return offset;
  }

  /** Source offset of the parameter or end of function for return values. */
  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  /** The types for this parameter or return value. */
  public List<TypeObject> getTypes() {
    return types;
  }

  /** The types for this parameter or return value. */
  public void setTypes(List<TypeObject> types) {
    this.types = types;
  }
}
