package com.qeagle.devtools.protocol.types.network;

/*-
 * #%L
 * cdt-java-client
 * %%
 * Copyright (C) 2018 - 2019 TL
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.fasterxml.jackson.annotation.JsonProperty;

/** Types of reasons why a cookie may not be stored from a response. */
public enum SetCookieBlockedReason {
  @JsonProperty("SecureOnly")
  SECURE_ONLY,
  @JsonProperty("SameSiteStrict")
  SAME_SITE_STRICT,
  @JsonProperty("SameSiteLax")
  SAME_SITE_LAX,
  @JsonProperty("SameSiteExtended")
  SAME_SITE_EXTENDED,
  @JsonProperty("SameSiteUnspecifiedTreatedAsLax")
  SAME_SITE_UNSPECIFIED_TREATED_AS_LAX,
  @JsonProperty("SameSiteNoneInsecure")
  SAME_SITE_NONE_INSECURE,
  @JsonProperty("UserPreferences")
  USER_PREFERENCES,
  @JsonProperty("SyntaxError")
  SYNTAX_ERROR,
  @JsonProperty("SchemeNotSupported")
  SCHEME_NOT_SUPPORTED,
  @JsonProperty("OverwriteSecure")
  OVERWRITE_SECURE,
  @JsonProperty("InvalidDomain")
  INVALID_DOMAIN,
  @JsonProperty("InvalidPrefix")
  INVALID_PREFIX,
  @JsonProperty("UnknownError")
  UNKNOWN_ERROR
}
