/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.vod;

import com.qcloud.QcloudApiModuleCenter;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import com.qcloud.vod.common.VodCosConf;
import com.qcloud.vod.common.VodParam;
import com.qcloud.vod.exception.VodParamException;
import com.qcloud.vod.response.VodUploadApplyResponse;
import com.qcloud.vod.response.VodUploadCommitResponse;
import com.qcloud.vod.util.FileUtil;
import com.qcloud.vod.util.JacksonUtil;
import java.io.File;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodUpload {
    private static final Logger logger = LoggerFactory.getLogger(VodUpload.class);

    public static VodUploadApplyResponse applyUpload(QcloudApiModuleCenter moduleCenter, VodParam vodParam, int retryTime) throws Exception {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        if (vodParam.getVideoPath() == null) {
            throw new VodParamException("videoPath is null");
        }
        params.put("videoName", FileUtil.getFileName(vodParam.getVideoPath()));
        params.put("videoSize", FileUtil.getFileSize(vodParam.getVideoPath()));
        params.put("videoType", FileUtil.getFileType(vodParam.getVideoPath()));
        if (vodParam.getCoverPath() != null) {
            params.put("coverName", FileUtil.getFileName(vodParam.getCoverPath()));
            params.put("coverSize", FileUtil.getFileSize(vodParam.getCoverPath()));
            params.put("coverType", FileUtil.getFileType(vodParam.getCoverPath()));
        }
        if (vodParam.getProcedure() != null) {
            params.put("procedure", vodParam.getProcedure());
        }
        VodUploadApplyResponse response = null;
        try {
            String result;
            for (int i = 0; i < retryTime && (response = JacksonUtil.readValue(result = moduleCenter.call("ApplyUpload", params), VodUploadApplyResponse.class)).isFail(); ++i) {
                logger.info("apply upload fail, result={}", (Object)result);
            }
            return response;
        }
        catch (Exception e) {
            logger.error("apply upload error, param=" + vodParam, (Throwable)e);
            throw e;
        }
    }

    public static TransferManager getTransferManager(VodParam param, VodUploadApplyResponse uploadApplyResponse, int signExpired) {
        String region = "cos." + uploadApplyResponse.getStorageRegionV5();
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setSignExpired(signExpired);
        BasicCOSCredentials credentials = new BasicCOSCredentials(String.valueOf(uploadApplyResponse.getStorageAppId()), param.getSecretId(), param.getSecretKey());
        COSClient cosClient = new COSClient((COSCredentials)credentials, clientConfig);
        return new TransferManager((COS)cosClient);
    }

    public static void uploadCos(TransferManager transferManager, VodCosConf conf) throws Exception {
        File file = new File(conf.getFilePath());
        try {
            Upload upload = transferManager.upload(conf.getBucketName(), conf.getStoragePath(), file);
            upload.waitForCompletion();
        }
        catch (Exception e) {
            logger.error("upload cos error, conf=" + conf, (Throwable)e);
            throw e;
        }
    }

    public static VodUploadCommitResponse commitUpload(QcloudApiModuleCenter moduleCenter, VodUploadApplyResponse uploadApplyResponse, int retryTime) throws Exception {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("vodSessionKey", uploadApplyResponse.getVodSessionKey());
        VodUploadCommitResponse response = null;
        try {
            String result;
            for (int i = 0; i < retryTime && (response = JacksonUtil.readValue(result = moduleCenter.call("CommitUpload", params), VodUploadCommitResponse.class)).isFail(); ++i) {
                logger.info("commit upload fail, result={}", (Object)result);
            }
            return response;
        }
        catch (Exception e) {
            logger.error("commit upload error, vodSessionKey=" + uploadApplyResponse.getVodSessionKey(), (Throwable)e);
            throw e;
        }
    }
}

