/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.vod;

import com.qcloud.Module.Base;
import com.qcloud.Module.Vod;
import com.qcloud.QcloudApiModuleCenter;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.vod.VodUpload;
import com.qcloud.vod.common.VodCosConf;
import com.qcloud.vod.common.VodParam;
import com.qcloud.vod.exception.VodHandleException;
import com.qcloud.vod.exception.VodParamException;
import com.qcloud.vod.response.VodUploadApplyResponse;
import com.qcloud.vod.response.VodUploadCommitResponse;
import com.qcloud.vod.util.FileUtil;
import com.qcloud.vod.util.JacksonUtil;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodApi {
    private static final Logger logger = LoggerFactory.getLogger(VodApi.class);
    private String secretId;
    private String secretKey;
    private int signExpired;
    private int retryTime;

    public VodApi(String secretId, String secretKey) {
        this(secretId, secretKey, 86400);
    }

    public VodApi(String secretId, String secretKey, int signExpired) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.signExpired = signExpired;
        this.retryTime = 3;
    }

    private static void checkVodUploadParam(VodParam param) {
        if (param.getSecretId() == null || param.getSecretId().length() == 0) {
            throw new VodParamException("secretId is null");
        }
        if (param.getSecretKey() == null || param.getSecretKey().length() == 0) {
            throw new VodParamException("secretKey is null");
        }
        if (param.getVideoPath() == null) {
            throw new VodParamException("videoPath is null");
        }
        if (!FileUtil.isFileExist(param.getVideoPath()).booleanValue()) {
            throw new VodParamException("videoPath is invalid");
        }
        if (param.getCoverPath() != null && !FileUtil.isFileExist(param.getCoverPath()).booleanValue()) {
            throw new VodParamException("coverPath is invalid");
        }
    }

    public VodUploadCommitResponse upload(String videoPath) throws Exception {
        return this.upload(videoPath, null, null);
    }

    public VodUploadCommitResponse upload(String videoPath, String coverPath) throws Exception {
        return this.upload(videoPath, coverPath, null);
    }

    public VodUploadCommitResponse upload(String videoPath, String coverPath, String procedure) throws Exception {
        VodParam param = new VodParam();
        param.setSecretId(this.secretId);
        param.setSecretKey(this.secretKey);
        param.setVideoPath(videoPath);
        param.setCoverPath(coverPath);
        param.setProcedure(procedure);
        VodApi.checkVodUploadParam(param);
        TreeMap<String, String> vodConfig = new TreeMap<String, String>();
        vodConfig.put("SecretId", param.getSecretId());
        vodConfig.put("SecretKey", param.getSecretKey());
        vodConfig.put("RequestMethod", "GET");
        QcloudApiModuleCenter moduleCenter = new QcloudApiModuleCenter((Base)new Vod(), vodConfig);
        VodUploadApplyResponse uploadApplyResponse = VodUpload.applyUpload(moduleCenter, param, this.retryTime);
        String uploadApplyResponseJson = JacksonUtil.toJSon(uploadApplyResponse);
        if (uploadApplyResponse.isFail()) {
            logger.error("apply upload fail, result={}", (Object)uploadApplyResponseJson);
            throw new VodHandleException("apply upload fail", uploadApplyResponseJson);
        }
        logger.info("apply upload success, result={}", (Object)uploadApplyResponseJson);
        TransferManager transferManager = VodUpload.getTransferManager(param, uploadApplyResponse, this.signExpired);
        try {
            VodCosConf videoConf = new VodCosConf(uploadApplyResponse.getStorageBucket(), uploadApplyResponse.getVideo().getStoragePath(), param.getVideoPath());
            VodUpload.uploadCos(transferManager, videoConf);
            logger.info("video upload cos success");
            if (param.getCoverPath() != null) {
                VodCosConf coverConf = new VodCosConf(uploadApplyResponse.getStorageBucket(), uploadApplyResponse.getCover().getStoragePath(), param.getCoverPath());
                VodUpload.uploadCos(transferManager, coverConf);
                logger.info("cover upload cos success");
            }
        }
        catch (Exception e) {
            logger.error("upload cos fail", (Throwable)e);
            throw e;
        }
        finally {
            transferManager.shutdownNow();
        }
        VodUploadCommitResponse uploadCommitResponse = VodUpload.commitUpload(moduleCenter, uploadApplyResponse, this.retryTime);
        String uploadCommitResponseJson = JacksonUtil.toJSon(uploadCommitResponse);
        if (uploadCommitResponse.isFail()) {
            logger.error("commit upload fail, result={}", (Object)uploadCommitResponseJson);
            throw new VodHandleException("commit upload fail", uploadApplyResponseJson);
        }
        logger.info("commit upload success, result={}", (Object)uploadCommitResponseJson);
        return uploadCommitResponse;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }
}

