/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.IntegerSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.IntValue;
import org.junit.Assert;

public class IntegerValueSummaryAggregatorTest
extends IntegerSummaryAggregatorTest {
    @Override
    protected NumericColumnSummary<Integer> summarize(Integer ... values) {
        IntValue[] intValues = new IntValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            intValues[i] = new IntValue(values[i].intValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<IntValue, NumericColumnSummary<Integer>, ValueSummaryAggregator.IntegerValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Integer> result1, NumericColumnSummary<Integer> result2) {
                Assert.assertEquals((long)result1.getTotalCount(), (long)result2.getTotalCount());
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getMissingCount(), (long)result2.getMissingCount());
                Assert.assertEquals((long)result1.getNonMissingCount(), (long)result2.getNonMissingCount());
                Assert.assertEquals((long)result1.getInfinityCount(), (long)result2.getInfinityCount());
                Assert.assertEquals((long)result1.getNanCount(), (long)result2.getNanCount());
                Assert.assertEquals((Object)result1.containsNull(), (Object)result2.containsNull());
                Assert.assertEquals((Object)result1.containsNonNull(), (Object)result2.containsNonNull());
                Assert.assertEquals((long)((Integer)result1.getMin()).intValue(), (long)((Integer)result2.getMin()).intValue());
                Assert.assertEquals((long)((Integer)result1.getMax()).intValue(), (long)((Integer)result2.getMax()).intValue());
                Assert.assertEquals((long)((Integer)result1.getSum()).intValue(), (long)((Integer)result2.getSum()).intValue());
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(intValues);
    }
}

