/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.RowCsvInputFormat;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.Row;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.StringParser;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RowCsvInputFormatTest {
    private static final Path PATH = new Path("an/ignored/file/");
    private static final String FIRST_PART = "That is the first part";
    private static final String SECOND_PART = "That is the second part";

    @Test
    public void ignoreInvalidLines() throws Exception {
        String fileContent = "#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.setLenient(false);
        Configuration parameters = new Configuration();
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        try {
            result = (Row)format.nextRecord((Object)result);
            Assert.fail((String)"Parse Exception was not thrown! (Row too short)");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            result = (Row)format.nextRecord((Object)result);
            Assert.fail((String)"Parse Exception was not thrown! (Invalid int value)");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"this is", (Object)result.getField(0));
        TestCase.assertEquals((Object)1, (Object)result.getField(1));
        TestCase.assertEquals((Object)2.0, (Object)result.getField(2));
        try {
            result = (Row)format.nextRecord((Object)result);
            Assert.fail((String)"Parse Exception was not thrown! (Row too short)");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"a test", (Object)result.getField(0));
        TestCase.assertEquals((Object)3, (Object)result.getField(1));
        TestCase.assertEquals((Object)4.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"#next", (Object)result.getField(0));
        TestCase.assertEquals((Object)5, (Object)result.getField(1));
        TestCase.assertEquals((Object)6.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        format.setLenient(true);
        format.configure(parameters);
        format.open(split);
        result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"header1", (Object)result.getField(0));
        Assert.assertNull((Object)result.getField(1));
        Assert.assertNull((Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"this is", (Object)result.getField(0));
        TestCase.assertEquals((Object)1, (Object)result.getField(1));
        TestCase.assertEquals((Object)2.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"a test", (Object)result.getField(0));
        TestCase.assertEquals((Object)3, (Object)result.getField(1));
        TestCase.assertEquals((Object)4.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"#next", (Object)result.getField(0));
        TestCase.assertEquals((Object)5, (Object)result.getField(1));
        TestCase.assertEquals((Object)6.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
    }

    @Test
    public void ignoreSingleCharPrefixComments() throws Exception {
        String fileContent = "#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.setCommentPrefix("#");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"this is", (Object)result.getField(0));
        TestCase.assertEquals((Object)1, (Object)result.getField(1));
        TestCase.assertEquals((Object)2.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"a test", (Object)result.getField(0));
        TestCase.assertEquals((Object)3, (Object)result.getField(1));
        TestCase.assertEquals((Object)4.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
    }

    @Test
    public void ignoreMultiCharPrefixComments() throws Exception {
        String fileContent = "//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.setCommentPrefix("//");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"this is", (Object)result.getField(0));
        TestCase.assertEquals((Object)1, (Object)result.getField(1));
        TestCase.assertEquals((Object)2.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"a test", (Object)result.getField(0));
        TestCase.assertEquals((Object)3, (Object)result.getField(1));
        TestCase.assertEquals((Object)4.0, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
    }

    @Test
    public void readStringFields() throws Exception {
        String fileContent = "abc|def|ghijk\nabc||hhg\n|||\n||";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"def", (Object)result.getField(1));
        TestCase.assertEquals((Object)"ghijk", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"hhg", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void readMixedQuotedStringFields() throws Exception {
        String fileContent = "@a|b|c@|def|@ghijk@\nabc||@|hhg@\n|||\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.configure(new Configuration());
        format.enableQuotedStringParsing('@');
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"a|b|c", (Object)result.getField(0));
        TestCase.assertEquals((Object)"def", (Object)result.getField(1));
        TestCase.assertEquals((Object)"ghijk", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"|hhg", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void readStringFieldsWithTrailingDelimiters() throws Exception {
        String fileContent = "abc|-def|-ghijk\nabc|-|-hhg\n|-|-|-\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.setFieldDelimiter("|-");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"def", (Object)result.getField(1));
        TestCase.assertEquals((Object)"ghijk", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"hhg", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testTailingEmptyFields() throws Exception {
        String fileContent = "abc|-def|-ghijk\nabc|-def|-\nabc|-|-\n|-|-|-\n|-|-\nabc|-def\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.setFieldDelimiter("|-");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"def", (Object)result.getField(1));
        TestCase.assertEquals((Object)"ghijk", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"def", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"abc", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)"", (Object)result.getField(0));
        TestCase.assertEquals((Object)"", (Object)result.getField(1));
        TestCase.assertEquals((Object)"", (Object)result.getField(2));
        try {
            format.nextRecord((Object)result);
            Assert.fail((String)"Parse Exception was not thrown! (Row too short)");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testIntegerFields() throws Exception {
        String fileContent = "111|222|333|444|555\n666|777|888|999|000|\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, "\n", "|");
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(5);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)111, (Object)result.getField(0));
        TestCase.assertEquals((Object)222, (Object)result.getField(1));
        TestCase.assertEquals((Object)333, (Object)result.getField(2));
        TestCase.assertEquals((Object)444, (Object)result.getField(3));
        TestCase.assertEquals((Object)555, (Object)result.getField(4));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)666, (Object)result.getField(0));
        TestCase.assertEquals((Object)777, (Object)result.getField(1));
        TestCase.assertEquals((Object)888, (Object)result.getField(2));
        TestCase.assertEquals((Object)999, (Object)result.getField(3));
        TestCase.assertEquals((Object)0, (Object)result.getField(4));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testEmptyFields() throws Exception {
        String fileContent = ",,,,,,,,\n,,,,,,,\n,,,,,,,,\n,,,,,,,\n,,,,,,,,\n,,,,,,,,\n,,,,,,,\n,,,,,,,,\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.BYTE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.FLOAT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.SHORT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, true);
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(8);
        int linesCnt = fileContent.split("\n").length;
        for (int i = 0; i < linesCnt; ++i) {
            result = (Row)format.nextRecord((Object)result);
            Assert.assertNull((Object)result.getField(i));
        }
        Assert.assertNull((Object)format.nextRecord((Object)result));
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testDoubleFields() throws Exception {
        String fileContent = "11.1|22.2|33.3|44.4|55.5\n66.6|77.7|88.8|99.9|00.0|\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes);
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(5);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)11.1, (Object)result.getField(0));
        TestCase.assertEquals((Object)22.2, (Object)result.getField(1));
        TestCase.assertEquals((Object)33.3, (Object)result.getField(2));
        TestCase.assertEquals((Object)44.4, (Object)result.getField(3));
        TestCase.assertEquals((Object)55.5, (Object)result.getField(4));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)66.6, (Object)result.getField(0));
        TestCase.assertEquals((Object)77.7, (Object)result.getField(1));
        TestCase.assertEquals((Object)88.8, (Object)result.getField(2));
        TestCase.assertEquals((Object)99.9, (Object)result.getField(3));
        TestCase.assertEquals((Object)0.0, (Object)result.getField(4));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testReadFirstN() throws Exception {
        String fileContent = "111|222|333|444|555|\n666|777|888|999|000|\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes);
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(2);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)111, (Object)result.getField(0));
        TestCase.assertEquals((Object)222, (Object)result.getField(1));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)666, (Object)result.getField(0));
        TestCase.assertEquals((Object)777, (Object)result.getField(1));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testReadSparseWithNullFieldsForTypes() throws Exception {
        String fileContent = "111|x|222|x|333|x|444|x|555|x|666|x|777|x|888|x|999|x|000|x|\n000|x|999|x|888|x|777|x|666|x|555|x|444|x|333|x|222|x|111|x|";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, new int[]{0, 3, 7});
        format.setFieldDelimiter("|x|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)111, (Object)result.getField(0));
        TestCase.assertEquals((Object)444, (Object)result.getField(1));
        TestCase.assertEquals((Object)888, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)0, (Object)result.getField(0));
        TestCase.assertEquals((Object)777, (Object)result.getField(1));
        TestCase.assertEquals((Object)333, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testReadSparseWithPositionSetter() throws Exception {
        String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, new int[]{0, 3, 7});
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)111, (Object)result.getField(0));
        TestCase.assertEquals((Object)444, (Object)result.getField(1));
        TestCase.assertEquals((Object)888, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)0, (Object)result.getField(0));
        TestCase.assertEquals((Object)777, (Object)result.getField(1));
        TestCase.assertEquals((Object)333, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testReadSparseWithMask() throws Exception {
        String fileContent = "111&&222&&333&&444&&555&&666&&777&&888&&999&&000&&\n000&&999&&888&&777&&666&&555&&444&&333&&222&&111&&";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, new int[]{0, 3, 7});
        format.setFieldDelimiter("&&");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)111, (Object)result.getField(0));
        TestCase.assertEquals((Object)444, (Object)result.getField(1));
        TestCase.assertEquals((Object)888, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)0, (Object)result.getField(0));
        TestCase.assertEquals((Object)777, (Object)result.getField(1));
        TestCase.assertEquals((Object)333, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testParseStringErrors() throws Exception {
        StringParser stringParser = new StringParser();
        stringParser.enableQuotedStringParsing((byte)34);
        HashMap<String, FieldParser.ParseErrorState> failures = new HashMap<String, FieldParser.ParseErrorState>();
        failures.put("\"string\" trailing", FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
        failures.put("\"unterminated ", FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
        for (Map.Entry failure : failures.entrySet()) {
            int result = stringParser.parseField(((String)failure.getKey()).getBytes(ConfigConstants.DEFAULT_CHARSET), 0, ((String)failure.getKey()).length(), new byte[]{124}, null);
            TestCase.assertEquals((int)-1, (int)result);
            TestCase.assertEquals(failure.getValue(), (Object)stringParser.getErrorState());
        }
    }

    @Test
    @Ignore(value="Test disabled because we do not support double-quote escaped quotes right now.")
    public void testParserCorrectness() throws Exception {
        Row[] expectedLines;
        String fileContent = "Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes);
        format.setSkipFirstLineAsHeader(true);
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(5);
        Row r1 = new Row(5);
        r1.setField(0, (Object)1997);
        r1.setField(1, (Object)"Ford");
        r1.setField(2, (Object)"E350");
        r1.setField(3, (Object)"ac, abs, moon");
        r1.setField(4, (Object)3000.0);
        Row r2 = new Row(5);
        r2.setField(0, (Object)1999);
        r2.setField(1, (Object)"Chevy");
        r2.setField(2, (Object)"Venture \"Extended Edition\"");
        r2.setField(3, (Object)"");
        r2.setField(4, (Object)4900.0);
        Row r3 = new Row(5);
        r3.setField(0, (Object)1996);
        r3.setField(1, (Object)"Jeep");
        r3.setField(2, (Object)"Grand Cherokee");
        r3.setField(3, (Object)"MUST SELL! air, moon roof, loaded");
        r3.setField(4, (Object)4799.0);
        Row r4 = new Row(5);
        r4.setField(0, (Object)1999);
        r4.setField(1, (Object)"Chevy");
        r4.setField(2, (Object)"Venture \"Extended Edition, Very Large\"");
        r4.setField(3, (Object)"");
        r4.setField(4, (Object)5000.0);
        Row r5 = new Row(5);
        r5.setField(0, (Object)0);
        r5.setField(1, (Object)"");
        r5.setField(2, (Object)"Venture \"Extended Edition\"");
        r5.setField(3, (Object)"");
        r5.setField(4, (Object)4900.0);
        for (Row expected : expectedLines = new Row[]{r1, r2, r3, r4, r5}) {
            result = (Row)format.nextRecord((Object)result);
            TestCase.assertEquals((Object)expected, (Object)result);
        }
        Assert.assertNull((Object)format.nextRecord((Object)result));
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testWindowsLineEndRemoval() throws Exception {
        RowCsvInputFormatTest.testRemovingTrailingCR("\n", "\n");
        RowCsvInputFormatTest.testRemovingTrailingCR("\r\n", "\r\n");
        RowCsvInputFormatTest.testRemovingTrailingCR("\r\n", "\n");
    }

    @Test
    public void testQuotedStringParsingWithIncludeFields() throws Exception {
        String fileContent = "\"20:41:52-1-3-2015\"|\"Re: Taskmanager memory error in Eclipse\"|\"Blahblah <blah@blahblah.org>\"|\"blaaa|\"blubb\"";
        File tempFile = File.createTempFile("CsvReaderQuotedString", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write(fileContent);
        writer.close();
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat inputFormat = new RowCsvInputFormat(new Path(tempFile.toURI().toString()), fieldTypes, new int[]{0, 2});
        inputFormat.enableQuotedStringParsing('\"');
        inputFormat.setFieldDelimiter("|");
        inputFormat.setDelimiter('\n');
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Row record = (Row)inputFormat.nextRecord((Object)new Row(2));
        TestCase.assertEquals((Object)"20:41:52-1-3-2015", (Object)record.getField(0));
        TestCase.assertEquals((Object)"Blahblah <blah@blahblah.org>", (Object)record.getField(1));
    }

    @Test
    public void testQuotedStringParsingWithEscapedQuotes() throws Exception {
        String fileContent = "\"\\\"Hello\\\" World\"|\"We are\\\" young\"";
        File tempFile = File.createTempFile("CsvReaderQuotedString", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write(fileContent);
        writer.close();
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat inputFormat = new RowCsvInputFormat(new Path(tempFile.toURI().toString()), fieldTypes);
        inputFormat.enableQuotedStringParsing('\"');
        inputFormat.setFieldDelimiter("|");
        inputFormat.setDelimiter('\n');
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Row record = (Row)inputFormat.nextRecord((Object)new Row(2));
        TestCase.assertEquals((Object)"\\\"Hello\\\" World", (Object)record.getField(0));
        TestCase.assertEquals((Object)"We are\\\" young", (Object)record.getField(1));
    }

    @Test
    public void testSqlTimeFields() throws Exception {
        String fileContent = "1990-10-14|02:42:25|1990-10-14 02:42:25.123|1990-1-4 2:2:5\n1990-10-14|02:42:25|1990-10-14 02:42:25.123|1990-1-4 2:2:5.3\n";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{SqlTimeTypeInfo.DATE, SqlTimeTypeInfo.TIME, SqlTimeTypeInfo.TIMESTAMP, SqlTimeTypeInfo.TIMESTAMP};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes);
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(4);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)Date.valueOf("1990-10-14"), (Object)result.getField(0));
        TestCase.assertEquals((Object)Time.valueOf("02:42:25"), (Object)result.getField(1));
        TestCase.assertEquals((Object)Timestamp.valueOf("1990-10-14 02:42:25.123"), (Object)result.getField(2));
        TestCase.assertEquals((Object)Timestamp.valueOf("1990-01-04 02:02:05"), (Object)result.getField(3));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)Date.valueOf("1990-10-14"), (Object)result.getField(0));
        TestCase.assertEquals((Object)Time.valueOf("02:42:25"), (Object)result.getField(1));
        TestCase.assertEquals((Object)Timestamp.valueOf("1990-10-14 02:42:25.123"), (Object)result.getField(2));
        TestCase.assertEquals((Object)Timestamp.valueOf("1990-01-04 02:02:05.3"), (Object)result.getField(3));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNull((Object)result);
        Assert.assertTrue((boolean)format.reachedEnd());
    }

    @Test
    public void testScanOrder() throws Exception {
        String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO};
        int[] order = new int[]{7, 3, 0};
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, fieldTypes, order);
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(3);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)888, (Object)result.getField(0));
        TestCase.assertEquals((Object)444, (Object)result.getField(1));
        TestCase.assertEquals((Object)111, (Object)result.getField(2));
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        TestCase.assertEquals((Object)333, (Object)result.getField(0));
        TestCase.assertEquals((Object)777, (Object)result.getField(1));
        TestCase.assertEquals((Object)0, (Object)result.getField(2));
    }

    @Test
    public void testEmptyProjection() throws Exception {
        String fileContent = "111|222|333\n000|999|888";
        FileInputSplit split = RowCsvInputFormatTest.createTempFile(fileContent);
        RowCsvInputFormat format = new RowCsvInputFormat(PATH, new TypeInformation[0], new int[0]);
        format.setFieldDelimiter("|");
        format.configure(new Configuration());
        format.open(split);
        Row result = new Row(0);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        result = (Row)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
    }

    private static FileInputSplit createTempFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);
        wrt.write(content);
        wrt.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private static void testRemovingTrailingCR(String lineBreakerInFile, String lineBreakerSetup) throws IOException {
        String fileContent = FIRST_PART + lineBreakerInFile + SECOND_PART + lineBreakerInFile;
        File tempFile = File.createTempFile("CsvInputFormatTest", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write(fileContent);
        wrt.close();
        TypeInformation[] fieldTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO};
        RowCsvInputFormat inputFormat = new RowCsvInputFormat(new Path(tempFile.toURI().toString()), fieldTypes);
        inputFormat.configure(new Configuration());
        inputFormat.setDelimiter(lineBreakerSetup);
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Row result = (Row)inputFormat.nextRecord((Object)new Row(1));
        Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
        TestCase.assertEquals((Object)FIRST_PART, (Object)result.getField(0));
        result = (Row)inputFormat.nextRecord((Object)result);
        Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
        TestCase.assertEquals((Object)SECOND_PART, (Object)result.getField(0));
    }
}

