/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.flink.api.java.io.PrintingOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrintingOutputFormatTest {
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;
    private final ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream arrayErrorStream = new ByteArrayOutputStream();
    private final String line = System.lineSeparator();

    @Before
    public void setUp() {
        System.setOut(new PrintStream(this.arrayOutputStream));
        System.setErr(new PrintStream(this.arrayErrorStream));
    }

    @After
    public void tearDown() {
        if (System.out != this.originalSystemOut) {
            System.out.close();
        }
        if (System.err != this.originalSystemErr) {
            System.err.close();
        }
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    @Test
    public void testPrintOutputFormatStdOut() throws Exception {
        PrintingOutputFormat printSink = new PrintingOutputFormat();
        printSink.open(0, 1);
        printSink.writeRecord((Object)"hello world!");
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintOutputFormatStdErr() throws Exception {
        PrintingOutputFormat printSink = new PrintingOutputFormat(true);
        printSink.open(0, 1);
        printSink.writeRecord((Object)"hello world!");
        Assert.assertEquals((Object)"Print to System.err", (Object)printSink.toString());
        Assert.assertEquals((Object)("hello world!" + this.line), (Object)this.arrayErrorStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintOutputFormatWithPrefix() throws Exception {
        PrintingOutputFormat printSink = new PrintingOutputFormat();
        printSink.open(1, 2);
        printSink.writeRecord((Object)"hello world!");
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("2> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintOutputFormatWithIdentifierAndPrefix() throws Exception {
        PrintingOutputFormat printSink = new PrintingOutputFormat("mySink", false);
        printSink.open(1, 2);
        printSink.writeRecord((Object)"hello world!");
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("mySink:2> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }

    @Test
    public void testPrintOutputFormatWithIdentifierButNoPrefix() throws Exception {
        PrintingOutputFormat printSink = new PrintingOutputFormat("mySink", false);
        printSink.open(0, 1);
        printSink.writeRecord((Object)"hello world!");
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("mySink> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        printSink.close();
    }
}

