/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.junit.Assert;
import org.junit.Test;

public class SemanticPropertiesPrecedenceTest {
    @Test
    public void testFunctionForwardedAnnotationPrecedence() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)3L, (Object)"test", (Object)42)});
        input.map(new WildcardForwardedMapperWithForwardAnnotation()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 1);
        FieldSet fw3 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertNotNull((Object)fw3);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
        Assert.assertFalse((boolean)fw2.contains(Integer.valueOf(1)));
        Assert.assertFalse((boolean)fw3.contains(Integer.valueOf(2)));
    }

    @Test
    public void testFunctionApiPrecedence() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)3L, (Object)"test", (Object)42)});
        ((MapOperator)input.map(new WildcardForwardedMapper()).withForwardedFields(new String[]{"f0"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 1);
        FieldSet fw3 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertNotNull((Object)fw3);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
        Assert.assertFalse((boolean)fw2.contains(Integer.valueOf(1)));
        Assert.assertFalse((boolean)fw3.contains(Integer.valueOf(2)));
    }

    private static class WildcardForwardedMapper<T>
    implements MapFunction<T, T> {
        private WildcardForwardedMapper() {
        }

        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0"})
    private static class WildcardForwardedMapperWithForwardAnnotation<T>
    implements MapFunction<T, T> {
        private WildcardForwardedMapperWithForwardAnnotation() {
        }

        public T map(T value) {
            return value;
        }
    }
}

